/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrAction;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHapticActionInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ACTION;
    public static final int SUBACTIONPATH;

    public XrHapticActionInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrHapticActionInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHapticActionInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrHapticActionInfo.nnext(this.address());
    }

    @NativeType(value="XrAction")
    public long action() {
        return XrHapticActionInfo.naction(this.address());
    }

    @NativeType(value="XrPath")
    public long subactionPath() {
        return XrHapticActionInfo.nsubactionPath(this.address());
    }

    public XrHapticActionInfo type(@NativeType(value="XrStructureType") int value) {
        XrHapticActionInfo.ntype(this.address(), value);
        return this;
    }

    public XrHapticActionInfo type$Default() {
        return this.type(59);
    }

    public XrHapticActionInfo next(@NativeType(value="void const *") long value) {
        XrHapticActionInfo.nnext(this.address(), value);
        return this;
    }

    public XrHapticActionInfo action(XrAction value) {
        XrHapticActionInfo.naction(this.address(), value);
        return this;
    }

    public XrHapticActionInfo subactionPath(@NativeType(value="XrPath") long value) {
        XrHapticActionInfo.nsubactionPath(this.address(), value);
        return this;
    }

    public XrHapticActionInfo set(int type, long next, XrAction action, long subactionPath) {
        this.type(type);
        this.next(next);
        this.action(action);
        this.subactionPath(subactionPath);
        return this;
    }

    public XrHapticActionInfo set(XrHapticActionInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrHapticActionInfo malloc() {
        return XrHapticActionInfo.wrap(XrHapticActionInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrHapticActionInfo calloc() {
        return XrHapticActionInfo.wrap(XrHapticActionInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrHapticActionInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrHapticActionInfo.wrap(XrHapticActionInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static XrHapticActionInfo create(long address) {
        return XrHapticActionInfo.wrap(XrHapticActionInfo.class, address);
    }

    @Nullable
    public static XrHapticActionInfo createSafe(long address) {
        return address == 0L ? null : XrHapticActionInfo.wrap(XrHapticActionInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrHapticActionInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrHapticActionInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrHapticActionInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHapticActionInfo.__create(capacity, SIZEOF);
        return XrHapticActionInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrHapticActionInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrHapticActionInfo.wrap(Buffer.class, address, capacity);
    }

    public static XrHapticActionInfo malloc(MemoryStack stack) {
        return XrHapticActionInfo.wrap(XrHapticActionInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrHapticActionInfo calloc(MemoryStack stack) {
        return XrHapticActionInfo.wrap(XrHapticActionInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrHapticActionInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrHapticActionInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long naction(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)ACTION);
    }

    public static long nsubactionPath(long struct) {
        return UNSAFE.getLong(null, struct + (long)SUBACTIONPATH);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void naction(long struct, XrAction value) {
        MemoryUtil.memPutAddress(struct + (long)ACTION, value.address());
    }

    public static void nsubactionPath(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SUBACTIONPATH, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)ACTION));
    }

    static {
        Struct.Layout layout = XrHapticActionInfo.__struct(XrHapticActionInfo.__member(4), XrHapticActionInfo.__member(POINTER_SIZE), XrHapticActionInfo.__member(POINTER_SIZE), XrHapticActionInfo.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ACTION = layout.offsetof(2);
        SUBACTIONPATH = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrHapticActionInfo, Buffer>
    implements NativeResource {
        private static final XrHapticActionInfo ELEMENT_FACTORY = XrHapticActionInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrHapticActionInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHapticActionInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrHapticActionInfo.nnext(this.address());
        }

        @NativeType(value="XrAction")
        public long action() {
            return XrHapticActionInfo.naction(this.address());
        }

        @NativeType(value="XrPath")
        public long subactionPath() {
            return XrHapticActionInfo.nsubactionPath(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHapticActionInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(59);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrHapticActionInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer action(XrAction value) {
            XrHapticActionInfo.naction(this.address(), value);
            return this;
        }

        public Buffer subactionPath(@NativeType(value="XrPath") long value) {
            XrHapticActionInfo.nsubactionPath(this.address(), value);
            return this;
        }
    }
}

