/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrLoaderInitInfoBaseHeaderKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    public XrLoaderInitInfoBaseHeaderKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrLoaderInitInfoBaseHeaderKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrLoaderInitInfoBaseHeaderKHR.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrLoaderInitInfoBaseHeaderKHR.nnext(this.address());
    }

    public XrLoaderInitInfoBaseHeaderKHR type(@NativeType(value="XrStructureType") int value) {
        XrLoaderInitInfoBaseHeaderKHR.ntype(this.address(), value);
        return this;
    }

    public XrLoaderInitInfoBaseHeaderKHR next(@NativeType(value="void const *") long value) {
        XrLoaderInitInfoBaseHeaderKHR.nnext(this.address(), value);
        return this;
    }

    public XrLoaderInitInfoBaseHeaderKHR set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrLoaderInitInfoBaseHeaderKHR set(XrLoaderInitInfoBaseHeaderKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrLoaderInitInfoBaseHeaderKHR malloc() {
        return XrLoaderInitInfoBaseHeaderKHR.wrap(XrLoaderInitInfoBaseHeaderKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrLoaderInitInfoBaseHeaderKHR calloc() {
        return XrLoaderInitInfoBaseHeaderKHR.wrap(XrLoaderInitInfoBaseHeaderKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrLoaderInitInfoBaseHeaderKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrLoaderInitInfoBaseHeaderKHR.wrap(XrLoaderInitInfoBaseHeaderKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static XrLoaderInitInfoBaseHeaderKHR create(long address) {
        return XrLoaderInitInfoBaseHeaderKHR.wrap(XrLoaderInitInfoBaseHeaderKHR.class, address);
    }

    @Nullable
    public static XrLoaderInitInfoBaseHeaderKHR createSafe(long address) {
        return address == 0L ? null : XrLoaderInitInfoBaseHeaderKHR.wrap(XrLoaderInitInfoBaseHeaderKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrLoaderInitInfoBaseHeaderKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrLoaderInitInfoBaseHeaderKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrLoaderInitInfoBaseHeaderKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrLoaderInitInfoBaseHeaderKHR.__create(capacity, SIZEOF);
        return XrLoaderInitInfoBaseHeaderKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrLoaderInitInfoBaseHeaderKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrLoaderInitInfoBaseHeaderKHR.wrap(Buffer.class, address, capacity);
    }

    public static XrLoaderInitInfoBaseHeaderKHR malloc(MemoryStack stack) {
        return XrLoaderInitInfoBaseHeaderKHR.wrap(XrLoaderInitInfoBaseHeaderKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrLoaderInitInfoBaseHeaderKHR calloc(MemoryStack stack) {
        return XrLoaderInitInfoBaseHeaderKHR.wrap(XrLoaderInitInfoBaseHeaderKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrLoaderInitInfoBaseHeaderKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrLoaderInitInfoBaseHeaderKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrLoaderInitInfoBaseHeaderKHR.__struct(XrLoaderInitInfoBaseHeaderKHR.__member(4), XrLoaderInitInfoBaseHeaderKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrLoaderInitInfoBaseHeaderKHR, Buffer>
    implements NativeResource {
        private static final XrLoaderInitInfoBaseHeaderKHR ELEMENT_FACTORY = XrLoaderInitInfoBaseHeaderKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrLoaderInitInfoBaseHeaderKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrLoaderInitInfoBaseHeaderKHR.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrLoaderInitInfoBaseHeaderKHR.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrLoaderInitInfoBaseHeaderKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrLoaderInitInfoBaseHeaderKHR.nnext(this.address(), value);
            return this;
        }
    }
}

