/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSceneBoundsMSFT;
import org.lwjgl.openxr.XrVisualMeshComputeLodInfoMSFT;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrNewSceneComputeInfoMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int REQUESTEDFEATURECOUNT;
    public static final int REQUESTEDFEATURES;
    public static final int CONSISTENCY;
    public static final int BOUNDS;

    public XrNewSceneComputeInfoMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrNewSceneComputeInfoMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrNewSceneComputeInfoMSFT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrNewSceneComputeInfoMSFT.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int requestedFeatureCount() {
        return XrNewSceneComputeInfoMSFT.nrequestedFeatureCount(this.address());
    }

    @NativeType(value="XrSceneComputeFeatureMSFT const *")
    public IntBuffer requestedFeatures() {
        return XrNewSceneComputeInfoMSFT.nrequestedFeatures(this.address());
    }

    @NativeType(value="XrSceneComputeConsistencyMSFT")
    public int consistency() {
        return XrNewSceneComputeInfoMSFT.nconsistency(this.address());
    }

    public XrSceneBoundsMSFT bounds() {
        return XrNewSceneComputeInfoMSFT.nbounds(this.address());
    }

    public XrNewSceneComputeInfoMSFT type(@NativeType(value="XrStructureType") int value) {
        XrNewSceneComputeInfoMSFT.ntype(this.address(), value);
        return this;
    }

    public XrNewSceneComputeInfoMSFT type$Default() {
        return this.type(1000097002);
    }

    public XrNewSceneComputeInfoMSFT next(@NativeType(value="void const *") long value) {
        XrNewSceneComputeInfoMSFT.nnext(this.address(), value);
        return this;
    }

    public XrNewSceneComputeInfoMSFT next(XrVisualMeshComputeLodInfoMSFT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrNewSceneComputeInfoMSFT requestedFeatures(@NativeType(value="XrSceneComputeFeatureMSFT const *") IntBuffer value) {
        XrNewSceneComputeInfoMSFT.nrequestedFeatures(this.address(), value);
        return this;
    }

    public XrNewSceneComputeInfoMSFT consistency(@NativeType(value="XrSceneComputeConsistencyMSFT") int value) {
        XrNewSceneComputeInfoMSFT.nconsistency(this.address(), value);
        return this;
    }

    public XrNewSceneComputeInfoMSFT bounds(XrSceneBoundsMSFT value) {
        XrNewSceneComputeInfoMSFT.nbounds(this.address(), value);
        return this;
    }

    public XrNewSceneComputeInfoMSFT bounds(Consumer<XrSceneBoundsMSFT> consumer) {
        consumer.accept(this.bounds());
        return this;
    }

    public XrNewSceneComputeInfoMSFT set(int type, long next, IntBuffer requestedFeatures, int consistency, XrSceneBoundsMSFT bounds) {
        this.type(type);
        this.next(next);
        this.requestedFeatures(requestedFeatures);
        this.consistency(consistency);
        this.bounds(bounds);
        return this;
    }

    public XrNewSceneComputeInfoMSFT set(XrNewSceneComputeInfoMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrNewSceneComputeInfoMSFT malloc() {
        return XrNewSceneComputeInfoMSFT.wrap(XrNewSceneComputeInfoMSFT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrNewSceneComputeInfoMSFT calloc() {
        return XrNewSceneComputeInfoMSFT.wrap(XrNewSceneComputeInfoMSFT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrNewSceneComputeInfoMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrNewSceneComputeInfoMSFT.wrap(XrNewSceneComputeInfoMSFT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrNewSceneComputeInfoMSFT create(long address) {
        return XrNewSceneComputeInfoMSFT.wrap(XrNewSceneComputeInfoMSFT.class, address);
    }

    @Nullable
    public static XrNewSceneComputeInfoMSFT createSafe(long address) {
        return address == 0L ? null : XrNewSceneComputeInfoMSFT.wrap(XrNewSceneComputeInfoMSFT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrNewSceneComputeInfoMSFT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrNewSceneComputeInfoMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrNewSceneComputeInfoMSFT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrNewSceneComputeInfoMSFT.__create(capacity, SIZEOF);
        return XrNewSceneComputeInfoMSFT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrNewSceneComputeInfoMSFT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrNewSceneComputeInfoMSFT.wrap(Buffer.class, address, capacity);
    }

    public static XrNewSceneComputeInfoMSFT malloc(MemoryStack stack) {
        return XrNewSceneComputeInfoMSFT.wrap(XrNewSceneComputeInfoMSFT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrNewSceneComputeInfoMSFT calloc(MemoryStack stack) {
        return XrNewSceneComputeInfoMSFT.wrap(XrNewSceneComputeInfoMSFT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrNewSceneComputeInfoMSFT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrNewSceneComputeInfoMSFT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nrequestedFeatureCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)REQUESTEDFEATURECOUNT);
    }

    public static IntBuffer nrequestedFeatures(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)REQUESTEDFEATURES), XrNewSceneComputeInfoMSFT.nrequestedFeatureCount(struct));
    }

    public static int nconsistency(long struct) {
        return UNSAFE.getInt(null, struct + (long)CONSISTENCY);
    }

    public static XrSceneBoundsMSFT nbounds(long struct) {
        return XrSceneBoundsMSFT.create(struct + (long)BOUNDS);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nrequestedFeatureCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)REQUESTEDFEATURECOUNT, value);
    }

    public static void nrequestedFeatures(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)REQUESTEDFEATURES, MemoryUtil.memAddress(value));
        XrNewSceneComputeInfoMSFT.nrequestedFeatureCount(struct, value.remaining());
    }

    public static void nconsistency(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CONSISTENCY, value);
    }

    public static void nbounds(long struct, XrSceneBoundsMSFT value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BOUNDS, XrSceneBoundsMSFT.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)REQUESTEDFEATURES));
        XrSceneBoundsMSFT.validate(struct + (long)BOUNDS);
    }

    static {
        Struct.Layout layout = XrNewSceneComputeInfoMSFT.__struct(XrNewSceneComputeInfoMSFT.__member(4), XrNewSceneComputeInfoMSFT.__member(POINTER_SIZE), XrNewSceneComputeInfoMSFT.__member(4), XrNewSceneComputeInfoMSFT.__member(POINTER_SIZE), XrNewSceneComputeInfoMSFT.__member(4), XrNewSceneComputeInfoMSFT.__member(XrSceneBoundsMSFT.SIZEOF, XrSceneBoundsMSFT.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        REQUESTEDFEATURECOUNT = layout.offsetof(2);
        REQUESTEDFEATURES = layout.offsetof(3);
        CONSISTENCY = layout.offsetof(4);
        BOUNDS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrNewSceneComputeInfoMSFT, Buffer>
    implements NativeResource {
        private static final XrNewSceneComputeInfoMSFT ELEMENT_FACTORY = XrNewSceneComputeInfoMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrNewSceneComputeInfoMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrNewSceneComputeInfoMSFT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrNewSceneComputeInfoMSFT.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int requestedFeatureCount() {
            return XrNewSceneComputeInfoMSFT.nrequestedFeatureCount(this.address());
        }

        @NativeType(value="XrSceneComputeFeatureMSFT const *")
        public IntBuffer requestedFeatures() {
            return XrNewSceneComputeInfoMSFT.nrequestedFeatures(this.address());
        }

        @NativeType(value="XrSceneComputeConsistencyMSFT")
        public int consistency() {
            return XrNewSceneComputeInfoMSFT.nconsistency(this.address());
        }

        public XrSceneBoundsMSFT bounds() {
            return XrNewSceneComputeInfoMSFT.nbounds(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrNewSceneComputeInfoMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000097002);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrNewSceneComputeInfoMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrVisualMeshComputeLodInfoMSFT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer requestedFeatures(@NativeType(value="XrSceneComputeFeatureMSFT const *") IntBuffer value) {
            XrNewSceneComputeInfoMSFT.nrequestedFeatures(this.address(), value);
            return this;
        }

        public Buffer consistency(@NativeType(value="XrSceneComputeConsistencyMSFT") int value) {
            XrNewSceneComputeInfoMSFT.nconsistency(this.address(), value);
            return this;
        }

        public Buffer bounds(XrSceneBoundsMSFT value) {
            XrNewSceneComputeInfoMSFT.nbounds(this.address(), value);
            return this;
        }

        public Buffer bounds(Consumer<XrSceneBoundsMSFT> consumer) {
            consumer.accept(this.bounds());
            return this;
        }
    }
}

