/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrOffset2Di
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    public XrOffset2Di(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrOffset2Di.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int32_t")
    public int x() {
        return XrOffset2Di.nx(this.address());
    }

    @NativeType(value="int32_t")
    public int y() {
        return XrOffset2Di.ny(this.address());
    }

    public XrOffset2Di x(@NativeType(value="int32_t") int value) {
        XrOffset2Di.nx(this.address(), value);
        return this;
    }

    public XrOffset2Di y(@NativeType(value="int32_t") int value) {
        XrOffset2Di.ny(this.address(), value);
        return this;
    }

    public XrOffset2Di set(int x, int y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public XrOffset2Di set(XrOffset2Di src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrOffset2Di malloc() {
        return XrOffset2Di.wrap(XrOffset2Di.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrOffset2Di calloc() {
        return XrOffset2Di.wrap(XrOffset2Di.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrOffset2Di create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrOffset2Di.wrap(XrOffset2Di.class, MemoryUtil.memAddress(container), container);
    }

    public static XrOffset2Di create(long address) {
        return XrOffset2Di.wrap(XrOffset2Di.class, address);
    }

    @Nullable
    public static XrOffset2Di createSafe(long address) {
        return address == 0L ? null : XrOffset2Di.wrap(XrOffset2Di.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrOffset2Di.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrOffset2Di.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrOffset2Di.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrOffset2Di.__create(capacity, SIZEOF);
        return XrOffset2Di.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrOffset2Di.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrOffset2Di.wrap(Buffer.class, address, capacity);
    }

    public static XrOffset2Di malloc(MemoryStack stack) {
        return XrOffset2Di.wrap(XrOffset2Di.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrOffset2Di calloc(MemoryStack stack) {
        return XrOffset2Di.wrap(XrOffset2Di.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrOffset2Di.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrOffset2Di.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nx(long struct) {
        return UNSAFE.getInt(null, struct + (long)X);
    }

    public static int ny(long struct) {
        return UNSAFE.getInt(null, struct + (long)Y);
    }

    public static void nx(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)X, value);
    }

    public static void ny(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = XrOffset2Di.__struct(XrOffset2Di.__member(4), XrOffset2Di.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrOffset2Di, Buffer>
    implements NativeResource {
        private static final XrOffset2Di ELEMENT_FACTORY = XrOffset2Di.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrOffset2Di getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int32_t")
        public int x() {
            return XrOffset2Di.nx(this.address());
        }

        @NativeType(value="int32_t")
        public int y() {
            return XrOffset2Di.ny(this.address());
        }

        public Buffer x(@NativeType(value="int32_t") int value) {
            XrOffset2Di.nx(this.address(), value);
            return this;
        }

        public Buffer y(@NativeType(value="int32_t") int value) {
            XrOffset2Di.ny(this.address(), value);
            return this;
        }
    }
}

