/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrColor4f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrPassthroughStyleFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int TEXTUREOPACITYFACTOR;
    public static final int EDGECOLOR;

    public XrPassthroughStyleFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrPassthroughStyleFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrPassthroughStyleFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrPassthroughStyleFB.nnext(this.address());
    }

    public float textureOpacityFactor() {
        return XrPassthroughStyleFB.ntextureOpacityFactor(this.address());
    }

    public XrColor4f edgeColor() {
        return XrPassthroughStyleFB.nedgeColor(this.address());
    }

    public XrPassthroughStyleFB type(@NativeType(value="XrStructureType") int value) {
        XrPassthroughStyleFB.ntype(this.address(), value);
        return this;
    }

    public XrPassthroughStyleFB type$Default() {
        return this.type(1000118020);
    }

    public XrPassthroughStyleFB next(@NativeType(value="void const *") long value) {
        XrPassthroughStyleFB.nnext(this.address(), value);
        return this;
    }

    public XrPassthroughStyleFB textureOpacityFactor(float value) {
        XrPassthroughStyleFB.ntextureOpacityFactor(this.address(), value);
        return this;
    }

    public XrPassthroughStyleFB edgeColor(XrColor4f value) {
        XrPassthroughStyleFB.nedgeColor(this.address(), value);
        return this;
    }

    public XrPassthroughStyleFB edgeColor(Consumer<XrColor4f> consumer) {
        consumer.accept(this.edgeColor());
        return this;
    }

    public XrPassthroughStyleFB set(int type, long next, float textureOpacityFactor, XrColor4f edgeColor) {
        this.type(type);
        this.next(next);
        this.textureOpacityFactor(textureOpacityFactor);
        this.edgeColor(edgeColor);
        return this;
    }

    public XrPassthroughStyleFB set(XrPassthroughStyleFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrPassthroughStyleFB malloc() {
        return XrPassthroughStyleFB.wrap(XrPassthroughStyleFB.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrPassthroughStyleFB calloc() {
        return XrPassthroughStyleFB.wrap(XrPassthroughStyleFB.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrPassthroughStyleFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrPassthroughStyleFB.wrap(XrPassthroughStyleFB.class, MemoryUtil.memAddress(container), container);
    }

    public static XrPassthroughStyleFB create(long address) {
        return XrPassthroughStyleFB.wrap(XrPassthroughStyleFB.class, address);
    }

    @Nullable
    public static XrPassthroughStyleFB createSafe(long address) {
        return address == 0L ? null : XrPassthroughStyleFB.wrap(XrPassthroughStyleFB.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrPassthroughStyleFB.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrPassthroughStyleFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrPassthroughStyleFB.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrPassthroughStyleFB.__create(capacity, SIZEOF);
        return XrPassthroughStyleFB.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrPassthroughStyleFB.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrPassthroughStyleFB.wrap(Buffer.class, address, capacity);
    }

    public static XrPassthroughStyleFB malloc(MemoryStack stack) {
        return XrPassthroughStyleFB.wrap(XrPassthroughStyleFB.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrPassthroughStyleFB calloc(MemoryStack stack) {
        return XrPassthroughStyleFB.wrap(XrPassthroughStyleFB.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrPassthroughStyleFB.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrPassthroughStyleFB.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static float ntextureOpacityFactor(long struct) {
        return UNSAFE.getFloat(null, struct + (long)TEXTUREOPACITYFACTOR);
    }

    public static XrColor4f nedgeColor(long struct) {
        return XrColor4f.create(struct + (long)EDGECOLOR);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void ntextureOpacityFactor(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)TEXTUREOPACITYFACTOR, value);
    }

    public static void nedgeColor(long struct, XrColor4f value) {
        MemoryUtil.memCopy(value.address(), struct + (long)EDGECOLOR, XrColor4f.SIZEOF);
    }

    static {
        Struct.Layout layout = XrPassthroughStyleFB.__struct(XrPassthroughStyleFB.__member(4), XrPassthroughStyleFB.__member(POINTER_SIZE), XrPassthroughStyleFB.__member(4), XrPassthroughStyleFB.__member(XrColor4f.SIZEOF, XrColor4f.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        TEXTUREOPACITYFACTOR = layout.offsetof(2);
        EDGECOLOR = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrPassthroughStyleFB, Buffer>
    implements NativeResource {
        private static final XrPassthroughStyleFB ELEMENT_FACTORY = XrPassthroughStyleFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrPassthroughStyleFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrPassthroughStyleFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrPassthroughStyleFB.nnext(this.address());
        }

        public float textureOpacityFactor() {
            return XrPassthroughStyleFB.ntextureOpacityFactor(this.address());
        }

        public XrColor4f edgeColor() {
            return XrPassthroughStyleFB.nedgeColor(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrPassthroughStyleFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000118020);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrPassthroughStyleFB.nnext(this.address(), value);
            return this;
        }

        public Buffer textureOpacityFactor(float value) {
            XrPassthroughStyleFB.ntextureOpacityFactor(this.address(), value);
            return this;
        }

        public Buffer edgeColor(XrColor4f value) {
            XrPassthroughStyleFB.nedgeColor(this.address(), value);
            return this;
        }

        public Buffer edgeColor(Consumer<XrColor4f> consumer) {
            consumer.accept(this.edgeColor());
            return this;
        }
    }
}

