/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrQuaternionf
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;
    public static final int W;

    public XrQuaternionf(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrQuaternionf.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return XrQuaternionf.nx(this.address());
    }

    public float y() {
        return XrQuaternionf.ny(this.address());
    }

    public float z() {
        return XrQuaternionf.nz(this.address());
    }

    public float w() {
        return XrQuaternionf.nw(this.address());
    }

    public XrQuaternionf x(float value) {
        XrQuaternionf.nx(this.address(), value);
        return this;
    }

    public XrQuaternionf y(float value) {
        XrQuaternionf.ny(this.address(), value);
        return this;
    }

    public XrQuaternionf z(float value) {
        XrQuaternionf.nz(this.address(), value);
        return this;
    }

    public XrQuaternionf w(float value) {
        XrQuaternionf.nw(this.address(), value);
        return this;
    }

    public XrQuaternionf set(float x, float y, float z, float w) {
        this.x(x);
        this.y(y);
        this.z(z);
        this.w(w);
        return this;
    }

    public XrQuaternionf set(XrQuaternionf src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrQuaternionf malloc() {
        return XrQuaternionf.wrap(XrQuaternionf.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrQuaternionf calloc() {
        return XrQuaternionf.wrap(XrQuaternionf.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrQuaternionf create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrQuaternionf.wrap(XrQuaternionf.class, MemoryUtil.memAddress(container), container);
    }

    public static XrQuaternionf create(long address) {
        return XrQuaternionf.wrap(XrQuaternionf.class, address);
    }

    @Nullable
    public static XrQuaternionf createSafe(long address) {
        return address == 0L ? null : XrQuaternionf.wrap(XrQuaternionf.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrQuaternionf.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrQuaternionf.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrQuaternionf.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrQuaternionf.__create(capacity, SIZEOF);
        return XrQuaternionf.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrQuaternionf.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrQuaternionf.wrap(Buffer.class, address, capacity);
    }

    public static XrQuaternionf malloc(MemoryStack stack) {
        return XrQuaternionf.wrap(XrQuaternionf.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrQuaternionf calloc(MemoryStack stack) {
        return XrQuaternionf.wrap(XrQuaternionf.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrQuaternionf.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrQuaternionf.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return UNSAFE.getFloat(null, struct + (long)X);
    }

    public static float ny(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Y);
    }

    public static float nz(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Z);
    }

    public static float nw(long struct) {
        return UNSAFE.getFloat(null, struct + (long)W);
    }

    public static void nx(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Y, value);
    }

    public static void nz(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Z, value);
    }

    public static void nw(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)W, value);
    }

    static {
        Struct.Layout layout = XrQuaternionf.__struct(XrQuaternionf.__member(4), XrQuaternionf.__member(4), XrQuaternionf.__member(4), XrQuaternionf.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
        W = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrQuaternionf, Buffer>
    implements NativeResource {
        private static final XrQuaternionf ELEMENT_FACTORY = XrQuaternionf.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrQuaternionf getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return XrQuaternionf.nx(this.address());
        }

        public float y() {
            return XrQuaternionf.ny(this.address());
        }

        public float z() {
            return XrQuaternionf.nz(this.address());
        }

        public float w() {
            return XrQuaternionf.nw(this.address());
        }

        public Buffer x(float value) {
            XrQuaternionf.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            XrQuaternionf.ny(this.address(), value);
            return this;
        }

        public Buffer z(float value) {
            XrQuaternionf.nz(this.address(), value);
            return this;
        }

        public Buffer w(float value) {
            XrQuaternionf.nw(this.address(), value);
            return this;
        }
    }
}

