/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrExtent2Df;
import org.lwjgl.openxr.XrOffset2Df;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrRect2Df
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OFFSET;
    public static final int EXTENT;

    public XrRect2Df(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrRect2Df.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public XrOffset2Df offset() {
        return XrRect2Df.noffset(this.address());
    }

    public XrExtent2Df extent() {
        return XrRect2Df.nextent(this.address());
    }

    public XrRect2Df offset(XrOffset2Df value) {
        XrRect2Df.noffset(this.address(), value);
        return this;
    }

    public XrRect2Df offset(Consumer<XrOffset2Df> consumer) {
        consumer.accept(this.offset());
        return this;
    }

    public XrRect2Df extent(XrExtent2Df value) {
        XrRect2Df.nextent(this.address(), value);
        return this;
    }

    public XrRect2Df extent(Consumer<XrExtent2Df> consumer) {
        consumer.accept(this.extent());
        return this;
    }

    public XrRect2Df set(XrOffset2Df offset, XrExtent2Df extent) {
        this.offset(offset);
        this.extent(extent);
        return this;
    }

    public XrRect2Df set(XrRect2Df src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrRect2Df malloc() {
        return XrRect2Df.wrap(XrRect2Df.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrRect2Df calloc() {
        return XrRect2Df.wrap(XrRect2Df.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrRect2Df create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrRect2Df.wrap(XrRect2Df.class, MemoryUtil.memAddress(container), container);
    }

    public static XrRect2Df create(long address) {
        return XrRect2Df.wrap(XrRect2Df.class, address);
    }

    @Nullable
    public static XrRect2Df createSafe(long address) {
        return address == 0L ? null : XrRect2Df.wrap(XrRect2Df.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrRect2Df.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrRect2Df.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrRect2Df.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrRect2Df.__create(capacity, SIZEOF);
        return XrRect2Df.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrRect2Df.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrRect2Df.wrap(Buffer.class, address, capacity);
    }

    public static XrRect2Df malloc(MemoryStack stack) {
        return XrRect2Df.wrap(XrRect2Df.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrRect2Df calloc(MemoryStack stack) {
        return XrRect2Df.wrap(XrRect2Df.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrRect2Df.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrRect2Df.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static XrOffset2Df noffset(long struct) {
        return XrOffset2Df.create(struct + (long)OFFSET);
    }

    public static XrExtent2Df nextent(long struct) {
        return XrExtent2Df.create(struct + (long)EXTENT);
    }

    public static void noffset(long struct, XrOffset2Df value) {
        MemoryUtil.memCopy(value.address(), struct + (long)OFFSET, XrOffset2Df.SIZEOF);
    }

    public static void nextent(long struct, XrExtent2Df value) {
        MemoryUtil.memCopy(value.address(), struct + (long)EXTENT, XrExtent2Df.SIZEOF);
    }

    static {
        Struct.Layout layout = XrRect2Df.__struct(XrRect2Df.__member(XrOffset2Df.SIZEOF, XrOffset2Df.ALIGNOF), XrRect2Df.__member(XrExtent2Df.SIZEOF, XrExtent2Df.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OFFSET = layout.offsetof(0);
        EXTENT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrRect2Df, Buffer>
    implements NativeResource {
        private static final XrRect2Df ELEMENT_FACTORY = XrRect2Df.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrRect2Df getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public XrOffset2Df offset() {
            return XrRect2Df.noffset(this.address());
        }

        public XrExtent2Df extent() {
            return XrRect2Df.nextent(this.address());
        }

        public Buffer offset(XrOffset2Df value) {
            XrRect2Df.noffset(this.address(), value);
            return this;
        }

        public Buffer offset(Consumer<XrOffset2Df> consumer) {
            consumer.accept(this.offset());
            return this;
        }

        public Buffer extent(XrExtent2Df value) {
            XrRect2Df.nextent(this.address(), value);
            return this;
        }

        public Buffer extent(Consumer<XrExtent2Df> consumer) {
            consumer.accept(this.extent());
            return this;
        }
    }
}

