/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrRenderModelBufferFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int BUFFERCAPACITYINPUT;
    public static final int BUFFERCOUNTOUTPUT;
    public static final int BUFFER;

    public XrRenderModelBufferFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrRenderModelBufferFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrRenderModelBufferFB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrRenderModelBufferFB.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int bufferCapacityInput() {
        return XrRenderModelBufferFB.nbufferCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int bufferCountOutput() {
        return XrRenderModelBufferFB.nbufferCountOutput(this.address());
    }

    @Nullable
    @NativeType(value="uint8_t *")
    public ByteBuffer buffer() {
        return XrRenderModelBufferFB.nbuffer(this.address());
    }

    public XrRenderModelBufferFB type(@NativeType(value="XrStructureType") int value) {
        XrRenderModelBufferFB.ntype(this.address(), value);
        return this;
    }

    public XrRenderModelBufferFB type$Default() {
        return this.type(1000119002);
    }

    public XrRenderModelBufferFB next(@NativeType(value="void *") long value) {
        XrRenderModelBufferFB.nnext(this.address(), value);
        return this;
    }

    public XrRenderModelBufferFB bufferCapacityInput(@NativeType(value="uint32_t") int value) {
        XrRenderModelBufferFB.nbufferCapacityInput(this.address(), value);
        return this;
    }

    public XrRenderModelBufferFB bufferCountOutput(@NativeType(value="uint32_t") int value) {
        XrRenderModelBufferFB.nbufferCountOutput(this.address(), value);
        return this;
    }

    public XrRenderModelBufferFB buffer(@Nullable @NativeType(value="uint8_t *") ByteBuffer value) {
        XrRenderModelBufferFB.nbuffer(this.address(), value);
        return this;
    }

    public XrRenderModelBufferFB set(int type, long next, int bufferCapacityInput, int bufferCountOutput, @Nullable ByteBuffer buffer) {
        this.type(type);
        this.next(next);
        this.bufferCapacityInput(bufferCapacityInput);
        this.bufferCountOutput(bufferCountOutput);
        this.buffer(buffer);
        return this;
    }

    public XrRenderModelBufferFB set(XrRenderModelBufferFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrRenderModelBufferFB malloc() {
        return XrRenderModelBufferFB.wrap(XrRenderModelBufferFB.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrRenderModelBufferFB calloc() {
        return XrRenderModelBufferFB.wrap(XrRenderModelBufferFB.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrRenderModelBufferFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrRenderModelBufferFB.wrap(XrRenderModelBufferFB.class, MemoryUtil.memAddress(container), container);
    }

    public static XrRenderModelBufferFB create(long address) {
        return XrRenderModelBufferFB.wrap(XrRenderModelBufferFB.class, address);
    }

    @Nullable
    public static XrRenderModelBufferFB createSafe(long address) {
        return address == 0L ? null : XrRenderModelBufferFB.wrap(XrRenderModelBufferFB.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrRenderModelBufferFB.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrRenderModelBufferFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrRenderModelBufferFB.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrRenderModelBufferFB.__create(capacity, SIZEOF);
        return XrRenderModelBufferFB.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrRenderModelBufferFB.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrRenderModelBufferFB.wrap(Buffer.class, address, capacity);
    }

    public static XrRenderModelBufferFB malloc(MemoryStack stack) {
        return XrRenderModelBufferFB.wrap(XrRenderModelBufferFB.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrRenderModelBufferFB calloc(MemoryStack stack) {
        return XrRenderModelBufferFB.wrap(XrRenderModelBufferFB.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrRenderModelBufferFB.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrRenderModelBufferFB.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nbufferCapacityInput(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUFFERCAPACITYINPUT);
    }

    public static int nbufferCountOutput(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUFFERCOUNTOUTPUT);
    }

    @Nullable
    public static ByteBuffer nbuffer(long struct) {
        return MemoryUtil.memByteBufferSafe(MemoryUtil.memGetAddress(struct + (long)BUFFER), XrRenderModelBufferFB.nbufferCapacityInput(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nbufferCapacityInput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BUFFERCAPACITYINPUT, value);
    }

    public static void nbufferCountOutput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BUFFERCOUNTOUTPUT, value);
    }

    public static void nbuffer(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)BUFFER, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrRenderModelBufferFB.nbufferCapacityInput(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrRenderModelBufferFB.__struct(XrRenderModelBufferFB.__member(4), XrRenderModelBufferFB.__member(POINTER_SIZE), XrRenderModelBufferFB.__member(4), XrRenderModelBufferFB.__member(4), XrRenderModelBufferFB.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        BUFFERCAPACITYINPUT = layout.offsetof(2);
        BUFFERCOUNTOUTPUT = layout.offsetof(3);
        BUFFER = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrRenderModelBufferFB, Buffer>
    implements NativeResource {
        private static final XrRenderModelBufferFB ELEMENT_FACTORY = XrRenderModelBufferFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrRenderModelBufferFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrRenderModelBufferFB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrRenderModelBufferFB.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int bufferCapacityInput() {
            return XrRenderModelBufferFB.nbufferCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int bufferCountOutput() {
            return XrRenderModelBufferFB.nbufferCountOutput(this.address());
        }

        @Nullable
        @NativeType(value="uint8_t *")
        public ByteBuffer buffer() {
            return XrRenderModelBufferFB.nbuffer(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrRenderModelBufferFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000119002);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrRenderModelBufferFB.nnext(this.address(), value);
            return this;
        }

        public Buffer bufferCapacityInput(@NativeType(value="uint32_t") int value) {
            XrRenderModelBufferFB.nbufferCapacityInput(this.address(), value);
            return this;
        }

        public Buffer bufferCountOutput(@NativeType(value="uint32_t") int value) {
            XrRenderModelBufferFB.nbufferCountOutput(this.address(), value);
            return this;
        }

        public Buffer buffer(@Nullable @NativeType(value="uint8_t *") ByteBuffer value) {
            XrRenderModelBufferFB.nbuffer(this.address(), value);
            return this;
        }
    }
}

