/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrRenderModelLoadInfoFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int MODELKEY;

    public XrRenderModelLoadInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrRenderModelLoadInfoFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrRenderModelLoadInfoFB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrRenderModelLoadInfoFB.nnext(this.address());
    }

    @NativeType(value="XrRenderModelKeyFB")
    public long modelKey() {
        return XrRenderModelLoadInfoFB.nmodelKey(this.address());
    }

    public XrRenderModelLoadInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrRenderModelLoadInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrRenderModelLoadInfoFB type$Default() {
        return this.type(1000119003);
    }

    public XrRenderModelLoadInfoFB next(@NativeType(value="void *") long value) {
        XrRenderModelLoadInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrRenderModelLoadInfoFB modelKey(@NativeType(value="XrRenderModelKeyFB") long value) {
        XrRenderModelLoadInfoFB.nmodelKey(this.address(), value);
        return this;
    }

    public XrRenderModelLoadInfoFB set(int type, long next, long modelKey) {
        this.type(type);
        this.next(next);
        this.modelKey(modelKey);
        return this;
    }

    public XrRenderModelLoadInfoFB set(XrRenderModelLoadInfoFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrRenderModelLoadInfoFB malloc() {
        return XrRenderModelLoadInfoFB.wrap(XrRenderModelLoadInfoFB.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrRenderModelLoadInfoFB calloc() {
        return XrRenderModelLoadInfoFB.wrap(XrRenderModelLoadInfoFB.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrRenderModelLoadInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrRenderModelLoadInfoFB.wrap(XrRenderModelLoadInfoFB.class, MemoryUtil.memAddress(container), container);
    }

    public static XrRenderModelLoadInfoFB create(long address) {
        return XrRenderModelLoadInfoFB.wrap(XrRenderModelLoadInfoFB.class, address);
    }

    @Nullable
    public static XrRenderModelLoadInfoFB createSafe(long address) {
        return address == 0L ? null : XrRenderModelLoadInfoFB.wrap(XrRenderModelLoadInfoFB.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrRenderModelLoadInfoFB.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrRenderModelLoadInfoFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrRenderModelLoadInfoFB.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrRenderModelLoadInfoFB.__create(capacity, SIZEOF);
        return XrRenderModelLoadInfoFB.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrRenderModelLoadInfoFB.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrRenderModelLoadInfoFB.wrap(Buffer.class, address, capacity);
    }

    public static XrRenderModelLoadInfoFB malloc(MemoryStack stack) {
        return XrRenderModelLoadInfoFB.wrap(XrRenderModelLoadInfoFB.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrRenderModelLoadInfoFB calloc(MemoryStack stack) {
        return XrRenderModelLoadInfoFB.wrap(XrRenderModelLoadInfoFB.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrRenderModelLoadInfoFB.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrRenderModelLoadInfoFB.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nmodelKey(long struct) {
        return UNSAFE.getLong(null, struct + (long)MODELKEY);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nmodelKey(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MODELKEY, value);
    }

    static {
        Struct.Layout layout = XrRenderModelLoadInfoFB.__struct(XrRenderModelLoadInfoFB.__member(4), XrRenderModelLoadInfoFB.__member(POINTER_SIZE), XrRenderModelLoadInfoFB.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        MODELKEY = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrRenderModelLoadInfoFB, Buffer>
    implements NativeResource {
        private static final XrRenderModelLoadInfoFB ELEMENT_FACTORY = XrRenderModelLoadInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrRenderModelLoadInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrRenderModelLoadInfoFB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrRenderModelLoadInfoFB.nnext(this.address());
        }

        @NativeType(value="XrRenderModelKeyFB")
        public long modelKey() {
            return XrRenderModelLoadInfoFB.nmodelKey(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrRenderModelLoadInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000119003);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrRenderModelLoadInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer modelKey(@NativeType(value="XrRenderModelKeyFB") long value) {
            XrRenderModelLoadInfoFB.nmodelKey(this.address(), value);
            return this;
        }
    }
}

