/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneComponentLocationMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int POSE;

    public XrSceneComponentLocationMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSceneComponentLocationMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrSpaceLocationFlags")
    public long flags() {
        return XrSceneComponentLocationMSFT.nflags(this.address());
    }

    public XrPosef pose() {
        return XrSceneComponentLocationMSFT.npose(this.address());
    }

    public XrSceneComponentLocationMSFT flags(@NativeType(value="XrSpaceLocationFlags") long value) {
        XrSceneComponentLocationMSFT.nflags(this.address(), value);
        return this;
    }

    public XrSceneComponentLocationMSFT pose(XrPosef value) {
        XrSceneComponentLocationMSFT.npose(this.address(), value);
        return this;
    }

    public XrSceneComponentLocationMSFT pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrSceneComponentLocationMSFT set(long flags, XrPosef pose) {
        this.flags(flags);
        this.pose(pose);
        return this;
    }

    public XrSceneComponentLocationMSFT set(XrSceneComponentLocationMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSceneComponentLocationMSFT malloc() {
        return XrSceneComponentLocationMSFT.wrap(XrSceneComponentLocationMSFT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrSceneComponentLocationMSFT calloc() {
        return XrSceneComponentLocationMSFT.wrap(XrSceneComponentLocationMSFT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrSceneComponentLocationMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrSceneComponentLocationMSFT.wrap(XrSceneComponentLocationMSFT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrSceneComponentLocationMSFT create(long address) {
        return XrSceneComponentLocationMSFT.wrap(XrSceneComponentLocationMSFT.class, address);
    }

    @Nullable
    public static XrSceneComponentLocationMSFT createSafe(long address) {
        return address == 0L ? null : XrSceneComponentLocationMSFT.wrap(XrSceneComponentLocationMSFT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrSceneComponentLocationMSFT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrSceneComponentLocationMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrSceneComponentLocationMSFT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneComponentLocationMSFT.__create(capacity, SIZEOF);
        return XrSceneComponentLocationMSFT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrSceneComponentLocationMSFT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrSceneComponentLocationMSFT.wrap(Buffer.class, address, capacity);
    }

    public static XrSceneComponentLocationMSFT malloc(MemoryStack stack) {
        return XrSceneComponentLocationMSFT.wrap(XrSceneComponentLocationMSFT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSceneComponentLocationMSFT calloc(MemoryStack stack) {
        return XrSceneComponentLocationMSFT.wrap(XrSceneComponentLocationMSFT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrSceneComponentLocationMSFT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrSceneComponentLocationMSFT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nflags(long struct) {
        return UNSAFE.getLong(null, struct + (long)FLAGS);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static void nflags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)FLAGS, value);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSE, XrPosef.SIZEOF);
    }

    static {
        Struct.Layout layout = XrSceneComponentLocationMSFT.__struct(XrSceneComponentLocationMSFT.__member(8), XrSceneComponentLocationMSFT.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        POSE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrSceneComponentLocationMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneComponentLocationMSFT ELEMENT_FACTORY = XrSceneComponentLocationMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSceneComponentLocationMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrSpaceLocationFlags")
        public long flags() {
            return XrSceneComponentLocationMSFT.nflags(this.address());
        }

        public XrPosef pose() {
            return XrSceneComponentLocationMSFT.npose(this.address());
        }

        public Buffer flags(@NativeType(value="XrSpaceLocationFlags") long value) {
            XrSceneComponentLocationMSFT.nflags(this.address(), value);
            return this;
        }

        public Buffer pose(XrPosef value) {
            XrSceneComponentLocationMSFT.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }
    }
}

