/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrUuidMSFT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneComponentMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int COMPONENTTYPE;
    public static final int ID;
    public static final int PARENTID;
    public static final int UPDATETIME;

    public XrSceneComponentMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSceneComponentMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrSceneComponentTypeMSFT")
    public int componentType() {
        return XrSceneComponentMSFT.ncomponentType(this.address());
    }

    public XrUuidMSFT id() {
        return XrSceneComponentMSFT.nid(this.address());
    }

    public XrUuidMSFT parentId() {
        return XrSceneComponentMSFT.nparentId(this.address());
    }

    @NativeType(value="XrTime")
    public long updateTime() {
        return XrSceneComponentMSFT.nupdateTime(this.address());
    }

    public XrSceneComponentMSFT componentType(@NativeType(value="XrSceneComponentTypeMSFT") int value) {
        XrSceneComponentMSFT.ncomponentType(this.address(), value);
        return this;
    }

    public XrSceneComponentMSFT id(XrUuidMSFT value) {
        XrSceneComponentMSFT.nid(this.address(), value);
        return this;
    }

    public XrSceneComponentMSFT id(Consumer<XrUuidMSFT> consumer) {
        consumer.accept(this.id());
        return this;
    }

    public XrSceneComponentMSFT parentId(XrUuidMSFT value) {
        XrSceneComponentMSFT.nparentId(this.address(), value);
        return this;
    }

    public XrSceneComponentMSFT parentId(Consumer<XrUuidMSFT> consumer) {
        consumer.accept(this.parentId());
        return this;
    }

    public XrSceneComponentMSFT updateTime(@NativeType(value="XrTime") long value) {
        XrSceneComponentMSFT.nupdateTime(this.address(), value);
        return this;
    }

    public XrSceneComponentMSFT set(int componentType, XrUuidMSFT id, XrUuidMSFT parentId, long updateTime) {
        this.componentType(componentType);
        this.id(id);
        this.parentId(parentId);
        this.updateTime(updateTime);
        return this;
    }

    public XrSceneComponentMSFT set(XrSceneComponentMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSceneComponentMSFT malloc() {
        return XrSceneComponentMSFT.wrap(XrSceneComponentMSFT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrSceneComponentMSFT calloc() {
        return XrSceneComponentMSFT.wrap(XrSceneComponentMSFT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrSceneComponentMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrSceneComponentMSFT.wrap(XrSceneComponentMSFT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrSceneComponentMSFT create(long address) {
        return XrSceneComponentMSFT.wrap(XrSceneComponentMSFT.class, address);
    }

    @Nullable
    public static XrSceneComponentMSFT createSafe(long address) {
        return address == 0L ? null : XrSceneComponentMSFT.wrap(XrSceneComponentMSFT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrSceneComponentMSFT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrSceneComponentMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrSceneComponentMSFT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneComponentMSFT.__create(capacity, SIZEOF);
        return XrSceneComponentMSFT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrSceneComponentMSFT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrSceneComponentMSFT.wrap(Buffer.class, address, capacity);
    }

    public static XrSceneComponentMSFT malloc(MemoryStack stack) {
        return XrSceneComponentMSFT.wrap(XrSceneComponentMSFT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSceneComponentMSFT calloc(MemoryStack stack) {
        return XrSceneComponentMSFT.wrap(XrSceneComponentMSFT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrSceneComponentMSFT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrSceneComponentMSFT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ncomponentType(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMPONENTTYPE);
    }

    public static XrUuidMSFT nid(long struct) {
        return XrUuidMSFT.create(struct + (long)ID);
    }

    public static XrUuidMSFT nparentId(long struct) {
        return XrUuidMSFT.create(struct + (long)PARENTID);
    }

    public static long nupdateTime(long struct) {
        return UNSAFE.getLong(null, struct + (long)UPDATETIME);
    }

    public static void ncomponentType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COMPONENTTYPE, value);
    }

    public static void nid(long struct, XrUuidMSFT value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ID, XrUuidMSFT.SIZEOF);
    }

    public static void nparentId(long struct, XrUuidMSFT value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PARENTID, XrUuidMSFT.SIZEOF);
    }

    public static void nupdateTime(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)UPDATETIME, value);
    }

    static {
        Struct.Layout layout = XrSceneComponentMSFT.__struct(XrSceneComponentMSFT.__member(4), XrSceneComponentMSFT.__member(XrUuidMSFT.SIZEOF, XrUuidMSFT.ALIGNOF), XrSceneComponentMSFT.__member(XrUuidMSFT.SIZEOF, XrUuidMSFT.ALIGNOF), XrSceneComponentMSFT.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        COMPONENTTYPE = layout.offsetof(0);
        ID = layout.offsetof(1);
        PARENTID = layout.offsetof(2);
        UPDATETIME = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSceneComponentMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneComponentMSFT ELEMENT_FACTORY = XrSceneComponentMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSceneComponentMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrSceneComponentTypeMSFT")
        public int componentType() {
            return XrSceneComponentMSFT.ncomponentType(this.address());
        }

        public XrUuidMSFT id() {
            return XrSceneComponentMSFT.nid(this.address());
        }

        public XrUuidMSFT parentId() {
            return XrSceneComponentMSFT.nparentId(this.address());
        }

        @NativeType(value="XrTime")
        public long updateTime() {
            return XrSceneComponentMSFT.nupdateTime(this.address());
        }

        public Buffer componentType(@NativeType(value="XrSceneComponentTypeMSFT") int value) {
            XrSceneComponentMSFT.ncomponentType(this.address(), value);
            return this;
        }

        public Buffer id(XrUuidMSFT value) {
            XrSceneComponentMSFT.nid(this.address(), value);
            return this;
        }

        public Buffer id(Consumer<XrUuidMSFT> consumer) {
            consumer.accept(this.id());
            return this;
        }

        public Buffer parentId(XrUuidMSFT value) {
            XrSceneComponentMSFT.nparentId(this.address(), value);
            return this;
        }

        public Buffer parentId(Consumer<XrUuidMSFT> consumer) {
            consumer.accept(this.parentId());
            return this;
        }

        public Buffer updateTime(@NativeType(value="XrTime") long value) {
            XrSceneComponentMSFT.nupdateTime(this.address(), value);
            return this;
        }
    }
}

