/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrUuidMSFT;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneComponentsLocateInfoMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int BASESPACE;
    public static final int TIME;
    public static final int COMPONENTIDCOUNT;
    public static final int COMPONENTIDS;

    public XrSceneComponentsLocateInfoMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSceneComponentsLocateInfoMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSceneComponentsLocateInfoMSFT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSceneComponentsLocateInfoMSFT.nnext(this.address());
    }

    @NativeType(value="XrSpace")
    public long baseSpace() {
        return XrSceneComponentsLocateInfoMSFT.nbaseSpace(this.address());
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrSceneComponentsLocateInfoMSFT.ntime(this.address());
    }

    @NativeType(value="uint32_t")
    public int componentIdCount() {
        return XrSceneComponentsLocateInfoMSFT.ncomponentIdCount(this.address());
    }

    @Nullable
    @NativeType(value="XrUuidMSFT const *")
    public XrUuidMSFT.Buffer componentIds() {
        return XrSceneComponentsLocateInfoMSFT.ncomponentIds(this.address());
    }

    public XrSceneComponentsLocateInfoMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSceneComponentsLocateInfoMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSceneComponentsLocateInfoMSFT type$Default() {
        return this.type(1000097007);
    }

    public XrSceneComponentsLocateInfoMSFT next(@NativeType(value="void const *") long value) {
        XrSceneComponentsLocateInfoMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSceneComponentsLocateInfoMSFT baseSpace(XrSpace value) {
        XrSceneComponentsLocateInfoMSFT.nbaseSpace(this.address(), value);
        return this;
    }

    public XrSceneComponentsLocateInfoMSFT time(@NativeType(value="XrTime") long value) {
        XrSceneComponentsLocateInfoMSFT.ntime(this.address(), value);
        return this;
    }

    public XrSceneComponentsLocateInfoMSFT componentIdCount(@NativeType(value="uint32_t") int value) {
        XrSceneComponentsLocateInfoMSFT.ncomponentIdCount(this.address(), value);
        return this;
    }

    public XrSceneComponentsLocateInfoMSFT componentIds(@Nullable @NativeType(value="XrUuidMSFT const *") XrUuidMSFT.Buffer value) {
        XrSceneComponentsLocateInfoMSFT.ncomponentIds(this.address(), value);
        return this;
    }

    public XrSceneComponentsLocateInfoMSFT set(int type, long next, XrSpace baseSpace, long time, int componentIdCount, @Nullable XrUuidMSFT.Buffer componentIds) {
        this.type(type);
        this.next(next);
        this.baseSpace(baseSpace);
        this.time(time);
        this.componentIdCount(componentIdCount);
        this.componentIds(componentIds);
        return this;
    }

    public XrSceneComponentsLocateInfoMSFT set(XrSceneComponentsLocateInfoMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSceneComponentsLocateInfoMSFT malloc() {
        return XrSceneComponentsLocateInfoMSFT.wrap(XrSceneComponentsLocateInfoMSFT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrSceneComponentsLocateInfoMSFT calloc() {
        return XrSceneComponentsLocateInfoMSFT.wrap(XrSceneComponentsLocateInfoMSFT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrSceneComponentsLocateInfoMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrSceneComponentsLocateInfoMSFT.wrap(XrSceneComponentsLocateInfoMSFT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrSceneComponentsLocateInfoMSFT create(long address) {
        return XrSceneComponentsLocateInfoMSFT.wrap(XrSceneComponentsLocateInfoMSFT.class, address);
    }

    @Nullable
    public static XrSceneComponentsLocateInfoMSFT createSafe(long address) {
        return address == 0L ? null : XrSceneComponentsLocateInfoMSFT.wrap(XrSceneComponentsLocateInfoMSFT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrSceneComponentsLocateInfoMSFT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrSceneComponentsLocateInfoMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrSceneComponentsLocateInfoMSFT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneComponentsLocateInfoMSFT.__create(capacity, SIZEOF);
        return XrSceneComponentsLocateInfoMSFT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrSceneComponentsLocateInfoMSFT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrSceneComponentsLocateInfoMSFT.wrap(Buffer.class, address, capacity);
    }

    public static XrSceneComponentsLocateInfoMSFT malloc(MemoryStack stack) {
        return XrSceneComponentsLocateInfoMSFT.wrap(XrSceneComponentsLocateInfoMSFT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSceneComponentsLocateInfoMSFT calloc(MemoryStack stack) {
        return XrSceneComponentsLocateInfoMSFT.wrap(XrSceneComponentsLocateInfoMSFT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrSceneComponentsLocateInfoMSFT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrSceneComponentsLocateInfoMSFT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nbaseSpace(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)BASESPACE);
    }

    public static long ntime(long struct) {
        return UNSAFE.getLong(null, struct + (long)TIME);
    }

    public static int ncomponentIdCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMPONENTIDCOUNT);
    }

    @Nullable
    public static XrUuidMSFT.Buffer ncomponentIds(long struct) {
        return XrUuidMSFT.createSafe(MemoryUtil.memGetAddress(struct + (long)COMPONENTIDS), XrSceneComponentsLocateInfoMSFT.ncomponentIdCount(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nbaseSpace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress(struct + (long)BASESPACE, value.address());
    }

    public static void ntime(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)TIME, value);
    }

    public static void ncomponentIdCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COMPONENTIDCOUNT, value);
    }

    public static void ncomponentIds(long struct, @Nullable XrUuidMSFT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)COMPONENTIDS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrSceneComponentsLocateInfoMSFT.ncomponentIdCount(struct, value.remaining());
        }
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)BASESPACE));
    }

    static {
        Struct.Layout layout = XrSceneComponentsLocateInfoMSFT.__struct(XrSceneComponentsLocateInfoMSFT.__member(4), XrSceneComponentsLocateInfoMSFT.__member(POINTER_SIZE), XrSceneComponentsLocateInfoMSFT.__member(POINTER_SIZE), XrSceneComponentsLocateInfoMSFT.__member(8), XrSceneComponentsLocateInfoMSFT.__member(4), XrSceneComponentsLocateInfoMSFT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        BASESPACE = layout.offsetof(2);
        TIME = layout.offsetof(3);
        COMPONENTIDCOUNT = layout.offsetof(4);
        COMPONENTIDS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrSceneComponentsLocateInfoMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneComponentsLocateInfoMSFT ELEMENT_FACTORY = XrSceneComponentsLocateInfoMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSceneComponentsLocateInfoMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSceneComponentsLocateInfoMSFT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSceneComponentsLocateInfoMSFT.nnext(this.address());
        }

        @NativeType(value="XrSpace")
        public long baseSpace() {
            return XrSceneComponentsLocateInfoMSFT.nbaseSpace(this.address());
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrSceneComponentsLocateInfoMSFT.ntime(this.address());
        }

        @NativeType(value="uint32_t")
        public int componentIdCount() {
            return XrSceneComponentsLocateInfoMSFT.ncomponentIdCount(this.address());
        }

        @Nullable
        @NativeType(value="XrUuidMSFT const *")
        public XrUuidMSFT.Buffer componentIds() {
            return XrSceneComponentsLocateInfoMSFT.ncomponentIds(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSceneComponentsLocateInfoMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000097007);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSceneComponentsLocateInfoMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer baseSpace(XrSpace value) {
            XrSceneComponentsLocateInfoMSFT.nbaseSpace(this.address(), value);
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrSceneComponentsLocateInfoMSFT.ntime(this.address(), value);
            return this;
        }

        public Buffer componentIdCount(@NativeType(value="uint32_t") int value) {
            XrSceneComponentsLocateInfoMSFT.ncomponentIdCount(this.address(), value);
            return this;
        }

        public Buffer componentIds(@Nullable @NativeType(value="XrUuidMSFT const *") XrUuidMSFT.Buffer value) {
            XrSceneComponentsLocateInfoMSFT.ncomponentIds(this.address(), value);
            return this;
        }
    }
}

