/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrDeserializeSceneFragmentMSFT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneDeserializeInfoMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int FRAGMENTCOUNT;
    public static final int FRAGMENTS;

    public XrSceneDeserializeInfoMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSceneDeserializeInfoMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSceneDeserializeInfoMSFT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSceneDeserializeInfoMSFT.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int fragmentCount() {
        return XrSceneDeserializeInfoMSFT.nfragmentCount(this.address());
    }

    @Nullable
    @NativeType(value="XrDeserializeSceneFragmentMSFT const *")
    public XrDeserializeSceneFragmentMSFT.Buffer fragments() {
        return XrSceneDeserializeInfoMSFT.nfragments(this.address());
    }

    public XrSceneDeserializeInfoMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSceneDeserializeInfoMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSceneDeserializeInfoMSFT type$Default() {
        return this.type(1000098001);
    }

    public XrSceneDeserializeInfoMSFT next(@NativeType(value="void const *") long value) {
        XrSceneDeserializeInfoMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSceneDeserializeInfoMSFT fragmentCount(@NativeType(value="uint32_t") int value) {
        XrSceneDeserializeInfoMSFT.nfragmentCount(this.address(), value);
        return this;
    }

    public XrSceneDeserializeInfoMSFT fragments(@Nullable @NativeType(value="XrDeserializeSceneFragmentMSFT const *") XrDeserializeSceneFragmentMSFT.Buffer value) {
        XrSceneDeserializeInfoMSFT.nfragments(this.address(), value);
        return this;
    }

    public XrSceneDeserializeInfoMSFT set(int type, long next, int fragmentCount, @Nullable XrDeserializeSceneFragmentMSFT.Buffer fragments) {
        this.type(type);
        this.next(next);
        this.fragmentCount(fragmentCount);
        this.fragments(fragments);
        return this;
    }

    public XrSceneDeserializeInfoMSFT set(XrSceneDeserializeInfoMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSceneDeserializeInfoMSFT malloc() {
        return XrSceneDeserializeInfoMSFT.wrap(XrSceneDeserializeInfoMSFT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrSceneDeserializeInfoMSFT calloc() {
        return XrSceneDeserializeInfoMSFT.wrap(XrSceneDeserializeInfoMSFT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrSceneDeserializeInfoMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrSceneDeserializeInfoMSFT.wrap(XrSceneDeserializeInfoMSFT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrSceneDeserializeInfoMSFT create(long address) {
        return XrSceneDeserializeInfoMSFT.wrap(XrSceneDeserializeInfoMSFT.class, address);
    }

    @Nullable
    public static XrSceneDeserializeInfoMSFT createSafe(long address) {
        return address == 0L ? null : XrSceneDeserializeInfoMSFT.wrap(XrSceneDeserializeInfoMSFT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrSceneDeserializeInfoMSFT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrSceneDeserializeInfoMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrSceneDeserializeInfoMSFT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneDeserializeInfoMSFT.__create(capacity, SIZEOF);
        return XrSceneDeserializeInfoMSFT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrSceneDeserializeInfoMSFT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrSceneDeserializeInfoMSFT.wrap(Buffer.class, address, capacity);
    }

    public static XrSceneDeserializeInfoMSFT malloc(MemoryStack stack) {
        return XrSceneDeserializeInfoMSFT.wrap(XrSceneDeserializeInfoMSFT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSceneDeserializeInfoMSFT calloc(MemoryStack stack) {
        return XrSceneDeserializeInfoMSFT.wrap(XrSceneDeserializeInfoMSFT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrSceneDeserializeInfoMSFT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrSceneDeserializeInfoMSFT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nfragmentCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)FRAGMENTCOUNT);
    }

    @Nullable
    public static XrDeserializeSceneFragmentMSFT.Buffer nfragments(long struct) {
        return XrDeserializeSceneFragmentMSFT.createSafe(MemoryUtil.memGetAddress(struct + (long)FRAGMENTS), XrSceneDeserializeInfoMSFT.nfragmentCount(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nfragmentCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FRAGMENTCOUNT, value);
    }

    public static void nfragments(long struct, @Nullable XrDeserializeSceneFragmentMSFT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)FRAGMENTS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrSceneDeserializeInfoMSFT.nfragmentCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrSceneDeserializeInfoMSFT.__struct(XrSceneDeserializeInfoMSFT.__member(4), XrSceneDeserializeInfoMSFT.__member(POINTER_SIZE), XrSceneDeserializeInfoMSFT.__member(4), XrSceneDeserializeInfoMSFT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        FRAGMENTCOUNT = layout.offsetof(2);
        FRAGMENTS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSceneDeserializeInfoMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneDeserializeInfoMSFT ELEMENT_FACTORY = XrSceneDeserializeInfoMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSceneDeserializeInfoMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSceneDeserializeInfoMSFT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSceneDeserializeInfoMSFT.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int fragmentCount() {
            return XrSceneDeserializeInfoMSFT.nfragmentCount(this.address());
        }

        @Nullable
        @NativeType(value="XrDeserializeSceneFragmentMSFT const *")
        public XrDeserializeSceneFragmentMSFT.Buffer fragments() {
            return XrSceneDeserializeInfoMSFT.nfragments(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSceneDeserializeInfoMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000098001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSceneDeserializeInfoMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer fragmentCount(@NativeType(value="uint32_t") int value) {
            XrSceneDeserializeInfoMSFT.nfragmentCount(this.address(), value);
            return this;
        }

        public Buffer fragments(@Nullable @NativeType(value="XrDeserializeSceneFragmentMSFT const *") XrDeserializeSceneFragmentMSFT.Buffer value) {
            XrSceneDeserializeInfoMSFT.nfragments(this.address(), value);
            return this;
        }
    }
}

