/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSceneMeshMSFT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneMeshesMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SCENEMESHCOUNT;
    public static final int SCENEMESHES;

    public XrSceneMeshesMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSceneMeshesMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSceneMeshesMSFT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSceneMeshesMSFT.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int sceneMeshCount() {
        return XrSceneMeshesMSFT.nsceneMeshCount(this.address());
    }

    @Nullable
    @NativeType(value="XrSceneMeshMSFT *")
    public XrSceneMeshMSFT.Buffer sceneMeshes() {
        return XrSceneMeshesMSFT.nsceneMeshes(this.address());
    }

    public XrSceneMeshesMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSceneMeshesMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSceneMeshesMSFT type$Default() {
        return this.type(1000097013);
    }

    public XrSceneMeshesMSFT next(@NativeType(value="void *") long value) {
        XrSceneMeshesMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSceneMeshesMSFT sceneMeshCount(@NativeType(value="uint32_t") int value) {
        XrSceneMeshesMSFT.nsceneMeshCount(this.address(), value);
        return this;
    }

    public XrSceneMeshesMSFT sceneMeshes(@Nullable @NativeType(value="XrSceneMeshMSFT *") XrSceneMeshMSFT.Buffer value) {
        XrSceneMeshesMSFT.nsceneMeshes(this.address(), value);
        return this;
    }

    public XrSceneMeshesMSFT set(int type, long next, int sceneMeshCount, @Nullable XrSceneMeshMSFT.Buffer sceneMeshes) {
        this.type(type);
        this.next(next);
        this.sceneMeshCount(sceneMeshCount);
        this.sceneMeshes(sceneMeshes);
        return this;
    }

    public XrSceneMeshesMSFT set(XrSceneMeshesMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSceneMeshesMSFT malloc() {
        return XrSceneMeshesMSFT.wrap(XrSceneMeshesMSFT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrSceneMeshesMSFT calloc() {
        return XrSceneMeshesMSFT.wrap(XrSceneMeshesMSFT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrSceneMeshesMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrSceneMeshesMSFT.wrap(XrSceneMeshesMSFT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrSceneMeshesMSFT create(long address) {
        return XrSceneMeshesMSFT.wrap(XrSceneMeshesMSFT.class, address);
    }

    @Nullable
    public static XrSceneMeshesMSFT createSafe(long address) {
        return address == 0L ? null : XrSceneMeshesMSFT.wrap(XrSceneMeshesMSFT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrSceneMeshesMSFT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrSceneMeshesMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrSceneMeshesMSFT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneMeshesMSFT.__create(capacity, SIZEOF);
        return XrSceneMeshesMSFT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrSceneMeshesMSFT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrSceneMeshesMSFT.wrap(Buffer.class, address, capacity);
    }

    public static XrSceneMeshesMSFT malloc(MemoryStack stack) {
        return XrSceneMeshesMSFT.wrap(XrSceneMeshesMSFT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSceneMeshesMSFT calloc(MemoryStack stack) {
        return XrSceneMeshesMSFT.wrap(XrSceneMeshesMSFT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrSceneMeshesMSFT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrSceneMeshesMSFT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nsceneMeshCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SCENEMESHCOUNT);
    }

    @Nullable
    public static XrSceneMeshMSFT.Buffer nsceneMeshes(long struct) {
        return XrSceneMeshMSFT.createSafe(MemoryUtil.memGetAddress(struct + (long)SCENEMESHES), XrSceneMeshesMSFT.nsceneMeshCount(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nsceneMeshCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SCENEMESHCOUNT, value);
    }

    public static void nsceneMeshes(long struct, @Nullable XrSceneMeshMSFT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)SCENEMESHES, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrSceneMeshesMSFT.nsceneMeshCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrSceneMeshesMSFT.__struct(XrSceneMeshesMSFT.__member(4), XrSceneMeshesMSFT.__member(POINTER_SIZE), XrSceneMeshesMSFT.__member(4), XrSceneMeshesMSFT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SCENEMESHCOUNT = layout.offsetof(2);
        SCENEMESHES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSceneMeshesMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneMeshesMSFT ELEMENT_FACTORY = XrSceneMeshesMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSceneMeshesMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSceneMeshesMSFT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSceneMeshesMSFT.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int sceneMeshCount() {
            return XrSceneMeshesMSFT.nsceneMeshCount(this.address());
        }

        @Nullable
        @NativeType(value="XrSceneMeshMSFT *")
        public XrSceneMeshMSFT.Buffer sceneMeshes() {
            return XrSceneMeshesMSFT.nsceneMeshes(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSceneMeshesMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000097013);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSceneMeshesMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer sceneMeshCount(@NativeType(value="uint32_t") int value) {
            XrSceneMeshesMSFT.nsceneMeshCount(this.address(), value);
            return this;
        }

        public Buffer sceneMeshes(@Nullable @NativeType(value="XrSceneMeshMSFT *") XrSceneMeshMSFT.Buffer value) {
            XrSceneMeshesMSFT.nsceneMeshes(this.address(), value);
            return this;
        }
    }
}

