/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneObjectMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OBJECTTYPE;

    public XrSceneObjectMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSceneObjectMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrSceneObjectTypeMSFT")
    public int objectType() {
        return XrSceneObjectMSFT.nobjectType(this.address());
    }

    public XrSceneObjectMSFT objectType(@NativeType(value="XrSceneObjectTypeMSFT") int value) {
        XrSceneObjectMSFT.nobjectType(this.address(), value);
        return this;
    }

    public XrSceneObjectMSFT set(XrSceneObjectMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSceneObjectMSFT malloc() {
        return XrSceneObjectMSFT.wrap(XrSceneObjectMSFT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrSceneObjectMSFT calloc() {
        return XrSceneObjectMSFT.wrap(XrSceneObjectMSFT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrSceneObjectMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrSceneObjectMSFT.wrap(XrSceneObjectMSFT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrSceneObjectMSFT create(long address) {
        return XrSceneObjectMSFT.wrap(XrSceneObjectMSFT.class, address);
    }

    @Nullable
    public static XrSceneObjectMSFT createSafe(long address) {
        return address == 0L ? null : XrSceneObjectMSFT.wrap(XrSceneObjectMSFT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrSceneObjectMSFT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrSceneObjectMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrSceneObjectMSFT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneObjectMSFT.__create(capacity, SIZEOF);
        return XrSceneObjectMSFT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrSceneObjectMSFT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrSceneObjectMSFT.wrap(Buffer.class, address, capacity);
    }

    public static XrSceneObjectMSFT malloc(MemoryStack stack) {
        return XrSceneObjectMSFT.wrap(XrSceneObjectMSFT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSceneObjectMSFT calloc(MemoryStack stack) {
        return XrSceneObjectMSFT.wrap(XrSceneObjectMSFT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrSceneObjectMSFT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrSceneObjectMSFT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nobjectType(long struct) {
        return UNSAFE.getInt(null, struct + (long)OBJECTTYPE);
    }

    public static void nobjectType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OBJECTTYPE, value);
    }

    static {
        Struct.Layout layout = XrSceneObjectMSFT.__struct(XrSceneObjectMSFT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OBJECTTYPE = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<XrSceneObjectMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneObjectMSFT ELEMENT_FACTORY = XrSceneObjectMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSceneObjectMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrSceneObjectTypeMSFT")
        public int objectType() {
            return XrSceneObjectMSFT.nobjectType(this.address());
        }

        public Buffer objectType(@NativeType(value="XrSceneObjectTypeMSFT") int value) {
            XrSceneObjectMSFT.nobjectType(this.address(), value);
            return this;
        }
    }
}

