/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneObjectTypesFilterInfoMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int OBJECTTYPECOUNT;
    public static final int OBJECTTYPES;

    public XrSceneObjectTypesFilterInfoMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSceneObjectTypesFilterInfoMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSceneObjectTypesFilterInfoMSFT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSceneObjectTypesFilterInfoMSFT.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int objectTypeCount() {
        return XrSceneObjectTypesFilterInfoMSFT.nobjectTypeCount(this.address());
    }

    @Nullable
    @NativeType(value="XrSceneObjectTypeMSFT const *")
    public IntBuffer objectTypes() {
        return XrSceneObjectTypesFilterInfoMSFT.nobjectTypes(this.address());
    }

    public XrSceneObjectTypesFilterInfoMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSceneObjectTypesFilterInfoMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSceneObjectTypesFilterInfoMSFT type$Default() {
        return this.type(1000097010);
    }

    public XrSceneObjectTypesFilterInfoMSFT next(@NativeType(value="void const *") long value) {
        XrSceneObjectTypesFilterInfoMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSceneObjectTypesFilterInfoMSFT objectTypeCount(@NativeType(value="uint32_t") int value) {
        XrSceneObjectTypesFilterInfoMSFT.nobjectTypeCount(this.address(), value);
        return this;
    }

    public XrSceneObjectTypesFilterInfoMSFT objectTypes(@Nullable @NativeType(value="XrSceneObjectTypeMSFT const *") IntBuffer value) {
        XrSceneObjectTypesFilterInfoMSFT.nobjectTypes(this.address(), value);
        return this;
    }

    public XrSceneObjectTypesFilterInfoMSFT set(int type, long next, int objectTypeCount, @Nullable IntBuffer objectTypes) {
        this.type(type);
        this.next(next);
        this.objectTypeCount(objectTypeCount);
        this.objectTypes(objectTypes);
        return this;
    }

    public XrSceneObjectTypesFilterInfoMSFT set(XrSceneObjectTypesFilterInfoMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSceneObjectTypesFilterInfoMSFT malloc() {
        return XrSceneObjectTypesFilterInfoMSFT.wrap(XrSceneObjectTypesFilterInfoMSFT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrSceneObjectTypesFilterInfoMSFT calloc() {
        return XrSceneObjectTypesFilterInfoMSFT.wrap(XrSceneObjectTypesFilterInfoMSFT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrSceneObjectTypesFilterInfoMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrSceneObjectTypesFilterInfoMSFT.wrap(XrSceneObjectTypesFilterInfoMSFT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrSceneObjectTypesFilterInfoMSFT create(long address) {
        return XrSceneObjectTypesFilterInfoMSFT.wrap(XrSceneObjectTypesFilterInfoMSFT.class, address);
    }

    @Nullable
    public static XrSceneObjectTypesFilterInfoMSFT createSafe(long address) {
        return address == 0L ? null : XrSceneObjectTypesFilterInfoMSFT.wrap(XrSceneObjectTypesFilterInfoMSFT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrSceneObjectTypesFilterInfoMSFT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrSceneObjectTypesFilterInfoMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrSceneObjectTypesFilterInfoMSFT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneObjectTypesFilterInfoMSFT.__create(capacity, SIZEOF);
        return XrSceneObjectTypesFilterInfoMSFT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrSceneObjectTypesFilterInfoMSFT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrSceneObjectTypesFilterInfoMSFT.wrap(Buffer.class, address, capacity);
    }

    public static XrSceneObjectTypesFilterInfoMSFT malloc(MemoryStack stack) {
        return XrSceneObjectTypesFilterInfoMSFT.wrap(XrSceneObjectTypesFilterInfoMSFT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSceneObjectTypesFilterInfoMSFT calloc(MemoryStack stack) {
        return XrSceneObjectTypesFilterInfoMSFT.wrap(XrSceneObjectTypesFilterInfoMSFT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrSceneObjectTypesFilterInfoMSFT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrSceneObjectTypesFilterInfoMSFT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nobjectTypeCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)OBJECTTYPECOUNT);
    }

    @Nullable
    public static IntBuffer nobjectTypes(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)OBJECTTYPES), XrSceneObjectTypesFilterInfoMSFT.nobjectTypeCount(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nobjectTypeCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OBJECTTYPECOUNT, value);
    }

    public static void nobjectTypes(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)OBJECTTYPES, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrSceneObjectTypesFilterInfoMSFT.nobjectTypeCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrSceneObjectTypesFilterInfoMSFT.__struct(XrSceneObjectTypesFilterInfoMSFT.__member(4), XrSceneObjectTypesFilterInfoMSFT.__member(POINTER_SIZE), XrSceneObjectTypesFilterInfoMSFT.__member(4), XrSceneObjectTypesFilterInfoMSFT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        OBJECTTYPECOUNT = layout.offsetof(2);
        OBJECTTYPES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSceneObjectTypesFilterInfoMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneObjectTypesFilterInfoMSFT ELEMENT_FACTORY = XrSceneObjectTypesFilterInfoMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSceneObjectTypesFilterInfoMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSceneObjectTypesFilterInfoMSFT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSceneObjectTypesFilterInfoMSFT.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int objectTypeCount() {
            return XrSceneObjectTypesFilterInfoMSFT.nobjectTypeCount(this.address());
        }

        @Nullable
        @NativeType(value="XrSceneObjectTypeMSFT const *")
        public IntBuffer objectTypes() {
            return XrSceneObjectTypesFilterInfoMSFT.nobjectTypes(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSceneObjectTypesFilterInfoMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000097010);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSceneObjectTypesFilterInfoMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer objectTypeCount(@NativeType(value="uint32_t") int value) {
            XrSceneObjectTypesFilterInfoMSFT.nobjectTypeCount(this.address(), value);
            return this;
        }

        public Buffer objectTypes(@Nullable @NativeType(value="XrSceneObjectTypeMSFT const *") IntBuffer value) {
            XrSceneObjectTypesFilterInfoMSFT.nobjectTypes(this.address(), value);
            return this;
        }
    }
}

