/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrExtent2Df;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrScenePlaneMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ALIGNMENT;
    public static final int SIZE;
    public static final int MESHBUFFERID;
    public static final int SUPPORTSINDICESUINT16;

    public XrScenePlaneMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrScenePlaneMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrScenePlaneAlignmentTypeMSFT")
    public int alignment() {
        return XrScenePlaneMSFT.nalignment(this.address());
    }

    public XrExtent2Df size() {
        return XrScenePlaneMSFT.nsize(this.address());
    }

    @NativeType(value="uint64_t")
    public long meshBufferId() {
        return XrScenePlaneMSFT.nmeshBufferId(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean supportsIndicesUint16() {
        return XrScenePlaneMSFT.nsupportsIndicesUint16(this.address()) != 0;
    }

    public XrScenePlaneMSFT alignment(@NativeType(value="XrScenePlaneAlignmentTypeMSFT") int value) {
        XrScenePlaneMSFT.nalignment(this.address(), value);
        return this;
    }

    public XrScenePlaneMSFT size(XrExtent2Df value) {
        XrScenePlaneMSFT.nsize(this.address(), value);
        return this;
    }

    public XrScenePlaneMSFT size(Consumer<XrExtent2Df> consumer) {
        consumer.accept(this.size());
        return this;
    }

    public XrScenePlaneMSFT meshBufferId(@NativeType(value="uint64_t") long value) {
        XrScenePlaneMSFT.nmeshBufferId(this.address(), value);
        return this;
    }

    public XrScenePlaneMSFT supportsIndicesUint16(@NativeType(value="XrBool32") boolean value) {
        XrScenePlaneMSFT.nsupportsIndicesUint16(this.address(), value ? 1 : 0);
        return this;
    }

    public XrScenePlaneMSFT set(int alignment, XrExtent2Df size, long meshBufferId, boolean supportsIndicesUint16) {
        this.alignment(alignment);
        this.size(size);
        this.meshBufferId(meshBufferId);
        this.supportsIndicesUint16(supportsIndicesUint16);
        return this;
    }

    public XrScenePlaneMSFT set(XrScenePlaneMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrScenePlaneMSFT malloc() {
        return XrScenePlaneMSFT.wrap(XrScenePlaneMSFT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrScenePlaneMSFT calloc() {
        return XrScenePlaneMSFT.wrap(XrScenePlaneMSFT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrScenePlaneMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrScenePlaneMSFT.wrap(XrScenePlaneMSFT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrScenePlaneMSFT create(long address) {
        return XrScenePlaneMSFT.wrap(XrScenePlaneMSFT.class, address);
    }

    @Nullable
    public static XrScenePlaneMSFT createSafe(long address) {
        return address == 0L ? null : XrScenePlaneMSFT.wrap(XrScenePlaneMSFT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrScenePlaneMSFT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrScenePlaneMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrScenePlaneMSFT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrScenePlaneMSFT.__create(capacity, SIZEOF);
        return XrScenePlaneMSFT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrScenePlaneMSFT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrScenePlaneMSFT.wrap(Buffer.class, address, capacity);
    }

    public static XrScenePlaneMSFT malloc(MemoryStack stack) {
        return XrScenePlaneMSFT.wrap(XrScenePlaneMSFT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrScenePlaneMSFT calloc(MemoryStack stack) {
        return XrScenePlaneMSFT.wrap(XrScenePlaneMSFT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrScenePlaneMSFT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrScenePlaneMSFT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nalignment(long struct) {
        return UNSAFE.getInt(null, struct + (long)ALIGNMENT);
    }

    public static XrExtent2Df nsize(long struct) {
        return XrExtent2Df.create(struct + (long)SIZE);
    }

    public static long nmeshBufferId(long struct) {
        return UNSAFE.getLong(null, struct + (long)MESHBUFFERID);
    }

    public static int nsupportsIndicesUint16(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTSINDICESUINT16);
    }

    public static void nalignment(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ALIGNMENT, value);
    }

    public static void nsize(long struct, XrExtent2Df value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SIZE, XrExtent2Df.SIZEOF);
    }

    public static void nmeshBufferId(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MESHBUFFERID, value);
    }

    public static void nsupportsIndicesUint16(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUPPORTSINDICESUINT16, value);
    }

    static {
        Struct.Layout layout = XrScenePlaneMSFT.__struct(XrScenePlaneMSFT.__member(4), XrScenePlaneMSFT.__member(XrExtent2Df.SIZEOF, XrExtent2Df.ALIGNOF), XrScenePlaneMSFT.__member(8), XrScenePlaneMSFT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ALIGNMENT = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        MESHBUFFERID = layout.offsetof(2);
        SUPPORTSINDICESUINT16 = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrScenePlaneMSFT, Buffer>
    implements NativeResource {
        private static final XrScenePlaneMSFT ELEMENT_FACTORY = XrScenePlaneMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrScenePlaneMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrScenePlaneAlignmentTypeMSFT")
        public int alignment() {
            return XrScenePlaneMSFT.nalignment(this.address());
        }

        public XrExtent2Df size() {
            return XrScenePlaneMSFT.nsize(this.address());
        }

        @NativeType(value="uint64_t")
        public long meshBufferId() {
            return XrScenePlaneMSFT.nmeshBufferId(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean supportsIndicesUint16() {
            return XrScenePlaneMSFT.nsupportsIndicesUint16(this.address()) != 0;
        }

        public Buffer alignment(@NativeType(value="XrScenePlaneAlignmentTypeMSFT") int value) {
            XrScenePlaneMSFT.nalignment(this.address(), value);
            return this;
        }

        public Buffer size(XrExtent2Df value) {
            XrScenePlaneMSFT.nsize(this.address(), value);
            return this;
        }

        public Buffer size(Consumer<XrExtent2Df> consumer) {
            consumer.accept(this.size());
            return this;
        }

        public Buffer meshBufferId(@NativeType(value="uint64_t") long value) {
            XrScenePlaneMSFT.nmeshBufferId(this.address(), value);
            return this;
        }

        public Buffer supportsIndicesUint16(@NativeType(value="XrBool32") boolean value) {
            XrScenePlaneMSFT.nsupportsIndicesUint16(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

