/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneSphereBoundMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CENTER;
    public static final int RADIUS;

    public XrSceneSphereBoundMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSceneSphereBoundMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public XrVector3f center() {
        return XrSceneSphereBoundMSFT.ncenter(this.address());
    }

    public float radius() {
        return XrSceneSphereBoundMSFT.nradius(this.address());
    }

    public XrSceneSphereBoundMSFT center(XrVector3f value) {
        XrSceneSphereBoundMSFT.ncenter(this.address(), value);
        return this;
    }

    public XrSceneSphereBoundMSFT center(Consumer<XrVector3f> consumer) {
        consumer.accept(this.center());
        return this;
    }

    public XrSceneSphereBoundMSFT radius(float value) {
        XrSceneSphereBoundMSFT.nradius(this.address(), value);
        return this;
    }

    public XrSceneSphereBoundMSFT set(XrVector3f center, float radius) {
        this.center(center);
        this.radius(radius);
        return this;
    }

    public XrSceneSphereBoundMSFT set(XrSceneSphereBoundMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSceneSphereBoundMSFT malloc() {
        return XrSceneSphereBoundMSFT.wrap(XrSceneSphereBoundMSFT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrSceneSphereBoundMSFT calloc() {
        return XrSceneSphereBoundMSFT.wrap(XrSceneSphereBoundMSFT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrSceneSphereBoundMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrSceneSphereBoundMSFT.wrap(XrSceneSphereBoundMSFT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrSceneSphereBoundMSFT create(long address) {
        return XrSceneSphereBoundMSFT.wrap(XrSceneSphereBoundMSFT.class, address);
    }

    @Nullable
    public static XrSceneSphereBoundMSFT createSafe(long address) {
        return address == 0L ? null : XrSceneSphereBoundMSFT.wrap(XrSceneSphereBoundMSFT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrSceneSphereBoundMSFT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrSceneSphereBoundMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrSceneSphereBoundMSFT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneSphereBoundMSFT.__create(capacity, SIZEOF);
        return XrSceneSphereBoundMSFT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrSceneSphereBoundMSFT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrSceneSphereBoundMSFT.wrap(Buffer.class, address, capacity);
    }

    public static XrSceneSphereBoundMSFT malloc(MemoryStack stack) {
        return XrSceneSphereBoundMSFT.wrap(XrSceneSphereBoundMSFT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSceneSphereBoundMSFT calloc(MemoryStack stack) {
        return XrSceneSphereBoundMSFT.wrap(XrSceneSphereBoundMSFT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrSceneSphereBoundMSFT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrSceneSphereBoundMSFT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static XrVector3f ncenter(long struct) {
        return XrVector3f.create(struct + (long)CENTER);
    }

    public static float nradius(long struct) {
        return UNSAFE.getFloat(null, struct + (long)RADIUS);
    }

    public static void ncenter(long struct, XrVector3f value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CENTER, XrVector3f.SIZEOF);
    }

    public static void nradius(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)RADIUS, value);
    }

    static {
        Struct.Layout layout = XrSceneSphereBoundMSFT.__struct(XrSceneSphereBoundMSFT.__member(XrVector3f.SIZEOF, XrVector3f.ALIGNOF), XrSceneSphereBoundMSFT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CENTER = layout.offsetof(0);
        RADIUS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrSceneSphereBoundMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneSphereBoundMSFT ELEMENT_FACTORY = XrSceneSphereBoundMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSceneSphereBoundMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public XrVector3f center() {
            return XrSceneSphereBoundMSFT.ncenter(this.address());
        }

        public float radius() {
            return XrSceneSphereBoundMSFT.nradius(this.address());
        }

        public Buffer center(XrVector3f value) {
            XrSceneSphereBoundMSFT.ncenter(this.address(), value);
            return this;
        }

        public Buffer center(Consumer<XrVector3f> consumer) {
            consumer.accept(this.center());
            return this;
        }

        public Buffer radius(float value) {
            XrSceneSphereBoundMSFT.nradius(this.address(), value);
            return this;
        }
    }
}

