/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSessionActionSetsAttachInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int COUNTACTIONSETS;
    public static final int ACTIONSETS;

    public XrSessionActionSetsAttachInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSessionActionSetsAttachInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSessionActionSetsAttachInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSessionActionSetsAttachInfo.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int countActionSets() {
        return XrSessionActionSetsAttachInfo.ncountActionSets(this.address());
    }

    @NativeType(value="XrActionSet const *")
    public PointerBuffer actionSets() {
        return XrSessionActionSetsAttachInfo.nactionSets(this.address());
    }

    public XrSessionActionSetsAttachInfo type(@NativeType(value="XrStructureType") int value) {
        XrSessionActionSetsAttachInfo.ntype(this.address(), value);
        return this;
    }

    public XrSessionActionSetsAttachInfo type$Default() {
        return this.type(60);
    }

    public XrSessionActionSetsAttachInfo next(@NativeType(value="void const *") long value) {
        XrSessionActionSetsAttachInfo.nnext(this.address(), value);
        return this;
    }

    public XrSessionActionSetsAttachInfo actionSets(@NativeType(value="XrActionSet const *") PointerBuffer value) {
        XrSessionActionSetsAttachInfo.nactionSets(this.address(), value);
        return this;
    }

    public XrSessionActionSetsAttachInfo set(int type, long next, PointerBuffer actionSets) {
        this.type(type);
        this.next(next);
        this.actionSets(actionSets);
        return this;
    }

    public XrSessionActionSetsAttachInfo set(XrSessionActionSetsAttachInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSessionActionSetsAttachInfo malloc() {
        return XrSessionActionSetsAttachInfo.wrap(XrSessionActionSetsAttachInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrSessionActionSetsAttachInfo calloc() {
        return XrSessionActionSetsAttachInfo.wrap(XrSessionActionSetsAttachInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrSessionActionSetsAttachInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrSessionActionSetsAttachInfo.wrap(XrSessionActionSetsAttachInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static XrSessionActionSetsAttachInfo create(long address) {
        return XrSessionActionSetsAttachInfo.wrap(XrSessionActionSetsAttachInfo.class, address);
    }

    @Nullable
    public static XrSessionActionSetsAttachInfo createSafe(long address) {
        return address == 0L ? null : XrSessionActionSetsAttachInfo.wrap(XrSessionActionSetsAttachInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrSessionActionSetsAttachInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrSessionActionSetsAttachInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrSessionActionSetsAttachInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSessionActionSetsAttachInfo.__create(capacity, SIZEOF);
        return XrSessionActionSetsAttachInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrSessionActionSetsAttachInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrSessionActionSetsAttachInfo.wrap(Buffer.class, address, capacity);
    }

    public static XrSessionActionSetsAttachInfo malloc(MemoryStack stack) {
        return XrSessionActionSetsAttachInfo.wrap(XrSessionActionSetsAttachInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSessionActionSetsAttachInfo calloc(MemoryStack stack) {
        return XrSessionActionSetsAttachInfo.wrap(XrSessionActionSetsAttachInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrSessionActionSetsAttachInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrSessionActionSetsAttachInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int ncountActionSets(long struct) {
        return UNSAFE.getInt(null, struct + (long)COUNTACTIONSETS);
    }

    public static PointerBuffer nactionSets(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)ACTIONSETS), XrSessionActionSetsAttachInfo.ncountActionSets(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void ncountActionSets(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COUNTACTIONSETS, value);
    }

    public static void nactionSets(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)ACTIONSETS, MemoryUtil.memAddress(value));
        XrSessionActionSetsAttachInfo.ncountActionSets(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)ACTIONSETS));
    }

    static {
        Struct.Layout layout = XrSessionActionSetsAttachInfo.__struct(XrSessionActionSetsAttachInfo.__member(4), XrSessionActionSetsAttachInfo.__member(POINTER_SIZE), XrSessionActionSetsAttachInfo.__member(4), XrSessionActionSetsAttachInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        COUNTACTIONSETS = layout.offsetof(2);
        ACTIONSETS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSessionActionSetsAttachInfo, Buffer>
    implements NativeResource {
        private static final XrSessionActionSetsAttachInfo ELEMENT_FACTORY = XrSessionActionSetsAttachInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSessionActionSetsAttachInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSessionActionSetsAttachInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSessionActionSetsAttachInfo.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int countActionSets() {
            return XrSessionActionSetsAttachInfo.ncountActionSets(this.address());
        }

        @NativeType(value="XrActionSet const *")
        public PointerBuffer actionSets() {
            return XrSessionActionSetsAttachInfo.nactionSets(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSessionActionSetsAttachInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(60);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSessionActionSetsAttachInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer actionSets(@NativeType(value="XrActionSet const *") PointerBuffer value) {
            XrSessionActionSetsAttachInfo.nactionSets(this.address(), value);
            return this;
        }
    }
}

