/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrEyeGazeSampleTimeEXT;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpaceVelocity;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpaceLocation
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LOCATIONFLAGS;
    public static final int POSE;

    public XrSpaceLocation(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSpaceLocation.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpaceLocation.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSpaceLocation.nnext(this.address());
    }

    @NativeType(value="XrSpaceLocationFlags")
    public long locationFlags() {
        return XrSpaceLocation.nlocationFlags(this.address());
    }

    public XrPosef pose() {
        return XrSpaceLocation.npose(this.address());
    }

    public XrSpaceLocation type(@NativeType(value="XrStructureType") int value) {
        XrSpaceLocation.ntype(this.address(), value);
        return this;
    }

    public XrSpaceLocation type$Default() {
        return this.type(42);
    }

    public XrSpaceLocation next(@NativeType(value="void *") long value) {
        XrSpaceLocation.nnext(this.address(), value);
        return this;
    }

    public XrSpaceLocation next(XrEyeGazeSampleTimeEXT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSpaceLocation next(XrSpaceVelocity value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSpaceLocation locationFlags(@NativeType(value="XrSpaceLocationFlags") long value) {
        XrSpaceLocation.nlocationFlags(this.address(), value);
        return this;
    }

    public XrSpaceLocation pose(XrPosef value) {
        XrSpaceLocation.npose(this.address(), value);
        return this;
    }

    public XrSpaceLocation pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrSpaceLocation set(int type, long next, long locationFlags, XrPosef pose) {
        this.type(type);
        this.next(next);
        this.locationFlags(locationFlags);
        this.pose(pose);
        return this;
    }

    public XrSpaceLocation set(XrSpaceLocation src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSpaceLocation malloc() {
        return XrSpaceLocation.wrap(XrSpaceLocation.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrSpaceLocation calloc() {
        return XrSpaceLocation.wrap(XrSpaceLocation.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrSpaceLocation create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrSpaceLocation.wrap(XrSpaceLocation.class, MemoryUtil.memAddress(container), container);
    }

    public static XrSpaceLocation create(long address) {
        return XrSpaceLocation.wrap(XrSpaceLocation.class, address);
    }

    @Nullable
    public static XrSpaceLocation createSafe(long address) {
        return address == 0L ? null : XrSpaceLocation.wrap(XrSpaceLocation.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrSpaceLocation.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrSpaceLocation.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrSpaceLocation.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceLocation.__create(capacity, SIZEOF);
        return XrSpaceLocation.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrSpaceLocation.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrSpaceLocation.wrap(Buffer.class, address, capacity);
    }

    public static XrSpaceLocation malloc(MemoryStack stack) {
        return XrSpaceLocation.wrap(XrSpaceLocation.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSpaceLocation calloc(MemoryStack stack) {
        return XrSpaceLocation.wrap(XrSpaceLocation.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrSpaceLocation.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrSpaceLocation.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nlocationFlags(long struct) {
        return UNSAFE.getLong(null, struct + (long)LOCATIONFLAGS);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nlocationFlags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)LOCATIONFLAGS, value);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSE, XrPosef.SIZEOF);
    }

    static {
        Struct.Layout layout = XrSpaceLocation.__struct(XrSpaceLocation.__member(4), XrSpaceLocation.__member(POINTER_SIZE), XrSpaceLocation.__member(8), XrSpaceLocation.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LOCATIONFLAGS = layout.offsetof(2);
        POSE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSpaceLocation, Buffer>
    implements NativeResource {
        private static final XrSpaceLocation ELEMENT_FACTORY = XrSpaceLocation.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSpaceLocation getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpaceLocation.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSpaceLocation.nnext(this.address());
        }

        @NativeType(value="XrSpaceLocationFlags")
        public long locationFlags() {
            return XrSpaceLocation.nlocationFlags(this.address());
        }

        public XrPosef pose() {
            return XrSpaceLocation.npose(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpaceLocation.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(42);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSpaceLocation.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrEyeGazeSampleTimeEXT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSpaceVelocity value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer locationFlags(@NativeType(value="XrSpaceLocationFlags") long value) {
            XrSpaceLocation.nlocationFlags(this.address(), value);
            return this;
        }

        public Buffer pose(XrPosef value) {
            XrSpaceLocation.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }
    }
}

