/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpatialAnchorMSFT;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpatialAnchorSpaceCreateInfoMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ANCHOR;
    public static final int POSEINANCHORSPACE;

    public XrSpatialAnchorSpaceCreateInfoMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSpatialAnchorSpaceCreateInfoMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpatialAnchorSpaceCreateInfoMSFT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpatialAnchorSpaceCreateInfoMSFT.nnext(this.address());
    }

    @NativeType(value="XrSpatialAnchorMSFT")
    public long anchor() {
        return XrSpatialAnchorSpaceCreateInfoMSFT.nanchor(this.address());
    }

    public XrPosef poseInAnchorSpace() {
        return XrSpatialAnchorSpaceCreateInfoMSFT.nposeInAnchorSpace(this.address());
    }

    public XrSpatialAnchorSpaceCreateInfoMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSpatialAnchorSpaceCreateInfoMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSpatialAnchorSpaceCreateInfoMSFT type$Default() {
        return this.type(1000039001);
    }

    public XrSpatialAnchorSpaceCreateInfoMSFT next(@NativeType(value="void const *") long value) {
        XrSpatialAnchorSpaceCreateInfoMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSpatialAnchorSpaceCreateInfoMSFT anchor(XrSpatialAnchorMSFT value) {
        XrSpatialAnchorSpaceCreateInfoMSFT.nanchor(this.address(), value);
        return this;
    }

    public XrSpatialAnchorSpaceCreateInfoMSFT poseInAnchorSpace(XrPosef value) {
        XrSpatialAnchorSpaceCreateInfoMSFT.nposeInAnchorSpace(this.address(), value);
        return this;
    }

    public XrSpatialAnchorSpaceCreateInfoMSFT poseInAnchorSpace(Consumer<XrPosef> consumer) {
        consumer.accept(this.poseInAnchorSpace());
        return this;
    }

    public XrSpatialAnchorSpaceCreateInfoMSFT set(int type, long next, XrSpatialAnchorMSFT anchor, XrPosef poseInAnchorSpace) {
        this.type(type);
        this.next(next);
        this.anchor(anchor);
        this.poseInAnchorSpace(poseInAnchorSpace);
        return this;
    }

    public XrSpatialAnchorSpaceCreateInfoMSFT set(XrSpatialAnchorSpaceCreateInfoMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSpatialAnchorSpaceCreateInfoMSFT malloc() {
        return XrSpatialAnchorSpaceCreateInfoMSFT.wrap(XrSpatialAnchorSpaceCreateInfoMSFT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrSpatialAnchorSpaceCreateInfoMSFT calloc() {
        return XrSpatialAnchorSpaceCreateInfoMSFT.wrap(XrSpatialAnchorSpaceCreateInfoMSFT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrSpatialAnchorSpaceCreateInfoMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrSpatialAnchorSpaceCreateInfoMSFT.wrap(XrSpatialAnchorSpaceCreateInfoMSFT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrSpatialAnchorSpaceCreateInfoMSFT create(long address) {
        return XrSpatialAnchorSpaceCreateInfoMSFT.wrap(XrSpatialAnchorSpaceCreateInfoMSFT.class, address);
    }

    @Nullable
    public static XrSpatialAnchorSpaceCreateInfoMSFT createSafe(long address) {
        return address == 0L ? null : XrSpatialAnchorSpaceCreateInfoMSFT.wrap(XrSpatialAnchorSpaceCreateInfoMSFT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrSpatialAnchorSpaceCreateInfoMSFT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrSpatialAnchorSpaceCreateInfoMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrSpatialAnchorSpaceCreateInfoMSFT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpatialAnchorSpaceCreateInfoMSFT.__create(capacity, SIZEOF);
        return XrSpatialAnchorSpaceCreateInfoMSFT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrSpatialAnchorSpaceCreateInfoMSFT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrSpatialAnchorSpaceCreateInfoMSFT.wrap(Buffer.class, address, capacity);
    }

    public static XrSpatialAnchorSpaceCreateInfoMSFT malloc(MemoryStack stack) {
        return XrSpatialAnchorSpaceCreateInfoMSFT.wrap(XrSpatialAnchorSpaceCreateInfoMSFT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSpatialAnchorSpaceCreateInfoMSFT calloc(MemoryStack stack) {
        return XrSpatialAnchorSpaceCreateInfoMSFT.wrap(XrSpatialAnchorSpaceCreateInfoMSFT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrSpatialAnchorSpaceCreateInfoMSFT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrSpatialAnchorSpaceCreateInfoMSFT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nanchor(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)ANCHOR);
    }

    public static XrPosef nposeInAnchorSpace(long struct) {
        return XrPosef.create(struct + (long)POSEINANCHORSPACE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nanchor(long struct, XrSpatialAnchorMSFT value) {
        MemoryUtil.memPutAddress(struct + (long)ANCHOR, value.address());
    }

    public static void nposeInAnchorSpace(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSEINANCHORSPACE, XrPosef.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)ANCHOR));
    }

    static {
        Struct.Layout layout = XrSpatialAnchorSpaceCreateInfoMSFT.__struct(XrSpatialAnchorSpaceCreateInfoMSFT.__member(4), XrSpatialAnchorSpaceCreateInfoMSFT.__member(POINTER_SIZE), XrSpatialAnchorSpaceCreateInfoMSFT.__member(POINTER_SIZE), XrSpatialAnchorSpaceCreateInfoMSFT.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ANCHOR = layout.offsetof(2);
        POSEINANCHORSPACE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSpatialAnchorSpaceCreateInfoMSFT, Buffer>
    implements NativeResource {
        private static final XrSpatialAnchorSpaceCreateInfoMSFT ELEMENT_FACTORY = XrSpatialAnchorSpaceCreateInfoMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSpatialAnchorSpaceCreateInfoMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpatialAnchorSpaceCreateInfoMSFT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpatialAnchorSpaceCreateInfoMSFT.nnext(this.address());
        }

        @NativeType(value="XrSpatialAnchorMSFT")
        public long anchor() {
            return XrSpatialAnchorSpaceCreateInfoMSFT.nanchor(this.address());
        }

        public XrPosef poseInAnchorSpace() {
            return XrSpatialAnchorSpaceCreateInfoMSFT.nposeInAnchorSpace(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpatialAnchorSpaceCreateInfoMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000039001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpatialAnchorSpaceCreateInfoMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer anchor(XrSpatialAnchorMSFT value) {
            XrSpatialAnchorSpaceCreateInfoMSFT.nanchor(this.address(), value);
            return this;
        }

        public Buffer poseInAnchorSpace(XrPosef value) {
            XrSpatialAnchorSpaceCreateInfoMSFT.nposeInAnchorSpace(this.address(), value);
            return this;
        }

        public Buffer poseInAnchorSpace(Consumer<XrPosef> consumer) {
            consumer.accept(this.poseInAnchorSpace());
            return this;
        }
    }
}

