/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSwapchainImageOpenGLESKHR;
import org.lwjgl.openxr.XrSwapchainImageOpenGLKHR;
import org.lwjgl.openxr.XrSwapchainImageVulkanKHR;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSwapchainImageBaseHeader
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    public XrSwapchainImageBaseHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSwapchainImageBaseHeader.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSwapchainImageBaseHeader.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSwapchainImageBaseHeader.nnext(this.address());
    }

    public XrSwapchainImageBaseHeader type(@NativeType(value="XrStructureType") int value) {
        XrSwapchainImageBaseHeader.ntype(this.address(), value);
        return this;
    }

    public XrSwapchainImageBaseHeader next(@NativeType(value="void *") long value) {
        XrSwapchainImageBaseHeader.nnext(this.address(), value);
        return this;
    }

    public XrSwapchainImageBaseHeader set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrSwapchainImageBaseHeader set(XrSwapchainImageBaseHeader src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSwapchainImageBaseHeader malloc() {
        return XrSwapchainImageBaseHeader.wrap(XrSwapchainImageBaseHeader.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrSwapchainImageBaseHeader calloc() {
        return XrSwapchainImageBaseHeader.wrap(XrSwapchainImageBaseHeader.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrSwapchainImageBaseHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrSwapchainImageBaseHeader.wrap(XrSwapchainImageBaseHeader.class, MemoryUtil.memAddress(container), container);
    }

    public static XrSwapchainImageBaseHeader create(long address) {
        return XrSwapchainImageBaseHeader.wrap(XrSwapchainImageBaseHeader.class, address);
    }

    @Nullable
    public static XrSwapchainImageBaseHeader createSafe(long address) {
        return address == 0L ? null : XrSwapchainImageBaseHeader.wrap(XrSwapchainImageBaseHeader.class, address);
    }

    public static XrSwapchainImageBaseHeader create(XrSwapchainImageOpenGLKHR value) {
        return XrSwapchainImageBaseHeader.wrap(XrSwapchainImageBaseHeader.class, value);
    }

    public static XrSwapchainImageBaseHeader create(XrSwapchainImageOpenGLESKHR value) {
        return XrSwapchainImageBaseHeader.wrap(XrSwapchainImageBaseHeader.class, value);
    }

    public static XrSwapchainImageBaseHeader create(XrSwapchainImageVulkanKHR value) {
        return XrSwapchainImageBaseHeader.wrap(XrSwapchainImageBaseHeader.class, value);
    }

    public static Buffer malloc(int capacity) {
        return XrSwapchainImageBaseHeader.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrSwapchainImageBaseHeader.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrSwapchainImageBaseHeader.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSwapchainImageBaseHeader.__create(capacity, SIZEOF);
        return XrSwapchainImageBaseHeader.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrSwapchainImageBaseHeader.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrSwapchainImageBaseHeader.wrap(Buffer.class, address, capacity);
    }

    public static Buffer create(XrSwapchainImageOpenGLKHR.Buffer value) {
        return XrSwapchainImageBaseHeader.wrap(Buffer.class, value);
    }

    public static Buffer create(XrSwapchainImageOpenGLESKHR.Buffer value) {
        return XrSwapchainImageBaseHeader.wrap(Buffer.class, value);
    }

    public static Buffer create(XrSwapchainImageVulkanKHR.Buffer value) {
        return XrSwapchainImageBaseHeader.wrap(Buffer.class, value);
    }

    public static XrSwapchainImageBaseHeader malloc(MemoryStack stack) {
        return XrSwapchainImageBaseHeader.wrap(XrSwapchainImageBaseHeader.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSwapchainImageBaseHeader calloc(MemoryStack stack) {
        return XrSwapchainImageBaseHeader.wrap(XrSwapchainImageBaseHeader.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrSwapchainImageBaseHeader.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrSwapchainImageBaseHeader.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrSwapchainImageBaseHeader.__struct(XrSwapchainImageBaseHeader.__member(4), XrSwapchainImageBaseHeader.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrSwapchainImageBaseHeader, Buffer>
    implements NativeResource {
        private static final XrSwapchainImageBaseHeader ELEMENT_FACTORY = XrSwapchainImageBaseHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSwapchainImageBaseHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSwapchainImageBaseHeader.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSwapchainImageBaseHeader.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSwapchainImageBaseHeader.ntype(this.address(), value);
            return this;
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSwapchainImageBaseHeader.nnext(this.address(), value);
            return this;
        }
    }
}

