/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSystemPassthroughPropertiesFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SUPPORTSPASSTHROUGH;

    public XrSystemPassthroughPropertiesFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSystemPassthroughPropertiesFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSystemPassthroughPropertiesFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSystemPassthroughPropertiesFB.nnext(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean supportsPassthrough() {
        return XrSystemPassthroughPropertiesFB.nsupportsPassthrough(this.address()) != 0;
    }

    public XrSystemPassthroughPropertiesFB type(@NativeType(value="XrStructureType") int value) {
        XrSystemPassthroughPropertiesFB.ntype(this.address(), value);
        return this;
    }

    public XrSystemPassthroughPropertiesFB type$Default() {
        return this.type(1000118000);
    }

    public XrSystemPassthroughPropertiesFB next(@NativeType(value="void const *") long value) {
        XrSystemPassthroughPropertiesFB.nnext(this.address(), value);
        return this;
    }

    public XrSystemPassthroughPropertiesFB supportsPassthrough(@NativeType(value="XrBool32") boolean value) {
        XrSystemPassthroughPropertiesFB.nsupportsPassthrough(this.address(), value ? 1 : 0);
        return this;
    }

    public XrSystemPassthroughPropertiesFB set(int type, long next, boolean supportsPassthrough) {
        this.type(type);
        this.next(next);
        this.supportsPassthrough(supportsPassthrough);
        return this;
    }

    public XrSystemPassthroughPropertiesFB set(XrSystemPassthroughPropertiesFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSystemPassthroughPropertiesFB malloc() {
        return XrSystemPassthroughPropertiesFB.wrap(XrSystemPassthroughPropertiesFB.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrSystemPassthroughPropertiesFB calloc() {
        return XrSystemPassthroughPropertiesFB.wrap(XrSystemPassthroughPropertiesFB.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrSystemPassthroughPropertiesFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrSystemPassthroughPropertiesFB.wrap(XrSystemPassthroughPropertiesFB.class, MemoryUtil.memAddress(container), container);
    }

    public static XrSystemPassthroughPropertiesFB create(long address) {
        return XrSystemPassthroughPropertiesFB.wrap(XrSystemPassthroughPropertiesFB.class, address);
    }

    @Nullable
    public static XrSystemPassthroughPropertiesFB createSafe(long address) {
        return address == 0L ? null : XrSystemPassthroughPropertiesFB.wrap(XrSystemPassthroughPropertiesFB.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrSystemPassthroughPropertiesFB.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrSystemPassthroughPropertiesFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrSystemPassthroughPropertiesFB.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSystemPassthroughPropertiesFB.__create(capacity, SIZEOF);
        return XrSystemPassthroughPropertiesFB.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrSystemPassthroughPropertiesFB.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrSystemPassthroughPropertiesFB.wrap(Buffer.class, address, capacity);
    }

    public static XrSystemPassthroughPropertiesFB malloc(MemoryStack stack) {
        return XrSystemPassthroughPropertiesFB.wrap(XrSystemPassthroughPropertiesFB.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSystemPassthroughPropertiesFB calloc(MemoryStack stack) {
        return XrSystemPassthroughPropertiesFB.wrap(XrSystemPassthroughPropertiesFB.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrSystemPassthroughPropertiesFB.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrSystemPassthroughPropertiesFB.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nsupportsPassthrough(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTSPASSTHROUGH);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nsupportsPassthrough(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUPPORTSPASSTHROUGH, value);
    }

    static {
        Struct.Layout layout = XrSystemPassthroughPropertiesFB.__struct(XrSystemPassthroughPropertiesFB.__member(4), XrSystemPassthroughPropertiesFB.__member(POINTER_SIZE), XrSystemPassthroughPropertiesFB.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SUPPORTSPASSTHROUGH = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrSystemPassthroughPropertiesFB, Buffer>
    implements NativeResource {
        private static final XrSystemPassthroughPropertiesFB ELEMENT_FACTORY = XrSystemPassthroughPropertiesFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSystemPassthroughPropertiesFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSystemPassthroughPropertiesFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSystemPassthroughPropertiesFB.nnext(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean supportsPassthrough() {
            return XrSystemPassthroughPropertiesFB.nsupportsPassthrough(this.address()) != 0;
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSystemPassthroughPropertiesFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000118000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSystemPassthroughPropertiesFB.nnext(this.address(), value);
            return this;
        }

        public Buffer supportsPassthrough(@NativeType(value="XrBool32") boolean value) {
            XrSystemPassthroughPropertiesFB.nsupportsPassthrough(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

