/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSystemTrackingProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ORIENTATIONTRACKING;
    public static final int POSITIONTRACKING;

    public XrSystemTrackingProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSystemTrackingProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrBool32")
    public boolean orientationTracking() {
        return XrSystemTrackingProperties.norientationTracking(this.address()) != 0;
    }

    @NativeType(value="XrBool32")
    public boolean positionTracking() {
        return XrSystemTrackingProperties.npositionTracking(this.address()) != 0;
    }

    public XrSystemTrackingProperties orientationTracking(@NativeType(value="XrBool32") boolean value) {
        XrSystemTrackingProperties.norientationTracking(this.address(), value ? 1 : 0);
        return this;
    }

    public XrSystemTrackingProperties positionTracking(@NativeType(value="XrBool32") boolean value) {
        XrSystemTrackingProperties.npositionTracking(this.address(), value ? 1 : 0);
        return this;
    }

    public XrSystemTrackingProperties set(boolean orientationTracking, boolean positionTracking) {
        this.orientationTracking(orientationTracking);
        this.positionTracking(positionTracking);
        return this;
    }

    public XrSystemTrackingProperties set(XrSystemTrackingProperties src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSystemTrackingProperties malloc() {
        return XrSystemTrackingProperties.wrap(XrSystemTrackingProperties.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrSystemTrackingProperties calloc() {
        return XrSystemTrackingProperties.wrap(XrSystemTrackingProperties.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrSystemTrackingProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrSystemTrackingProperties.wrap(XrSystemTrackingProperties.class, MemoryUtil.memAddress(container), container);
    }

    public static XrSystemTrackingProperties create(long address) {
        return XrSystemTrackingProperties.wrap(XrSystemTrackingProperties.class, address);
    }

    @Nullable
    public static XrSystemTrackingProperties createSafe(long address) {
        return address == 0L ? null : XrSystemTrackingProperties.wrap(XrSystemTrackingProperties.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrSystemTrackingProperties.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrSystemTrackingProperties.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrSystemTrackingProperties.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSystemTrackingProperties.__create(capacity, SIZEOF);
        return XrSystemTrackingProperties.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrSystemTrackingProperties.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrSystemTrackingProperties.wrap(Buffer.class, address, capacity);
    }

    public static XrSystemTrackingProperties malloc(MemoryStack stack) {
        return XrSystemTrackingProperties.wrap(XrSystemTrackingProperties.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSystemTrackingProperties calloc(MemoryStack stack) {
        return XrSystemTrackingProperties.wrap(XrSystemTrackingProperties.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrSystemTrackingProperties.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrSystemTrackingProperties.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int norientationTracking(long struct) {
        return UNSAFE.getInt(null, struct + (long)ORIENTATIONTRACKING);
    }

    public static int npositionTracking(long struct) {
        return UNSAFE.getInt(null, struct + (long)POSITIONTRACKING);
    }

    public static void norientationTracking(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ORIENTATIONTRACKING, value);
    }

    public static void npositionTracking(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)POSITIONTRACKING, value);
    }

    static {
        Struct.Layout layout = XrSystemTrackingProperties.__struct(XrSystemTrackingProperties.__member(4), XrSystemTrackingProperties.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ORIENTATIONTRACKING = layout.offsetof(0);
        POSITIONTRACKING = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrSystemTrackingProperties, Buffer>
    implements NativeResource {
        private static final XrSystemTrackingProperties ELEMENT_FACTORY = XrSystemTrackingProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSystemTrackingProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrBool32")
        public boolean orientationTracking() {
            return XrSystemTrackingProperties.norientationTracking(this.address()) != 0;
        }

        @NativeType(value="XrBool32")
        public boolean positionTracking() {
            return XrSystemTrackingProperties.npositionTracking(this.address()) != 0;
        }

        public Buffer orientationTracking(@NativeType(value="XrBool32") boolean value) {
            XrSystemTrackingProperties.norientationTracking(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer positionTracking(@NativeType(value="XrBool32") boolean value) {
            XrSystemTrackingProperties.npositionTracking(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

