/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrUuidEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;

    public XrUuidEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrUuidEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t[XR_UUID_SIZE_EXT]")
    public ByteBuffer data() {
        return XrUuidEXT.ndata(this.address());
    }

    @NativeType(value="uint8_t")
    public byte data(int index) {
        return XrUuidEXT.ndata(this.address(), index);
    }

    public XrUuidEXT data(@NativeType(value="uint8_t[XR_UUID_SIZE_EXT]") ByteBuffer value) {
        XrUuidEXT.ndata(this.address(), value);
        return this;
    }

    public XrUuidEXT data(int index, @NativeType(value="uint8_t") byte value) {
        XrUuidEXT.ndata(this.address(), index, value);
        return this;
    }

    public XrUuidEXT set(XrUuidEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrUuidEXT malloc() {
        return XrUuidEXT.wrap(XrUuidEXT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrUuidEXT calloc() {
        return XrUuidEXT.wrap(XrUuidEXT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrUuidEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrUuidEXT.wrap(XrUuidEXT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrUuidEXT create(long address) {
        return XrUuidEXT.wrap(XrUuidEXT.class, address);
    }

    @Nullable
    public static XrUuidEXT createSafe(long address) {
        return address == 0L ? null : XrUuidEXT.wrap(XrUuidEXT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrUuidEXT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrUuidEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrUuidEXT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrUuidEXT.__create(capacity, SIZEOF);
        return XrUuidEXT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrUuidEXT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrUuidEXT.wrap(Buffer.class, address, capacity);
    }

    public static XrUuidEXT malloc(MemoryStack stack) {
        return XrUuidEXT.wrap(XrUuidEXT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrUuidEXT calloc(MemoryStack stack) {
        return XrUuidEXT.wrap(XrUuidEXT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrUuidEXT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrUuidEXT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DATA, 16);
    }

    public static byte ndata(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)DATA + Checks.check(index, 16) * 1L);
    }

    public static void ndata(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 16);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)DATA, value.remaining() * 1);
    }

    public static void ndata(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)DATA + Checks.check(index, 16) * 1L, value);
    }

    static {
        Struct.Layout layout = XrUuidEXT.__struct(XrUuidEXT.__array(1, 16));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<XrUuidEXT, Buffer>
    implements NativeResource {
        private static final XrUuidEXT ELEMENT_FACTORY = XrUuidEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrUuidEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t[XR_UUID_SIZE_EXT]")
        public ByteBuffer data() {
            return XrUuidEXT.ndata(this.address());
        }

        @NativeType(value="uint8_t")
        public byte data(int index) {
            return XrUuidEXT.ndata(this.address(), index);
        }

        public Buffer data(@NativeType(value="uint8_t[XR_UUID_SIZE_EXT]") ByteBuffer value) {
            XrUuidEXT.ndata(this.address(), value);
            return this;
        }

        public Buffer data(int index, @NativeType(value="uint8_t") byte value) {
            XrUuidEXT.ndata(this.address(), index, value);
            return this;
        }
    }
}

