/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrVector4f
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;
    public static final int W;

    public XrVector4f(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrVector4f.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return XrVector4f.nx(this.address());
    }

    public float y() {
        return XrVector4f.ny(this.address());
    }

    public float z() {
        return XrVector4f.nz(this.address());
    }

    public float w() {
        return XrVector4f.nw(this.address());
    }

    public XrVector4f x(float value) {
        XrVector4f.nx(this.address(), value);
        return this;
    }

    public XrVector4f y(float value) {
        XrVector4f.ny(this.address(), value);
        return this;
    }

    public XrVector4f z(float value) {
        XrVector4f.nz(this.address(), value);
        return this;
    }

    public XrVector4f w(float value) {
        XrVector4f.nw(this.address(), value);
        return this;
    }

    public XrVector4f set(float x, float y, float z, float w) {
        this.x(x);
        this.y(y);
        this.z(z);
        this.w(w);
        return this;
    }

    public XrVector4f set(XrVector4f src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrVector4f malloc() {
        return XrVector4f.wrap(XrVector4f.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrVector4f calloc() {
        return XrVector4f.wrap(XrVector4f.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrVector4f create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrVector4f.wrap(XrVector4f.class, MemoryUtil.memAddress(container), container);
    }

    public static XrVector4f create(long address) {
        return XrVector4f.wrap(XrVector4f.class, address);
    }

    @Nullable
    public static XrVector4f createSafe(long address) {
        return address == 0L ? null : XrVector4f.wrap(XrVector4f.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrVector4f.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrVector4f.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrVector4f.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrVector4f.__create(capacity, SIZEOF);
        return XrVector4f.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrVector4f.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrVector4f.wrap(Buffer.class, address, capacity);
    }

    public static XrVector4f malloc(MemoryStack stack) {
        return XrVector4f.wrap(XrVector4f.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrVector4f calloc(MemoryStack stack) {
        return XrVector4f.wrap(XrVector4f.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrVector4f.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrVector4f.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return UNSAFE.getFloat(null, struct + (long)X);
    }

    public static float ny(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Y);
    }

    public static float nz(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Z);
    }

    public static float nw(long struct) {
        return UNSAFE.getFloat(null, struct + (long)W);
    }

    public static void nx(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Y, value);
    }

    public static void nz(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Z, value);
    }

    public static void nw(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)W, value);
    }

    static {
        Struct.Layout layout = XrVector4f.__struct(XrVector4f.__member(4), XrVector4f.__member(4), XrVector4f.__member(4), XrVector4f.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
        W = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrVector4f, Buffer>
    implements NativeResource {
        private static final XrVector4f ELEMENT_FACTORY = XrVector4f.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrVector4f getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return XrVector4f.nx(this.address());
        }

        public float y() {
            return XrVector4f.ny(this.address());
        }

        public float z() {
            return XrVector4f.nz(this.address());
        }

        public float w() {
            return XrVector4f.nw(this.address());
        }

        public Buffer x(float value) {
            XrVector4f.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            XrVector4f.ny(this.address(), value);
            return this;
        }

        public Buffer z(float value) {
            XrVector4f.nz(this.address(), value);
            return this;
        }

        public Buffer w(float value) {
            XrVector4f.nw(this.address(), value);
            return this;
        }
    }
}

