/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrFovf;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrViewConfigurationViewFovEPIC
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int RECOMMENDEDFOV;
    public static final int MAXMUTABLEFOV;

    public XrViewConfigurationViewFovEPIC(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrViewConfigurationViewFovEPIC.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrViewConfigurationViewFovEPIC.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrViewConfigurationViewFovEPIC.nnext(this.address());
    }

    public XrFovf recommendedFov() {
        return XrViewConfigurationViewFovEPIC.nrecommendedFov(this.address());
    }

    public XrFovf maxMutableFov() {
        return XrViewConfigurationViewFovEPIC.nmaxMutableFov(this.address());
    }

    public XrViewConfigurationViewFovEPIC type(@NativeType(value="XrStructureType") int value) {
        XrViewConfigurationViewFovEPIC.ntype(this.address(), value);
        return this;
    }

    public XrViewConfigurationViewFovEPIC type$Default() {
        return this.type(1000059000);
    }

    public XrViewConfigurationViewFovEPIC next(@NativeType(value="void const *") long value) {
        XrViewConfigurationViewFovEPIC.nnext(this.address(), value);
        return this;
    }

    public XrViewConfigurationViewFovEPIC recommendedFov(XrFovf value) {
        XrViewConfigurationViewFovEPIC.nrecommendedFov(this.address(), value);
        return this;
    }

    public XrViewConfigurationViewFovEPIC recommendedFov(Consumer<XrFovf> consumer) {
        consumer.accept(this.recommendedFov());
        return this;
    }

    public XrViewConfigurationViewFovEPIC maxMutableFov(XrFovf value) {
        XrViewConfigurationViewFovEPIC.nmaxMutableFov(this.address(), value);
        return this;
    }

    public XrViewConfigurationViewFovEPIC maxMutableFov(Consumer<XrFovf> consumer) {
        consumer.accept(this.maxMutableFov());
        return this;
    }

    public XrViewConfigurationViewFovEPIC set(int type, long next, XrFovf recommendedFov, XrFovf maxMutableFov) {
        this.type(type);
        this.next(next);
        this.recommendedFov(recommendedFov);
        this.maxMutableFov(maxMutableFov);
        return this;
    }

    public XrViewConfigurationViewFovEPIC set(XrViewConfigurationViewFovEPIC src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrViewConfigurationViewFovEPIC malloc() {
        return XrViewConfigurationViewFovEPIC.wrap(XrViewConfigurationViewFovEPIC.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrViewConfigurationViewFovEPIC calloc() {
        return XrViewConfigurationViewFovEPIC.wrap(XrViewConfigurationViewFovEPIC.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrViewConfigurationViewFovEPIC create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrViewConfigurationViewFovEPIC.wrap(XrViewConfigurationViewFovEPIC.class, MemoryUtil.memAddress(container), container);
    }

    public static XrViewConfigurationViewFovEPIC create(long address) {
        return XrViewConfigurationViewFovEPIC.wrap(XrViewConfigurationViewFovEPIC.class, address);
    }

    @Nullable
    public static XrViewConfigurationViewFovEPIC createSafe(long address) {
        return address == 0L ? null : XrViewConfigurationViewFovEPIC.wrap(XrViewConfigurationViewFovEPIC.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrViewConfigurationViewFovEPIC.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrViewConfigurationViewFovEPIC.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrViewConfigurationViewFovEPIC.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrViewConfigurationViewFovEPIC.__create(capacity, SIZEOF);
        return XrViewConfigurationViewFovEPIC.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrViewConfigurationViewFovEPIC.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrViewConfigurationViewFovEPIC.wrap(Buffer.class, address, capacity);
    }

    public static XrViewConfigurationViewFovEPIC malloc(MemoryStack stack) {
        return XrViewConfigurationViewFovEPIC.wrap(XrViewConfigurationViewFovEPIC.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrViewConfigurationViewFovEPIC calloc(MemoryStack stack) {
        return XrViewConfigurationViewFovEPIC.wrap(XrViewConfigurationViewFovEPIC.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrViewConfigurationViewFovEPIC.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrViewConfigurationViewFovEPIC.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static XrFovf nrecommendedFov(long struct) {
        return XrFovf.create(struct + (long)RECOMMENDEDFOV);
    }

    public static XrFovf nmaxMutableFov(long struct) {
        return XrFovf.create(struct + (long)MAXMUTABLEFOV);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nrecommendedFov(long struct, XrFovf value) {
        MemoryUtil.memCopy(value.address(), struct + (long)RECOMMENDEDFOV, XrFovf.SIZEOF);
    }

    public static void nmaxMutableFov(long struct, XrFovf value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MAXMUTABLEFOV, XrFovf.SIZEOF);
    }

    static {
        Struct.Layout layout = XrViewConfigurationViewFovEPIC.__struct(XrViewConfigurationViewFovEPIC.__member(4), XrViewConfigurationViewFovEPIC.__member(POINTER_SIZE), XrViewConfigurationViewFovEPIC.__member(XrFovf.SIZEOF, XrFovf.ALIGNOF), XrViewConfigurationViewFovEPIC.__member(XrFovf.SIZEOF, XrFovf.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        RECOMMENDEDFOV = layout.offsetof(2);
        MAXMUTABLEFOV = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrViewConfigurationViewFovEPIC, Buffer>
    implements NativeResource {
        private static final XrViewConfigurationViewFovEPIC ELEMENT_FACTORY = XrViewConfigurationViewFovEPIC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrViewConfigurationViewFovEPIC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrViewConfigurationViewFovEPIC.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrViewConfigurationViewFovEPIC.nnext(this.address());
        }

        public XrFovf recommendedFov() {
            return XrViewConfigurationViewFovEPIC.nrecommendedFov(this.address());
        }

        public XrFovf maxMutableFov() {
            return XrViewConfigurationViewFovEPIC.nmaxMutableFov(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrViewConfigurationViewFovEPIC.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000059000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrViewConfigurationViewFovEPIC.nnext(this.address(), value);
            return this;
        }

        public Buffer recommendedFov(XrFovf value) {
            XrViewConfigurationViewFovEPIC.nrecommendedFov(this.address(), value);
            return this;
        }

        public Buffer recommendedFov(Consumer<XrFovf> consumer) {
            consumer.accept(this.recommendedFov());
            return this;
        }

        public Buffer maxMutableFov(XrFovf value) {
            XrViewConfigurationViewFovEPIC.nmaxMutableFov(this.address(), value);
            return this;
        }

        public Buffer maxMutableFov(Consumer<XrFovf> consumer) {
            consumer.accept(this.maxMutableFov());
            return this;
        }
    }
}

