/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkDeviceCreateInfo;
import org.lwjgl.vulkan.VkPhysicalDevice;

public class XrVulkanDeviceCreateInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SYSTEMID;
    public static final int CREATEFLAGS;
    public static final int PFNGETINSTANCEPROCADDR;
    public static final int VULKANPHYSICALDEVICE;
    public static final int VULKANCREATEINFO;
    public static final int VULKANALLOCATOR;

    public XrVulkanDeviceCreateInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrVulkanDeviceCreateInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrVulkanDeviceCreateInfoKHR.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrVulkanDeviceCreateInfoKHR.nnext(this.address());
    }

    @NativeType(value="XrSystemId")
    public long systemId() {
        return XrVulkanDeviceCreateInfoKHR.nsystemId(this.address());
    }

    @NativeType(value="XrVulkanDeviceCreateFlagsKHR")
    public long createFlags() {
        return XrVulkanDeviceCreateInfoKHR.ncreateFlags(this.address());
    }

    @NativeType(value="PFN_vkGetInstanceProcAddr")
    public long pfnGetInstanceProcAddr() {
        return XrVulkanDeviceCreateInfoKHR.npfnGetInstanceProcAddr(this.address());
    }

    @NativeType(value="VkPhysicalDevice")
    public long vulkanPhysicalDevice() {
        return XrVulkanDeviceCreateInfoKHR.nvulkanPhysicalDevice(this.address());
    }

    @NativeType(value="VkDeviceCreateInfo const *")
    public VkDeviceCreateInfo vulkanCreateInfo() {
        return XrVulkanDeviceCreateInfoKHR.nvulkanCreateInfo(this.address());
    }

    @Nullable
    @NativeType(value="VkAllocationCallbacks const *")
    public VkAllocationCallbacks vulkanAllocator() {
        return XrVulkanDeviceCreateInfoKHR.nvulkanAllocator(this.address());
    }

    public XrVulkanDeviceCreateInfoKHR type(@NativeType(value="XrStructureType") int value) {
        XrVulkanDeviceCreateInfoKHR.ntype(this.address(), value);
        return this;
    }

    public XrVulkanDeviceCreateInfoKHR type$Default() {
        return this.type(1000090001);
    }

    public XrVulkanDeviceCreateInfoKHR next(@NativeType(value="void const *") long value) {
        XrVulkanDeviceCreateInfoKHR.nnext(this.address(), value);
        return this;
    }

    public XrVulkanDeviceCreateInfoKHR systemId(@NativeType(value="XrSystemId") long value) {
        XrVulkanDeviceCreateInfoKHR.nsystemId(this.address(), value);
        return this;
    }

    public XrVulkanDeviceCreateInfoKHR createFlags(@NativeType(value="XrVulkanDeviceCreateFlagsKHR") long value) {
        XrVulkanDeviceCreateInfoKHR.ncreateFlags(this.address(), value);
        return this;
    }

    public XrVulkanDeviceCreateInfoKHR pfnGetInstanceProcAddr(@NativeType(value="PFN_vkGetInstanceProcAddr") long value) {
        XrVulkanDeviceCreateInfoKHR.npfnGetInstanceProcAddr(this.address(), value);
        return this;
    }

    public XrVulkanDeviceCreateInfoKHR vulkanPhysicalDevice(VkPhysicalDevice value) {
        XrVulkanDeviceCreateInfoKHR.nvulkanPhysicalDevice(this.address(), value);
        return this;
    }

    public XrVulkanDeviceCreateInfoKHR vulkanCreateInfo(@NativeType(value="VkDeviceCreateInfo const *") VkDeviceCreateInfo value) {
        XrVulkanDeviceCreateInfoKHR.nvulkanCreateInfo(this.address(), value);
        return this;
    }

    public XrVulkanDeviceCreateInfoKHR vulkanAllocator(@Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks value) {
        XrVulkanDeviceCreateInfoKHR.nvulkanAllocator(this.address(), value);
        return this;
    }

    public XrVulkanDeviceCreateInfoKHR set(int type, long next, long systemId, long createFlags, long pfnGetInstanceProcAddr, VkPhysicalDevice vulkanPhysicalDevice, VkDeviceCreateInfo vulkanCreateInfo, @Nullable VkAllocationCallbacks vulkanAllocator) {
        this.type(type);
        this.next(next);
        this.systemId(systemId);
        this.createFlags(createFlags);
        this.pfnGetInstanceProcAddr(pfnGetInstanceProcAddr);
        this.vulkanPhysicalDevice(vulkanPhysicalDevice);
        this.vulkanCreateInfo(vulkanCreateInfo);
        this.vulkanAllocator(vulkanAllocator);
        return this;
    }

    public XrVulkanDeviceCreateInfoKHR set(XrVulkanDeviceCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrVulkanDeviceCreateInfoKHR malloc() {
        return XrVulkanDeviceCreateInfoKHR.wrap(XrVulkanDeviceCreateInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrVulkanDeviceCreateInfoKHR calloc() {
        return XrVulkanDeviceCreateInfoKHR.wrap(XrVulkanDeviceCreateInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrVulkanDeviceCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrVulkanDeviceCreateInfoKHR.wrap(XrVulkanDeviceCreateInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static XrVulkanDeviceCreateInfoKHR create(long address) {
        return XrVulkanDeviceCreateInfoKHR.wrap(XrVulkanDeviceCreateInfoKHR.class, address);
    }

    @Nullable
    public static XrVulkanDeviceCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : XrVulkanDeviceCreateInfoKHR.wrap(XrVulkanDeviceCreateInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrVulkanDeviceCreateInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrVulkanDeviceCreateInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrVulkanDeviceCreateInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrVulkanDeviceCreateInfoKHR.__create(capacity, SIZEOF);
        return XrVulkanDeviceCreateInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrVulkanDeviceCreateInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrVulkanDeviceCreateInfoKHR.wrap(Buffer.class, address, capacity);
    }

    public static XrVulkanDeviceCreateInfoKHR malloc(MemoryStack stack) {
        return XrVulkanDeviceCreateInfoKHR.wrap(XrVulkanDeviceCreateInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrVulkanDeviceCreateInfoKHR calloc(MemoryStack stack) {
        return XrVulkanDeviceCreateInfoKHR.wrap(XrVulkanDeviceCreateInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrVulkanDeviceCreateInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrVulkanDeviceCreateInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nsystemId(long struct) {
        return UNSAFE.getLong(null, struct + (long)SYSTEMID);
    }

    public static long ncreateFlags(long struct) {
        return UNSAFE.getLong(null, struct + (long)CREATEFLAGS);
    }

    public static long npfnGetInstanceProcAddr(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PFNGETINSTANCEPROCADDR);
    }

    public static long nvulkanPhysicalDevice(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VULKANPHYSICALDEVICE);
    }

    public static VkDeviceCreateInfo nvulkanCreateInfo(long struct) {
        return VkDeviceCreateInfo.create(MemoryUtil.memGetAddress(struct + (long)VULKANCREATEINFO));
    }

    @Nullable
    public static VkAllocationCallbacks nvulkanAllocator(long struct) {
        return VkAllocationCallbacks.createSafe(MemoryUtil.memGetAddress(struct + (long)VULKANALLOCATOR));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nsystemId(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SYSTEMID, value);
    }

    public static void ncreateFlags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)CREATEFLAGS, value);
    }

    public static void npfnGetInstanceProcAddr(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PFNGETINSTANCEPROCADDR, Checks.check(value));
    }

    public static void nvulkanPhysicalDevice(long struct, VkPhysicalDevice value) {
        MemoryUtil.memPutAddress(struct + (long)VULKANPHYSICALDEVICE, value.address());
    }

    public static void nvulkanCreateInfo(long struct, VkDeviceCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)VULKANCREATEINFO, value.address());
    }

    public static void nvulkanAllocator(long struct, @Nullable VkAllocationCallbacks value) {
        MemoryUtil.memPutAddress(struct + (long)VULKANALLOCATOR, MemoryUtil.memAddressSafe(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PFNGETINSTANCEPROCADDR));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VULKANPHYSICALDEVICE));
        long vulkanCreateInfo = MemoryUtil.memGetAddress(struct + (long)VULKANCREATEINFO);
        Checks.check(vulkanCreateInfo);
        VkDeviceCreateInfo.validate(vulkanCreateInfo);
    }

    static {
        Struct.Layout layout = XrVulkanDeviceCreateInfoKHR.__struct(XrVulkanDeviceCreateInfoKHR.__member(4), XrVulkanDeviceCreateInfoKHR.__member(POINTER_SIZE), XrVulkanDeviceCreateInfoKHR.__member(8), XrVulkanDeviceCreateInfoKHR.__member(8), XrVulkanDeviceCreateInfoKHR.__member(POINTER_SIZE), XrVulkanDeviceCreateInfoKHR.__member(POINTER_SIZE), XrVulkanDeviceCreateInfoKHR.__member(POINTER_SIZE), XrVulkanDeviceCreateInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SYSTEMID = layout.offsetof(2);
        CREATEFLAGS = layout.offsetof(3);
        PFNGETINSTANCEPROCADDR = layout.offsetof(4);
        VULKANPHYSICALDEVICE = layout.offsetof(5);
        VULKANCREATEINFO = layout.offsetof(6);
        VULKANALLOCATOR = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<XrVulkanDeviceCreateInfoKHR, Buffer>
    implements NativeResource {
        private static final XrVulkanDeviceCreateInfoKHR ELEMENT_FACTORY = XrVulkanDeviceCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrVulkanDeviceCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrVulkanDeviceCreateInfoKHR.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrVulkanDeviceCreateInfoKHR.nnext(this.address());
        }

        @NativeType(value="XrSystemId")
        public long systemId() {
            return XrVulkanDeviceCreateInfoKHR.nsystemId(this.address());
        }

        @NativeType(value="XrVulkanDeviceCreateFlagsKHR")
        public long createFlags() {
            return XrVulkanDeviceCreateInfoKHR.ncreateFlags(this.address());
        }

        @NativeType(value="PFN_vkGetInstanceProcAddr")
        public long pfnGetInstanceProcAddr() {
            return XrVulkanDeviceCreateInfoKHR.npfnGetInstanceProcAddr(this.address());
        }

        @NativeType(value="VkPhysicalDevice")
        public long vulkanPhysicalDevice() {
            return XrVulkanDeviceCreateInfoKHR.nvulkanPhysicalDevice(this.address());
        }

        @NativeType(value="VkDeviceCreateInfo const *")
        public VkDeviceCreateInfo vulkanCreateInfo() {
            return XrVulkanDeviceCreateInfoKHR.nvulkanCreateInfo(this.address());
        }

        @Nullable
        @NativeType(value="VkAllocationCallbacks const *")
        public VkAllocationCallbacks vulkanAllocator() {
            return XrVulkanDeviceCreateInfoKHR.nvulkanAllocator(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrVulkanDeviceCreateInfoKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000090001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrVulkanDeviceCreateInfoKHR.nnext(this.address(), value);
            return this;
        }

        public Buffer systemId(@NativeType(value="XrSystemId") long value) {
            XrVulkanDeviceCreateInfoKHR.nsystemId(this.address(), value);
            return this;
        }

        public Buffer createFlags(@NativeType(value="XrVulkanDeviceCreateFlagsKHR") long value) {
            XrVulkanDeviceCreateInfoKHR.ncreateFlags(this.address(), value);
            return this;
        }

        public Buffer pfnGetInstanceProcAddr(@NativeType(value="PFN_vkGetInstanceProcAddr") long value) {
            XrVulkanDeviceCreateInfoKHR.npfnGetInstanceProcAddr(this.address(), value);
            return this;
        }

        public Buffer vulkanPhysicalDevice(VkPhysicalDevice value) {
            XrVulkanDeviceCreateInfoKHR.nvulkanPhysicalDevice(this.address(), value);
            return this;
        }

        public Buffer vulkanCreateInfo(@NativeType(value="VkDeviceCreateInfo const *") VkDeviceCreateInfo value) {
            XrVulkanDeviceCreateInfoKHR.nvulkanCreateInfo(this.address(), value);
            return this;
        }

        public Buffer vulkanAllocator(@Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks value) {
            XrVulkanDeviceCreateInfoKHR.nvulkanAllocator(this.address(), value);
            return this;
        }
    }
}

