/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkInstance;

public class XrVulkanGraphicsDeviceGetInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SYSTEMID;
    public static final int VULKANINSTANCE;

    public XrVulkanGraphicsDeviceGetInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrVulkanGraphicsDeviceGetInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrVulkanGraphicsDeviceGetInfoKHR.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrVulkanGraphicsDeviceGetInfoKHR.nnext(this.address());
    }

    @NativeType(value="XrSystemId")
    public long systemId() {
        return XrVulkanGraphicsDeviceGetInfoKHR.nsystemId(this.address());
    }

    @NativeType(value="VkInstance")
    public long vulkanInstance() {
        return XrVulkanGraphicsDeviceGetInfoKHR.nvulkanInstance(this.address());
    }

    public XrVulkanGraphicsDeviceGetInfoKHR type(@NativeType(value="XrStructureType") int value) {
        XrVulkanGraphicsDeviceGetInfoKHR.ntype(this.address(), value);
        return this;
    }

    public XrVulkanGraphicsDeviceGetInfoKHR type$Default() {
        return this.type(1000090003);
    }

    public XrVulkanGraphicsDeviceGetInfoKHR next(@NativeType(value="void const *") long value) {
        XrVulkanGraphicsDeviceGetInfoKHR.nnext(this.address(), value);
        return this;
    }

    public XrVulkanGraphicsDeviceGetInfoKHR systemId(@NativeType(value="XrSystemId") long value) {
        XrVulkanGraphicsDeviceGetInfoKHR.nsystemId(this.address(), value);
        return this;
    }

    public XrVulkanGraphicsDeviceGetInfoKHR vulkanInstance(VkInstance value) {
        XrVulkanGraphicsDeviceGetInfoKHR.nvulkanInstance(this.address(), value);
        return this;
    }

    public XrVulkanGraphicsDeviceGetInfoKHR set(int type, long next, long systemId, VkInstance vulkanInstance) {
        this.type(type);
        this.next(next);
        this.systemId(systemId);
        this.vulkanInstance(vulkanInstance);
        return this;
    }

    public XrVulkanGraphicsDeviceGetInfoKHR set(XrVulkanGraphicsDeviceGetInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrVulkanGraphicsDeviceGetInfoKHR malloc() {
        return XrVulkanGraphicsDeviceGetInfoKHR.wrap(XrVulkanGraphicsDeviceGetInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrVulkanGraphicsDeviceGetInfoKHR calloc() {
        return XrVulkanGraphicsDeviceGetInfoKHR.wrap(XrVulkanGraphicsDeviceGetInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrVulkanGraphicsDeviceGetInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrVulkanGraphicsDeviceGetInfoKHR.wrap(XrVulkanGraphicsDeviceGetInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static XrVulkanGraphicsDeviceGetInfoKHR create(long address) {
        return XrVulkanGraphicsDeviceGetInfoKHR.wrap(XrVulkanGraphicsDeviceGetInfoKHR.class, address);
    }

    @Nullable
    public static XrVulkanGraphicsDeviceGetInfoKHR createSafe(long address) {
        return address == 0L ? null : XrVulkanGraphicsDeviceGetInfoKHR.wrap(XrVulkanGraphicsDeviceGetInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrVulkanGraphicsDeviceGetInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrVulkanGraphicsDeviceGetInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrVulkanGraphicsDeviceGetInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrVulkanGraphicsDeviceGetInfoKHR.__create(capacity, SIZEOF);
        return XrVulkanGraphicsDeviceGetInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrVulkanGraphicsDeviceGetInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrVulkanGraphicsDeviceGetInfoKHR.wrap(Buffer.class, address, capacity);
    }

    public static XrVulkanGraphicsDeviceGetInfoKHR malloc(MemoryStack stack) {
        return XrVulkanGraphicsDeviceGetInfoKHR.wrap(XrVulkanGraphicsDeviceGetInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrVulkanGraphicsDeviceGetInfoKHR calloc(MemoryStack stack) {
        return XrVulkanGraphicsDeviceGetInfoKHR.wrap(XrVulkanGraphicsDeviceGetInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrVulkanGraphicsDeviceGetInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrVulkanGraphicsDeviceGetInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nsystemId(long struct) {
        return UNSAFE.getLong(null, struct + (long)SYSTEMID);
    }

    public static long nvulkanInstance(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VULKANINSTANCE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nsystemId(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SYSTEMID, value);
    }

    public static void nvulkanInstance(long struct, VkInstance value) {
        MemoryUtil.memPutAddress(struct + (long)VULKANINSTANCE, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VULKANINSTANCE));
    }

    static {
        Struct.Layout layout = XrVulkanGraphicsDeviceGetInfoKHR.__struct(XrVulkanGraphicsDeviceGetInfoKHR.__member(4), XrVulkanGraphicsDeviceGetInfoKHR.__member(POINTER_SIZE), XrVulkanGraphicsDeviceGetInfoKHR.__member(8), XrVulkanGraphicsDeviceGetInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SYSTEMID = layout.offsetof(2);
        VULKANINSTANCE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrVulkanGraphicsDeviceGetInfoKHR, Buffer>
    implements NativeResource {
        private static final XrVulkanGraphicsDeviceGetInfoKHR ELEMENT_FACTORY = XrVulkanGraphicsDeviceGetInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrVulkanGraphicsDeviceGetInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrVulkanGraphicsDeviceGetInfoKHR.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrVulkanGraphicsDeviceGetInfoKHR.nnext(this.address());
        }

        @NativeType(value="XrSystemId")
        public long systemId() {
            return XrVulkanGraphicsDeviceGetInfoKHR.nsystemId(this.address());
        }

        @NativeType(value="VkInstance")
        public long vulkanInstance() {
            return XrVulkanGraphicsDeviceGetInfoKHR.nvulkanInstance(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrVulkanGraphicsDeviceGetInfoKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000090003);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrVulkanGraphicsDeviceGetInfoKHR.nnext(this.address(), value);
            return this;
        }

        public Buffer systemId(@NativeType(value="XrSystemId") long value) {
            XrVulkanGraphicsDeviceGetInfoKHR.nsystemId(this.address(), value);
            return this;
        }

        public Buffer vulkanInstance(VkInstance value) {
            XrVulkanGraphicsDeviceGetInfoKHR.nvulkanInstance(this.address(), value);
            return this;
        }
    }
}

