/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.libdivide;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct libdivide_s16_t")
public class LibDivideS16
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAGIC;
    public static final int MORE;

    public LibDivideS16(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LibDivideS16.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int16_t")
    public short magic() {
        return LibDivideS16.nmagic(this.address());
    }

    @NativeType(value="uint8_t")
    public byte more() {
        return LibDivideS16.nmore(this.address());
    }

    public LibDivideS16 magic(@NativeType(value="int16_t") short value) {
        LibDivideS16.nmagic(this.address(), value);
        return this;
    }

    public LibDivideS16 more(@NativeType(value="uint8_t") byte value) {
        LibDivideS16.nmore(this.address(), value);
        return this;
    }

    public LibDivideS16 set(short magic, byte more) {
        this.magic(magic);
        this.more(more);
        return this;
    }

    public LibDivideS16 set(LibDivideS16 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LibDivideS16 malloc() {
        return LibDivideS16.wrap(LibDivideS16.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static LibDivideS16 calloc() {
        return LibDivideS16.wrap(LibDivideS16.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static LibDivideS16 create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return LibDivideS16.wrap(LibDivideS16.class, MemoryUtil.memAddress(container), container);
    }

    public static LibDivideS16 create(long address) {
        return LibDivideS16.wrap(LibDivideS16.class, address);
    }

    @Nullable
    public static LibDivideS16 createSafe(long address) {
        return address == 0L ? null : LibDivideS16.wrap(LibDivideS16.class, address);
    }

    public static Buffer malloc(int capacity) {
        return LibDivideS16.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(LibDivideS16.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return LibDivideS16.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LibDivideS16.__create(capacity, SIZEOF);
        return LibDivideS16.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return LibDivideS16.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : LibDivideS16.wrap(Buffer.class, address, capacity);
    }

    public static LibDivideS16 malloc(MemoryStack stack) {
        return LibDivideS16.wrap(LibDivideS16.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static LibDivideS16 calloc(MemoryStack stack) {
        return LibDivideS16.wrap(LibDivideS16.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return LibDivideS16.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return LibDivideS16.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static short nmagic(long struct) {
        return UNSAFE.getShort(null, struct + (long)MAGIC);
    }

    public static byte nmore(long struct) {
        return UNSAFE.getByte(null, struct + (long)MORE);
    }

    public static void nmagic(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)MAGIC, value);
    }

    public static void nmore(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)MORE, value);
    }

    static {
        Struct.Layout layout = LibDivideS16.__struct(LibDivideS16.__member(2), LibDivideS16.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAGIC = layout.offsetof(0);
        MORE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LibDivideS16, Buffer>
    implements NativeResource {
        private static final LibDivideS16 ELEMENT_FACTORY = LibDivideS16.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected LibDivideS16 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int16_t")
        public short magic() {
            return LibDivideS16.nmagic(this.address());
        }

        @NativeType(value="uint8_t")
        public byte more() {
            return LibDivideS16.nmore(this.address());
        }

        public Buffer magic(@NativeType(value="int16_t") short value) {
            LibDivideS16.nmagic(this.address(), value);
            return this;
        }

        public Buffer more(@NativeType(value="uint8_t") byte value) {
            LibDivideS16.nmore(this.address(), value);
            return this;
        }
    }
}

