/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.util.lz4.LZ4FCompressOptions;
import org.lwjgl.util.lz4.LZ4FDecompressOptions;
import org.lwjgl.util.lz4.LZ4FFrameInfo;
import org.lwjgl.util.lz4.LZ4FPreferences;
import org.lwjgl.util.lz4.LibLZ4;

public class LZ4Frame {
    public static final int LZ4F_VERSION = 100;
    public static final int LZ4F_HEADER_SIZE_MIN = 7;
    public static final int LZ4F_HEADER_SIZE_MAX = 19;
    public static final int LZ4F_BLOCK_HEADER_SIZE = 4;
    public static final int LZ4F_BLOCK_CHECKSUM_SIZE = 4;
    public static final int LZ4F_CONTENT_CHECKSUM_SIZE = 4;
    public static final int LZ4F_default = 0;
    public static final int LZ4F_max64KB = 4;
    public static final int LZ4F_max256KB = 5;
    public static final int LZ4F_max1MB = 6;
    public static final int LZ4F_max4MB = 7;
    public static final int LZ4F_blockLinked = 0;
    public static final int LZ4F_blockIndependent = 1;
    public static final int LZ4F_noContentChecksum = 0;
    public static final int LZ4F_contentChecksumEnabled = 1;
    public static final int LZ4F_noBlockChecksum = 0;
    public static final int LZ4F_blockChecksumEnabled = 1;
    public static final int LZ4F_frame = 0;
    public static final int LZ4F_skippableFrame = 1;
    public static final int LZ4F_OK_NoError = 0;
    public static final int LZ4F_ERROR_GENERIC = 1;
    public static final int LZ4F_ERROR_maxBlockSize_invalid = 2;
    public static final int LZ4F_ERROR_blockMode_invalid = 3;
    public static final int LZ4F_ERROR_contentChecksumFlag_invalid = 4;
    public static final int LZ4F_ERROR_compressionLevel_invalid = 5;
    public static final int LZ4F_ERROR_headerVersion_wrong = 6;
    public static final int LZ4F_ERROR_blockChecksum_invalid = 7;
    public static final int LZ4F_ERROR_reservedFlag_set = 8;
    public static final int LZ4F_ERROR_allocation_failed = 9;
    public static final int LZ4F_ERROR_srcSize_tooLarge = 10;
    public static final int LZ4F_ERROR_dstMaxSize_tooSmall = 11;
    public static final int LZ4F_ERROR_frameHeader_incomplete = 12;
    public static final int LZ4F_ERROR_frameType_unknown = 13;
    public static final int LZ4F_ERROR_frameSize_wrong = 14;
    public static final int LZ4F_ERROR_srcPtr_wrong = 15;
    public static final int LZ4F_ERROR_decompressionFailed = 16;
    public static final int LZ4F_ERROR_headerChecksum_invalid = 17;
    public static final int LZ4F_ERROR_contentChecksum_invalid = 18;
    public static final int LZ4F_ERROR_frameDecoding_alreadyStarted = 19;
    public static final int LZ4F_ERROR_maxCode = 20;

    protected LZ4Frame() {
        throw new UnsupportedOperationException();
    }

    public static native int nLZ4F_isError(long var0);

    @NativeType(value="unsigned")
    public static boolean LZ4F_isError(@NativeType(value="LZ4F_errorCode_t") long code) {
        return LZ4Frame.nLZ4F_isError(code) != 0;
    }

    public static native long nLZ4F_getErrorName(long var0);

    @Nullable
    @NativeType(value="char const *")
    public static String LZ4F_getErrorName(@NativeType(value="LZ4F_errorCode_t") long code) {
        long __result = LZ4Frame.nLZ4F_getErrorName(code);
        return MemoryUtil.memASCIISafe(__result);
    }

    public static native int LZ4F_compressionLevel_max();

    public static native long nLZ4F_compressFrameBound(long var0, long var2);

    @NativeType(value="size_t")
    public static long LZ4F_compressFrameBound(@NativeType(value="size_t") long srcSize, @Nullable @NativeType(value="LZ4F_preferences_t const *") LZ4FPreferences preferencesPtr) {
        return LZ4Frame.nLZ4F_compressFrameBound(srcSize, MemoryUtil.memAddressSafe(preferencesPtr));
    }

    public static native long nLZ4F_compressFrame(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="size_t")
    public static long LZ4F_compressFrame(@NativeType(value="void *") ByteBuffer dstBuffer, @NativeType(value="void const *") ByteBuffer srcBuffer, @Nullable @NativeType(value="LZ4F_preferences_t const *") LZ4FPreferences preferencesPtr) {
        return LZ4Frame.nLZ4F_compressFrame(MemoryUtil.memAddress(dstBuffer), dstBuffer.remaining(), MemoryUtil.memAddress(srcBuffer), srcBuffer.remaining(), MemoryUtil.memAddressSafe(preferencesPtr));
    }

    @NativeType(value="unsigned")
    public static native int LZ4F_getVersion();

    public static native long nLZ4F_createCompressionContext(long var0, int var2);

    @NativeType(value="LZ4F_errorCode_t")
    public static long LZ4F_createCompressionContext(@NativeType(value="LZ4F_cctx **") PointerBuffer cctxPtr, @NativeType(value="unsigned") int version) {
        if (Checks.CHECKS) {
            Checks.check(cctxPtr, 1);
        }
        return LZ4Frame.nLZ4F_createCompressionContext(MemoryUtil.memAddress(cctxPtr), version);
    }

    public static native long nLZ4F_freeCompressionContext(long var0);

    @NativeType(value="LZ4F_errorCode_t")
    public static long LZ4F_freeCompressionContext(@NativeType(value="LZ4F_cctx *") long cctx) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
        }
        return LZ4Frame.nLZ4F_freeCompressionContext(cctx);
    }

    public static native long nLZ4F_compressBegin(long var0, long var2, long var4, long var6);

    @NativeType(value="size_t")
    public static long LZ4F_compressBegin(@NativeType(value="LZ4F_cctx *") long cctx, @NativeType(value="void *") ByteBuffer dstBuffer, @Nullable @NativeType(value="LZ4F_preferences_t const *") LZ4FPreferences prefsPtr) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
        }
        return LZ4Frame.nLZ4F_compressBegin(cctx, MemoryUtil.memAddress(dstBuffer), dstBuffer.remaining(), MemoryUtil.memAddressSafe(prefsPtr));
    }

    public static native long nLZ4F_compressBound(long var0, long var2);

    @NativeType(value="size_t")
    public static long LZ4F_compressBound(@NativeType(value="size_t") long srcSize, @Nullable @NativeType(value="LZ4F_preferences_t const *") LZ4FPreferences prefsPtr) {
        return LZ4Frame.nLZ4F_compressBound(srcSize, MemoryUtil.memAddressSafe(prefsPtr));
    }

    public static native long nLZ4F_compressUpdate(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="size_t")
    public static long LZ4F_compressUpdate(@NativeType(value="LZ4F_cctx *") long cctx, @NativeType(value="void *") ByteBuffer dstBuffer, @NativeType(value="void const *") ByteBuffer srcBuffer, @Nullable @NativeType(value="LZ4F_compressOptions_t const *") LZ4FCompressOptions cOptPtr) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
        }
        return LZ4Frame.nLZ4F_compressUpdate(cctx, MemoryUtil.memAddress(dstBuffer), dstBuffer.remaining(), MemoryUtil.memAddress(srcBuffer), srcBuffer.remaining(), MemoryUtil.memAddressSafe(cOptPtr));
    }

    public static native long nLZ4F_flush(long var0, long var2, long var4, long var6);

    @NativeType(value="size_t")
    public static long LZ4F_flush(@NativeType(value="LZ4F_cctx *") long cctx, @NativeType(value="void *") ByteBuffer dstBuffer, @Nullable @NativeType(value="LZ4F_compressOptions_t const *") LZ4FCompressOptions cOptPtr) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
        }
        return LZ4Frame.nLZ4F_flush(cctx, MemoryUtil.memAddress(dstBuffer), dstBuffer.remaining(), MemoryUtil.memAddressSafe(cOptPtr));
    }

    public static native long nLZ4F_compressEnd(long var0, long var2, long var4, long var6);

    @NativeType(value="size_t")
    public static long LZ4F_compressEnd(@NativeType(value="LZ4F_cctx *") long cctx, @NativeType(value="void *") ByteBuffer dstBuffer, @Nullable @NativeType(value="LZ4F_compressOptions_t const *") LZ4FCompressOptions cOptPtr) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
        }
        return LZ4Frame.nLZ4F_compressEnd(cctx, MemoryUtil.memAddress(dstBuffer), dstBuffer.remaining(), MemoryUtil.memAddressSafe(cOptPtr));
    }

    public static native long nLZ4F_createDecompressionContext(long var0, int var2);

    @NativeType(value="LZ4F_errorCode_t")
    public static long LZ4F_createDecompressionContext(@NativeType(value="LZ4F_dctx **") PointerBuffer dctxPtr, @NativeType(value="unsigned") int version) {
        if (Checks.CHECKS) {
            Checks.check(dctxPtr, 1);
        }
        return LZ4Frame.nLZ4F_createDecompressionContext(MemoryUtil.memAddress(dctxPtr), version);
    }

    public static native long nLZ4F_freeDecompressionContext(long var0);

    @NativeType(value="LZ4F_errorCode_t")
    public static long LZ4F_freeDecompressionContext(@NativeType(value="LZ4F_dctx *") long dctx) {
        if (Checks.CHECKS) {
            Checks.check(dctx);
        }
        return LZ4Frame.nLZ4F_freeDecompressionContext(dctx);
    }

    public static native long nLZ4F_getFrameInfo(long var0, long var2, long var4, long var6);

    @NativeType(value="size_t")
    public static long LZ4F_getFrameInfo(@NativeType(value="LZ4F_dctx *") long dctx, @NativeType(value="LZ4F_frameInfo_t *") LZ4FFrameInfo frameInfoPtr, @NativeType(value="void const *") ByteBuffer srcBuffer, @NativeType(value="size_t *") PointerBuffer srcSizePtr) {
        if (Checks.CHECKS) {
            Checks.check(dctx);
            Checks.check(srcSizePtr, 1);
            Checks.check((Buffer)srcBuffer, srcSizePtr.get(srcSizePtr.position()));
        }
        return LZ4Frame.nLZ4F_getFrameInfo(dctx, frameInfoPtr.address(), MemoryUtil.memAddress(srcBuffer), MemoryUtil.memAddress(srcSizePtr));
    }

    public static native long nLZ4F_decompress(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="size_t")
    public static long LZ4F_decompress(@NativeType(value="LZ4F_dctx *") long dctx, @NativeType(value="void *") ByteBuffer dstBuffer, @NativeType(value="size_t *") PointerBuffer dstSizePtr, @NativeType(value="void const *") ByteBuffer srcBuffer, @NativeType(value="size_t *") PointerBuffer srcSizePtr, @NativeType(value="LZ4F_decompressOptions_t const *") LZ4FDecompressOptions dOptPtr) {
        if (Checks.CHECKS) {
            Checks.check(dctx);
            Checks.check(dstSizePtr, 1);
            Checks.check((Buffer)dstBuffer, dstSizePtr.get(dstSizePtr.position()));
            Checks.check(srcSizePtr, 1);
            Checks.check((Buffer)srcBuffer, srcSizePtr.get(srcSizePtr.position()));
        }
        return LZ4Frame.nLZ4F_decompress(dctx, MemoryUtil.memAddress(dstBuffer), MemoryUtil.memAddress(dstSizePtr), MemoryUtil.memAddress(srcBuffer), MemoryUtil.memAddress(srcSizePtr), dOptPtr.address());
    }

    public static native void nLZ4F_resetDecompressionContext(long var0);

    public static void LZ4F_resetDecompressionContext(@NativeType(value="LZ4F_dctx *") long dctx) {
        if (Checks.CHECKS) {
            Checks.check(dctx);
        }
        LZ4Frame.nLZ4F_resetDecompressionContext(dctx);
    }

    @NativeType(value="LZ4F_errorCodes")
    public static native int LZ4F_getErrorCode(@NativeType(value="size_t") long var0);

    public static native long nLZ4F_createCDict(long var0, long var2);

    @NativeType(value="LZ4F_CDict *")
    public static long LZ4F_createCDict(@NativeType(value="void const *") ByteBuffer dictBuffer) {
        return LZ4Frame.nLZ4F_createCDict(MemoryUtil.memAddress(dictBuffer), dictBuffer.remaining());
    }

    public static native void nLZ4F_freeCDict(long var0);

    public static void LZ4F_freeCDict(@NativeType(value="LZ4F_CDict *") long CDict) {
        if (Checks.CHECKS) {
            Checks.check(CDict);
        }
        LZ4Frame.nLZ4F_freeCDict(CDict);
    }

    public static native long nLZ4F_compressFrame_usingCDict(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    @NativeType(value="size_t")
    public static long LZ4F_compressFrame_usingCDict(@NativeType(value="LZ4F_cctx *") long cctx, @NativeType(value="void *") ByteBuffer dst, @NativeType(value="void const *") ByteBuffer src, @NativeType(value="LZ4F_CDict const *") long cdict, @NativeType(value="LZ4F_preferences_t const *") LZ4FPreferences preferencesPtr) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
        }
        return LZ4Frame.nLZ4F_compressFrame_usingCDict(cctx, MemoryUtil.memAddress(dst), dst.remaining(), MemoryUtil.memAddress(src), src.remaining(), cdict, preferencesPtr.address());
    }

    public static native long nLZ4F_compressBegin_usingCDict(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="size_t")
    public static long LZ4F_compressBegin_usingCDict(@NativeType(value="LZ4F_cctx *") long cctx, @NativeType(value="void *") ByteBuffer dstBuffer, @NativeType(value="LZ4F_CDict const *") long cdict, @NativeType(value="LZ4F_preferences_t const *") LZ4FPreferences prefsPtr) {
        if (Checks.CHECKS) {
            Checks.check(cctx);
            Checks.check(cdict);
        }
        return LZ4Frame.nLZ4F_compressBegin_usingCDict(cctx, MemoryUtil.memAddress(dstBuffer), dstBuffer.remaining(), cdict, prefsPtr.address());
    }

    public static native long nLZ4F_decompress_usingDict(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    @NativeType(value="size_t")
    public static long LZ4F_decompress_usingDict(@NativeType(value="LZ4F_dctx *") long dctxPtr, @NativeType(value="void *") ByteBuffer dstBuffer, @NativeType(value="size_t *") PointerBuffer dstSizePtr, @NativeType(value="void const *") ByteBuffer srcBuffer, @NativeType(value="size_t *") PointerBuffer srcSizePtr, @NativeType(value="void const *") ByteBuffer dict, @NativeType(value="LZ4F_decompressOptions_t const *") LZ4FDecompressOptions decompressOptionsPtr) {
        if (Checks.CHECKS) {
            Checks.check(dctxPtr);
            Checks.check(dstSizePtr, 1);
            Checks.check((Buffer)dstBuffer, dstSizePtr.get(dstSizePtr.position()));
            Checks.check(srcSizePtr, 1);
            Checks.check((Buffer)srcBuffer, srcSizePtr.get(srcSizePtr.position()));
        }
        return LZ4Frame.nLZ4F_decompress_usingDict(dctxPtr, MemoryUtil.memAddress(dstBuffer), MemoryUtil.memAddress(dstSizePtr), MemoryUtil.memAddress(srcBuffer), MemoryUtil.memAddress(srcSizePtr), MemoryUtil.memAddress(dict), dict.remaining(), decompressOptionsPtr.address());
    }

    static {
        LibLZ4.initialize();
    }
}

