/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meow;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.meow.LibMeow;

@NativeType(value="struct meow_hash_state")
public class MeowHashState
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;

    private static native int offsets(long var0);

    public MeowHashState(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), MeowHashState.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public static MeowHashState malloc() {
        return MeowHashState.wrap(MeowHashState.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static MeowHashState calloc() {
        return MeowHashState.wrap(MeowHashState.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static MeowHashState create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return MeowHashState.wrap(MeowHashState.class, MemoryUtil.memAddress(container), container);
    }

    public static MeowHashState create(long address) {
        return MeowHashState.wrap(MeowHashState.class, address);
    }

    @Nullable
    public static MeowHashState createSafe(long address) {
        return address == 0L ? null : MeowHashState.wrap(MeowHashState.class, address);
    }

    public static Buffer malloc(int capacity) {
        return MeowHashState.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(MeowHashState.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return MeowHashState.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MeowHashState.__create(capacity, SIZEOF);
        return MeowHashState.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return MeowHashState.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : MeowHashState.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static MeowHashState mallocStack() {
        return MeowHashState.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static MeowHashState callocStack() {
        return MeowHashState.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static MeowHashState mallocStack(MemoryStack stack) {
        return MeowHashState.malloc(stack);
    }

    @Deprecated
    public static MeowHashState callocStack(MemoryStack stack) {
        return MeowHashState.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return MeowHashState.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return MeowHashState.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return MeowHashState.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return MeowHashState.calloc(capacity, stack);
    }

    public static MeowHashState malloc(MemoryStack stack) {
        return MeowHashState.wrap(MeowHashState.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static MeowHashState calloc(MemoryStack stack) {
        return MeowHashState.wrap(MeowHashState.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return MeowHashState.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return MeowHashState.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    static {
        LibMeow.initialize();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer offsets = stack.mallocInt(1);
            SIZEOF = MeowHashState.offsets(MemoryUtil.memAddress(offsets));
            ALIGNOF = offsets.get(0);
        }
    }

    public static class Buffer
    extends StructBuffer<MeowHashState, Buffer>
    implements NativeResource {
        private static final MeowHashState ELEMENT_FACTORY = MeowHashState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected MeowHashState getElementFactory() {
            return ELEMENT_FACTORY;
        }
    }
}

