/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meshoptimizer;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct meshopt_Stream")
public class MeshoptStream
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;
    public static final int SIZE;
    public static final int STRIDE;

    public MeshoptStream(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), MeshoptStream.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void const *")
    public ByteBuffer data(int capacity) {
        return MeshoptStream.ndata(this.address(), capacity);
    }

    @NativeType(value="size_t")
    public long size() {
        return MeshoptStream.nsize(this.address());
    }

    @NativeType(value="size_t")
    public long stride() {
        return MeshoptStream.nstride(this.address());
    }

    public MeshoptStream data(@NativeType(value="void const *") ByteBuffer value) {
        MeshoptStream.ndata(this.address(), value);
        return this;
    }

    public MeshoptStream size(@NativeType(value="size_t") long value) {
        MeshoptStream.nsize(this.address(), value);
        return this;
    }

    public MeshoptStream stride(@NativeType(value="size_t") long value) {
        MeshoptStream.nstride(this.address(), value);
        return this;
    }

    public MeshoptStream set(ByteBuffer data, long size, long stride) {
        this.data(data);
        this.size(size);
        this.stride(stride);
        return this;
    }

    public MeshoptStream set(MeshoptStream src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static MeshoptStream malloc() {
        return MeshoptStream.wrap(MeshoptStream.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static MeshoptStream calloc() {
        return MeshoptStream.wrap(MeshoptStream.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static MeshoptStream create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return MeshoptStream.wrap(MeshoptStream.class, MemoryUtil.memAddress(container), container);
    }

    public static MeshoptStream create(long address) {
        return MeshoptStream.wrap(MeshoptStream.class, address);
    }

    @Nullable
    public static MeshoptStream createSafe(long address) {
        return address == 0L ? null : MeshoptStream.wrap(MeshoptStream.class, address);
    }

    public static Buffer malloc(int capacity) {
        return MeshoptStream.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(MeshoptStream.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return MeshoptStream.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MeshoptStream.__create(capacity, SIZEOF);
        return MeshoptStream.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return MeshoptStream.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : MeshoptStream.wrap(Buffer.class, address, capacity);
    }

    public static MeshoptStream malloc(MemoryStack stack) {
        return MeshoptStream.wrap(MeshoptStream.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static MeshoptStream calloc(MemoryStack stack) {
        return MeshoptStream.wrap(MeshoptStream.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return MeshoptStream.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return MeshoptStream.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndata(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)DATA), capacity);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SIZE);
    }

    public static long nstride(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)STRIDE);
    }

    public static void ndata(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)DATA, MemoryUtil.memAddress(value));
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SIZE, value);
    }

    public static void nstride(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)STRIDE, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)DATA));
    }

    static {
        Struct.Layout layout = MeshoptStream.__struct(MeshoptStream.__member(POINTER_SIZE), MeshoptStream.__member(POINTER_SIZE), MeshoptStream.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        STRIDE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<MeshoptStream, Buffer>
    implements NativeResource {
        private static final MeshoptStream ELEMENT_FACTORY = MeshoptStream.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected MeshoptStream getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void const *")
        public ByteBuffer data(int capacity) {
            return MeshoptStream.ndata(this.address(), capacity);
        }

        @NativeType(value="size_t")
        public long size() {
            return MeshoptStream.nsize(this.address());
        }

        @NativeType(value="size_t")
        public long stride() {
            return MeshoptStream.nstride(this.address());
        }

        public Buffer data(@NativeType(value="void const *") ByteBuffer value) {
            MeshoptStream.ndata(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="size_t") long value) {
            MeshoptStream.nsize(this.address(), value);
            return this;
        }

        public Buffer stride(@NativeType(value="size_t") long value) {
            MeshoptStream.nstride(this.address(), value);
            return this;
        }
    }
}

