/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meshoptimizer;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct meshopt_VertexFetchStatistics")
public class MeshoptVertexFetchStatistics
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BYTES_FETCHED;
    public static final int OVERFETCH;

    public MeshoptVertexFetchStatistics(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), MeshoptVertexFetchStatistics.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int bytes_fetched() {
        return MeshoptVertexFetchStatistics.nbytes_fetched(this.address());
    }

    public float overfetch() {
        return MeshoptVertexFetchStatistics.noverfetch(this.address());
    }

    public static MeshoptVertexFetchStatistics malloc() {
        return MeshoptVertexFetchStatistics.wrap(MeshoptVertexFetchStatistics.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static MeshoptVertexFetchStatistics calloc() {
        return MeshoptVertexFetchStatistics.wrap(MeshoptVertexFetchStatistics.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static MeshoptVertexFetchStatistics create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return MeshoptVertexFetchStatistics.wrap(MeshoptVertexFetchStatistics.class, MemoryUtil.memAddress(container), container);
    }

    public static MeshoptVertexFetchStatistics create(long address) {
        return MeshoptVertexFetchStatistics.wrap(MeshoptVertexFetchStatistics.class, address);
    }

    @Nullable
    public static MeshoptVertexFetchStatistics createSafe(long address) {
        return address == 0L ? null : MeshoptVertexFetchStatistics.wrap(MeshoptVertexFetchStatistics.class, address);
    }

    public static Buffer malloc(int capacity) {
        return MeshoptVertexFetchStatistics.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(MeshoptVertexFetchStatistics.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return MeshoptVertexFetchStatistics.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MeshoptVertexFetchStatistics.__create(capacity, SIZEOF);
        return MeshoptVertexFetchStatistics.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return MeshoptVertexFetchStatistics.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : MeshoptVertexFetchStatistics.wrap(Buffer.class, address, capacity);
    }

    public static MeshoptVertexFetchStatistics malloc(MemoryStack stack) {
        return MeshoptVertexFetchStatistics.wrap(MeshoptVertexFetchStatistics.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static MeshoptVertexFetchStatistics calloc(MemoryStack stack) {
        return MeshoptVertexFetchStatistics.wrap(MeshoptVertexFetchStatistics.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return MeshoptVertexFetchStatistics.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return MeshoptVertexFetchStatistics.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nbytes_fetched(long struct) {
        return UNSAFE.getInt(null, struct + (long)BYTES_FETCHED);
    }

    public static float noverfetch(long struct) {
        return UNSAFE.getFloat(null, struct + (long)OVERFETCH);
    }

    static {
        Struct.Layout layout = MeshoptVertexFetchStatistics.__struct(MeshoptVertexFetchStatistics.__member(4), MeshoptVertexFetchStatistics.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BYTES_FETCHED = layout.offsetof(0);
        OVERFETCH = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<MeshoptVertexFetchStatistics, Buffer>
    implements NativeResource {
        private static final MeshoptVertexFetchStatistics ELEMENT_FACTORY = MeshoptVertexFetchStatistics.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected MeshoptVertexFetchStatistics getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int bytes_fetched() {
            return MeshoptVertexFetchStatistics.nbytes_fetched(this.address());
        }

        public float overfetch() {
            return MeshoptVertexFetchStatistics.noverfetch(this.address());
        }
    }
}

