/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.opus;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ogg_packet")
public class OGGPacket
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PACKET;
    public static final int BYTES;
    public static final int B_O_S;
    public static final int E_O_S;
    public static final int GRANULEPOS;
    public static final int PACKETNO;

    public OGGPacket(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), OGGPacket.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned char *")
    public ByteBuffer packet() {
        return OGGPacket.npacket(this.address());
    }

    public long bytes() {
        return OGGPacket.nbytes(this.address());
    }

    public long b_o_s() {
        return OGGPacket.nb_o_s(this.address());
    }

    public long e_o_s() {
        return OGGPacket.ne_o_s(this.address());
    }

    @NativeType(value="ogg_int64_t")
    public long granulepos() {
        return OGGPacket.ngranulepos(this.address());
    }

    @NativeType(value="ogg_int64_t")
    public long packetno() {
        return OGGPacket.npacketno(this.address());
    }

    public static OGGPacket create(long address) {
        return OGGPacket.wrap(OGGPacket.class, address);
    }

    @Nullable
    public static OGGPacket createSafe(long address) {
        return address == 0L ? null : OGGPacket.wrap(OGGPacket.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return OGGPacket.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OGGPacket.wrap(Buffer.class, address, capacity);
    }

    public static ByteBuffer npacket(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)PACKET), (int)OGGPacket.nbytes(struct));
    }

    public static long nbytes(long struct) {
        return MemoryUtil.memGetCLong(struct + (long)BYTES);
    }

    public static long nb_o_s(long struct) {
        return MemoryUtil.memGetCLong(struct + (long)B_O_S);
    }

    public static long ne_o_s(long struct) {
        return MemoryUtil.memGetCLong(struct + (long)E_O_S);
    }

    public static long ngranulepos(long struct) {
        return UNSAFE.getLong(null, struct + (long)GRANULEPOS);
    }

    public static long npacketno(long struct) {
        return UNSAFE.getLong(null, struct + (long)PACKETNO);
    }

    static {
        Struct.Layout layout = OGGPacket.__struct(OGGPacket.__member(POINTER_SIZE), OGGPacket.__member(CLONG_SIZE), OGGPacket.__member(CLONG_SIZE), OGGPacket.__member(CLONG_SIZE), OGGPacket.__member(8), OGGPacket.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PACKET = layout.offsetof(0);
        BYTES = layout.offsetof(1);
        B_O_S = layout.offsetof(2);
        E_O_S = layout.offsetof(3);
        GRANULEPOS = layout.offsetof(4);
        PACKETNO = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<OGGPacket, Buffer> {
        private static final OGGPacket ELEMENT_FACTORY = OGGPacket.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected OGGPacket getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned char *")
        public ByteBuffer packet() {
            return OGGPacket.npacket(this.address());
        }

        public long bytes() {
            return OGGPacket.nbytes(this.address());
        }

        public long b_o_s() {
            return OGGPacket.nb_o_s(this.address());
        }

        public long e_o_s() {
            return OGGPacket.ne_o_s(this.address());
        }

        @NativeType(value="ogg_int64_t")
        public long granulepos() {
            return OGGPacket.ngranulepos(this.address());
        }

        @NativeType(value="ogg_int64_t")
        public long packetno() {
            return OGGPacket.npacketno(this.address());
        }
    }
}

