/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.opus;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.util.opus.OPDecodeCBFuncI;
import org.lwjgl.util.opus.Opus;
import org.lwjgl.util.opus.OpusFileCallbacks;
import org.lwjgl.util.opus.OpusHead;
import org.lwjgl.util.opus.OpusPictureTag;
import org.lwjgl.util.opus.OpusTags;

public class OpusFile {
    public static final int OP_FALSE = -1;
    public static final int OP_EOF = -2;
    public static final int OP_HOLE = -3;
    public static final int OP_EREAD = -128;
    public static final int OP_EFAULT = -129;
    public static final int OP_EIMPL = -130;
    public static final int OP_EINVAL = -131;
    public static final int OP_ENOTFORMAT = -132;
    public static final int OP_EBADHEADER = -133;
    public static final int OP_EVERSION = -134;
    public static final int OP_ENOTAUDIO = -135;
    public static final int OP_EBADPACKET = -136;
    public static final int OP_EBADLINK = -137;
    public static final int OP_ENOSEEK = -138;
    public static final int OP_EBADTIMESTAMP = -139;
    public static final int OPUS_CHANNEL_COUNT_MAX = 255;
    public static final int OP_PIC_FORMAT_UNKNOWN = -1;
    public static final int OP_PIC_FORMAT_URL = 0;
    public static final int OP_PIC_FORMAT_JPEG = 1;
    public static final int OP_PIC_FORMAT_PNG = 2;
    public static final int OP_PIC_FORMAT_GIF = 3;
    public static final int OP_SSL_SKIP_CERTIFICATE_CHECK_REQUEST = 6464;
    public static final int OP_HTTP_PROXY_HOST_REQUEST = 6528;
    public static final int OP_HTTP_PROXY_PORT_REQUEST = 6592;
    public static final int OP_HTTP_PROXY_USER_REQUEST = 6656;
    public static final int OP_HTTP_PROXY_PASS_REQUEST = 6720;
    public static final int OP_GET_SERVER_INFO_REQUEST = 6784;
    public static final int OP_DEC_FORMAT_SHORT = 7008;
    public static final int OP_DEC_FORMAT_FLOAT = 7040;
    public static final int OP_DEC_USE_DEFAULT = 6720;
    public static final int OP_HEADER_GAIN = 0;
    public static final int OP_ALBUM_GAIN = 3007;
    public static final int OP_TRACK_GAIN = 3008;
    public static final int OP_ABSOLUTE_GAIN = 3009;

    protected OpusFile() {
        throw new UnsupportedOperationException();
    }

    public static int nopus_head_parse(long _head, long _data, long _len) {
        long __functionAddress = Functions.head_parse;
        return JNI.invokePPPI(_head, _data, _len, __functionAddress);
    }

    public static int opus_head_parse(@NativeType(value="OpusHead *") OpusHead _head, @NativeType(value="unsigned char const *") ByteBuffer _data) {
        return OpusFile.nopus_head_parse(_head.address(), MemoryUtil.memAddress(_data), _data.remaining());
    }

    public static long nopus_granule_sample(long _head, long _gp) {
        long __functionAddress = Functions.granule_sample;
        return JNI.invokePJJ(_head, _gp, __functionAddress);
    }

    @NativeType(value="ogg_int64_t")
    public static long opus_granule_sample(@NativeType(value="OpusHead const *") OpusHead _head, @NativeType(value="ogg_int64_t") long _gp) {
        return OpusFile.nopus_granule_sample(_head.address(), _gp);
    }

    public static int nopus_tags_parse(long _tags, long _data, long _len) {
        long __functionAddress = Functions.tags_parse;
        return JNI.invokePPPI(_tags, _data, _len, __functionAddress);
    }

    public static int opus_tags_parse(@Nullable @NativeType(value="OpusTags *") OpusTags _tags, @NativeType(value="unsigned char const *") ByteBuffer _data) {
        return OpusFile.nopus_tags_parse(MemoryUtil.memAddressSafe(_tags), MemoryUtil.memAddress(_data), _data.remaining());
    }

    public static int nopus_tags_copy(long _dst, long _src) {
        long __functionAddress = Functions.tags_copy;
        return JNI.invokePPI(_dst, _src, __functionAddress);
    }

    public static int opus_tags_copy(@NativeType(value="OpusTags *") OpusTags _dst, @NativeType(value="OpusTags const *") OpusTags _src) {
        return OpusFile.nopus_tags_copy(_dst.address(), _src.address());
    }

    public static void nopus_tags_init(long _tags) {
        long __functionAddress = Functions.tags_init;
        JNI.invokePV(_tags, __functionAddress);
    }

    public static void opus_tags_init(@NativeType(value="OpusTags *") OpusTags _tags) {
        OpusFile.nopus_tags_init(_tags.address());
    }

    public static int nopus_tags_add(long _tags, long _tag, long _value) {
        long __functionAddress = Functions.tags_add;
        return JNI.invokePPPI(_tags, _tag, _value, __functionAddress);
    }

    public static int opus_tags_add(@NativeType(value="OpusTags *") OpusTags _tags, @NativeType(value="char const *") ByteBuffer _tag, @NativeType(value="char const *") ByteBuffer _value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_tag);
            Checks.checkNT1(_value);
        }
        return OpusFile.nopus_tags_add(_tags.address(), MemoryUtil.memAddress(_tag), MemoryUtil.memAddress(_value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int opus_tags_add(@NativeType(value="OpusTags *") OpusTags _tags, @NativeType(value="char const *") CharSequence _tag, @NativeType(value="char const *") CharSequence _value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(_tag, true);
            long _tagEncoded = stack.getPointerAddress();
            stack.nUTF8(_value, true);
            long _valueEncoded = stack.getPointerAddress();
            int n = OpusFile.nopus_tags_add(_tags.address(), _tagEncoded, _valueEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nopus_tags_add_comment(long _tags, long _comment) {
        long __functionAddress = Functions.tags_add_comment;
        return JNI.invokePPI(_tags, _comment, __functionAddress);
    }

    public static int opus_tags_add_comment(@NativeType(value="OpusTags *") OpusTags _tags, @NativeType(value="char const *") ByteBuffer _comment) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_comment);
        }
        return OpusFile.nopus_tags_add_comment(_tags.address(), MemoryUtil.memAddress(_comment));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int opus_tags_add_comment(@NativeType(value="OpusTags *") OpusTags _tags, @NativeType(value="char const *") CharSequence _comment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(_comment, true);
            long _commentEncoded = stack.getPointerAddress();
            int n = OpusFile.nopus_tags_add_comment(_tags.address(), _commentEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nopus_tags_set_binary_suffix(long _tags, long _data, int _len) {
        long __functionAddress = Functions.tags_set_binary_suffix;
        return JNI.invokePPI(_tags, _data, _len, __functionAddress);
    }

    public static int opus_tags_set_binary_suffix(@NativeType(value="OpusTags *") OpusTags _tags, @Nullable @NativeType(value="unsigned char const *") ByteBuffer _data) {
        return OpusFile.nopus_tags_set_binary_suffix(_tags.address(), MemoryUtil.memAddressSafe(_data), Checks.remainingSafe(_data));
    }

    public static long nopus_tags_query(long _tags, long _tag, int _count) {
        long __functionAddress = Functions.tags_query;
        return JNI.invokePPP(_tags, _tag, _count, __functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String opus_tags_query(@NativeType(value="OpusTags const *") OpusTags _tags, @NativeType(value="char const *") ByteBuffer _tag, int _count) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_tag);
        }
        long __result = OpusFile.nopus_tags_query(_tags.address(), MemoryUtil.memAddress(_tag), _count);
        return MemoryUtil.memUTF8Safe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const *")
    public static String opus_tags_query(@NativeType(value="OpusTags const *") OpusTags _tags, @NativeType(value="char const *") CharSequence _tag, int _count) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(_tag, true);
            long _tagEncoded = stack.getPointerAddress();
            long __result = OpusFile.nopus_tags_query(_tags.address(), _tagEncoded, _count);
            String string = MemoryUtil.memUTF8Safe(__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nopus_tags_query_count(long _tags, long _tag) {
        long __functionAddress = Functions.tags_query_count;
        return JNI.invokePPI(_tags, _tag, __functionAddress);
    }

    public static int opus_tags_query_count(@NativeType(value="OpusTags const *") OpusTags _tags, @NativeType(value="char const *") ByteBuffer _tag) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_tag);
        }
        return OpusFile.nopus_tags_query_count(_tags.address(), MemoryUtil.memAddress(_tag));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int opus_tags_query_count(@NativeType(value="OpusTags const *") OpusTags _tags, @NativeType(value="char const *") CharSequence _tag) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(_tag, true);
            long _tagEncoded = stack.getPointerAddress();
            int n = OpusFile.nopus_tags_query_count(_tags.address(), _tagEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nopus_tags_get_binary_suffix(long _tags, long _len) {
        long __functionAddress = Functions.tags_get_binary_suffix;
        return JNI.invokePPP(_tags, _len, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="unsigned char const *")
    public static ByteBuffer opus_tags_get_binary_suffix(@NativeType(value="OpusTags const *") OpusTags _tags) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer _len = stack.callocInt(1);
        try {
            long __result = OpusFile.nopus_tags_get_binary_suffix(_tags.address(), MemoryUtil.memAddress(_len));
            ByteBuffer byteBuffer = MemoryUtil.memByteBufferSafe(__result, _len.get(0));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nopus_tags_get_album_gain(long _tags, long _gain_q8) {
        long __functionAddress = Functions.tags_get_album_gain;
        return JNI.invokePPI(_tags, _gain_q8, __functionAddress);
    }

    public static int opus_tags_get_album_gain(@NativeType(value="OpusTags const *") OpusTags _tags, @NativeType(value="int *") IntBuffer _gain_q8) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)_gain_q8, 1);
        }
        return OpusFile.nopus_tags_get_album_gain(_tags.address(), MemoryUtil.memAddress(_gain_q8));
    }

    public static int nopus_tags_get_track_gain(long _tags, long _gain_q8) {
        long __functionAddress = Functions.tags_get_track_gain;
        return JNI.invokePPI(_tags, _gain_q8, __functionAddress);
    }

    public static int opus_tags_get_track_gain(@NativeType(value="OpusTags const *") OpusTags _tags, @NativeType(value="int *") IntBuffer _gain_q8) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)_gain_q8, 1);
        }
        return OpusFile.nopus_tags_get_track_gain(_tags.address(), MemoryUtil.memAddress(_gain_q8));
    }

    public static void nopus_tags_clear(long _tags) {
        long __functionAddress = Functions.tags_clear;
        JNI.invokePV(_tags, __functionAddress);
    }

    public static void opus_tags_clear(@NativeType(value="OpusTags *") OpusTags _tags) {
        OpusFile.nopus_tags_clear(_tags.address());
    }

    public static int nopus_tagcompare(long _tag_name, long _comment) {
        long __functionAddress = Functions.tagcompare;
        return JNI.invokePPI(_tag_name, _comment, __functionAddress);
    }

    public static int opus_tagcompare(@NativeType(value="char const *") ByteBuffer _tag_name, @NativeType(value="char const *") ByteBuffer _comment) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_tag_name);
            Checks.checkNT1(_comment);
        }
        return OpusFile.nopus_tagcompare(MemoryUtil.memAddress(_tag_name), MemoryUtil.memAddress(_comment));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int opus_tagcompare(@NativeType(value="char const *") CharSequence _tag_name, @NativeType(value="char const *") CharSequence _comment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(_tag_name, true);
            long _tag_nameEncoded = stack.getPointerAddress();
            stack.nUTF8(_comment, true);
            long _commentEncoded = stack.getPointerAddress();
            int n = OpusFile.nopus_tagcompare(_tag_nameEncoded, _commentEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nopus_tagncompare(long _tag_name, int _tag_len, long _comment) {
        long __functionAddress = Functions.tagncompare;
        return JNI.invokePPI(_tag_name, _tag_len, _comment, __functionAddress);
    }

    public static int opus_tagncompare(@NativeType(value="char const *") ByteBuffer _tag_name, @NativeType(value="char const *") ByteBuffer _comment) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_comment);
        }
        return OpusFile.nopus_tagncompare(MemoryUtil.memAddress(_tag_name), _tag_name.remaining(), MemoryUtil.memAddress(_comment));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int opus_tagncompare(@NativeType(value="char const *") CharSequence _tag_name, @NativeType(value="char const *") CharSequence _comment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int _tag_nameEncodedLength = stack.nASCII(_tag_name, false);
            long _tag_nameEncoded = stack.getPointerAddress();
            stack.nUTF8(_comment, true);
            long _commentEncoded = stack.getPointerAddress();
            int n = OpusFile.nopus_tagncompare(_tag_nameEncoded, _tag_nameEncodedLength, _commentEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nopus_picture_tag_parse(long _pic, long _tag) {
        long __functionAddress = Functions.picture_tag_parse;
        return JNI.invokePPI(_pic, _tag, __functionAddress);
    }

    public static int opus_picture_tag_parse(@NativeType(value="OpusPictureTag *") OpusPictureTag _pic, @NativeType(value="char const *") ByteBuffer _tag) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_tag);
        }
        return OpusFile.nopus_picture_tag_parse(_pic.address(), MemoryUtil.memAddress(_tag));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int opus_picture_tag_parse(@NativeType(value="OpusPictureTag *") OpusPictureTag _pic, @NativeType(value="char const *") CharSequence _tag) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(_tag, true);
            long _tagEncoded = stack.getPointerAddress();
            int n = OpusFile.nopus_picture_tag_parse(_pic.address(), _tagEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nopus_picture_tag_init(long _pic) {
        long __functionAddress = Functions.picture_tag_init;
        JNI.invokePV(_pic, __functionAddress);
    }

    public static void opus_picture_tag_init(@NativeType(value="OpusPictureTag *") OpusPictureTag _pic) {
        OpusFile.nopus_picture_tag_init(_pic.address());
    }

    public static void nopus_picture_tag_clear(long _pic) {
        long __functionAddress = Functions.picture_tag_clear;
        JNI.invokePV(_pic, __functionAddress);
    }

    public static void opus_picture_tag_clear(@NativeType(value="OpusPictureTag *") OpusPictureTag _pic) {
        OpusFile.nopus_picture_tag_clear(_pic.address());
    }

    public static long nop_fopen(long _cb, long _path, long _mode) {
        long __functionAddress = Functions.op_fopen;
        return JNI.invokePPPP(_cb, _path, _mode, __functionAddress);
    }

    @NativeType(value="void *")
    public static long op_fopen(@NativeType(value="OpusFileCallbacks *") OpusFileCallbacks _cb, @NativeType(value="char const *") ByteBuffer _path, @NativeType(value="char const *") ByteBuffer _mode) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_path);
            Checks.checkNT1(_mode);
        }
        return OpusFile.nop_fopen(_cb.address(), MemoryUtil.memAddress(_path), MemoryUtil.memAddress(_mode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void *")
    public static long op_fopen(@NativeType(value="OpusFileCallbacks *") OpusFileCallbacks _cb, @NativeType(value="char const *") CharSequence _path, @NativeType(value="char const *") CharSequence _mode) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(_path, true);
            long _pathEncoded = stack.getPointerAddress();
            stack.nASCII(_mode, true);
            long _modeEncoded = stack.getPointerAddress();
            long l = OpusFile.nop_fopen(_cb.address(), _pathEncoded, _modeEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nop_fdopen(long _cb, int _fd, long _mode) {
        long __functionAddress = Functions.op_fdopen;
        return JNI.invokePPP(_cb, _fd, _mode, __functionAddress);
    }

    @NativeType(value="void *")
    public static long op_fdopen(@NativeType(value="OpusFileCallbacks *") OpusFileCallbacks _cb, int _fd, @NativeType(value="char const *") ByteBuffer _mode) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_mode);
        }
        return OpusFile.nop_fdopen(_cb.address(), _fd, MemoryUtil.memAddress(_mode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void *")
    public static long op_fdopen(@NativeType(value="OpusFileCallbacks *") OpusFileCallbacks _cb, int _fd, @NativeType(value="char const *") CharSequence _mode) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(_mode, true);
            long _modeEncoded = stack.getPointerAddress();
            long l = OpusFile.nop_fdopen(_cb.address(), _fd, _modeEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nop_freopen(long _cb, long _path, long _mode, long _stream) {
        long __functionAddress = Functions.op_freopen;
        if (Checks.CHECKS) {
            Checks.check(_stream);
        }
        return JNI.invokePPPPP(_cb, _path, _mode, _stream, __functionAddress);
    }

    @NativeType(value="void *")
    public static long op_freopen(@NativeType(value="OpusFileCallbacks *") OpusFileCallbacks _cb, @NativeType(value="char const *") ByteBuffer _path, @NativeType(value="char const *") ByteBuffer _mode, @NativeType(value="void *") long _stream) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_path);
            Checks.checkNT1(_mode);
        }
        return OpusFile.nop_freopen(_cb.address(), MemoryUtil.memAddress(_path), MemoryUtil.memAddress(_mode), _stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void *")
    public static long op_freopen(@NativeType(value="OpusFileCallbacks *") OpusFileCallbacks _cb, @NativeType(value="char const *") CharSequence _path, @NativeType(value="char const *") CharSequence _mode, @NativeType(value="void *") long _stream) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(_path, true);
            long _pathEncoded = stack.getPointerAddress();
            stack.nASCII(_mode, true);
            long _modeEncoded = stack.getPointerAddress();
            long l = OpusFile.nop_freopen(_cb.address(), _pathEncoded, _modeEncoded, _stream);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nop_mem_stream_create(long _cb, long _data, long _size) {
        long __functionAddress = Functions.op_mem_stream_create;
        return JNI.invokePPPP(_cb, _data, _size, __functionAddress);
    }

    @NativeType(value="void *")
    public static long op_mem_stream_create(@NativeType(value="OpusFileCallbacks *") OpusFileCallbacks _cb, @NativeType(value="unsigned char const *") ByteBuffer _data) {
        return OpusFile.nop_mem_stream_create(_cb.address(), MemoryUtil.memAddress(_data), _data.remaining());
    }

    public static int nop_test(long _head, long _initial_data, long _initial_bytes) {
        long __functionAddress = Functions.op_test;
        return JNI.invokePPPI(_head, _initial_data, _initial_bytes, __functionAddress);
    }

    public static int op_test(@Nullable @NativeType(value="OpusHead *") OpusHead _head, @NativeType(value="unsigned char const *") ByteBuffer _initial_data) {
        return OpusFile.nop_test(MemoryUtil.memAddressSafe(_head), MemoryUtil.memAddress(_initial_data), _initial_data.remaining());
    }

    public static long nop_open_file(long _path, long _error) {
        long __functionAddress = Functions.op_open_file;
        return JNI.invokePPP(_path, _error, __functionAddress);
    }

    @NativeType(value="OggOpusFile *")
    public static long op_open_file(@NativeType(value="char const *") ByteBuffer _path, @Nullable @NativeType(value="int *") IntBuffer _error) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_path);
            Checks.checkSafe((Buffer)_error, 1);
        }
        return OpusFile.nop_open_file(MemoryUtil.memAddress(_path), MemoryUtil.memAddressSafe(_error));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="OggOpusFile *")
    public static long op_open_file(@NativeType(value="char const *") CharSequence _path, @Nullable @NativeType(value="int *") IntBuffer _error) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)_error, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(_path, true);
            long _pathEncoded = stack.getPointerAddress();
            long l = OpusFile.nop_open_file(_pathEncoded, MemoryUtil.memAddressSafe(_error));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nop_open_memory(long _data, long _size, long _error) {
        long __functionAddress = Functions.op_open_memory;
        return JNI.invokePPPP(_data, _size, _error, __functionAddress);
    }

    @NativeType(value="OggOpusFile *")
    public static long op_open_memory(@NativeType(value="unsigned char const *") ByteBuffer _data, @Nullable @NativeType(value="int *") IntBuffer _error) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)_error, 1);
        }
        return OpusFile.nop_open_memory(MemoryUtil.memAddress(_data), _data.remaining(), MemoryUtil.memAddressSafe(_error));
    }

    public static long nop_open_callbacks(long _stream, long _cb, long _initial_data, long _initial_bytes, long _error) {
        long __functionAddress = Functions.op_open_callbacks;
        if (Checks.CHECKS) {
            Checks.check(_stream);
            OpusFileCallbacks.validate(_cb);
        }
        return JNI.invokePPPPPP(_stream, _cb, _initial_data, _initial_bytes, _error, __functionAddress);
    }

    @NativeType(value="OggOpusFile *")
    public static long op_open_callbacks(@NativeType(value="void *") long _stream, @NativeType(value="OpusFileCallbacks const *") OpusFileCallbacks _cb, @NativeType(value="unsigned char const *") ByteBuffer _initial_data, @Nullable @NativeType(value="int *") IntBuffer _error) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)_error, 1);
        }
        return OpusFile.nop_open_callbacks(_stream, _cb.address(), MemoryUtil.memAddress(_initial_data), _initial_data.remaining(), MemoryUtil.memAddressSafe(_error));
    }

    public static long nop_test_file(long _path, long _error) {
        long __functionAddress = Functions.op_test_file;
        return JNI.invokePPP(_path, _error, __functionAddress);
    }

    @NativeType(value="OggOpusFile *")
    public static long op_test_file(@NativeType(value="char const *") ByteBuffer _path, @Nullable @NativeType(value="int *") IntBuffer _error) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_path);
            Checks.checkSafe((Buffer)_error, 1);
        }
        return OpusFile.nop_test_file(MemoryUtil.memAddress(_path), MemoryUtil.memAddressSafe(_error));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="OggOpusFile *")
    public static long op_test_file(@NativeType(value="char const *") CharSequence _path, @Nullable @NativeType(value="int *") IntBuffer _error) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)_error, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(_path, true);
            long _pathEncoded = stack.getPointerAddress();
            long l = OpusFile.nop_test_file(_pathEncoded, MemoryUtil.memAddressSafe(_error));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nop_test_memory(long _data, long _size, long _error) {
        long __functionAddress = Functions.op_test_memory;
        return JNI.invokePPPP(_data, _size, _error, __functionAddress);
    }

    @NativeType(value="OggOpusFile *")
    public static long op_test_memory(@NativeType(value="unsigned char const *") ByteBuffer _data, @Nullable @NativeType(value="int *") IntBuffer _error) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)_error, 1);
        }
        return OpusFile.nop_test_memory(MemoryUtil.memAddress(_data), _data.remaining(), MemoryUtil.memAddressSafe(_error));
    }

    public static long nop_test_callbacks(long _stream, long _cb, long _initial_data, long _initial_bytes, long _error) {
        long __functionAddress = Functions.op_test_callbacks;
        if (Checks.CHECKS) {
            Checks.check(_stream);
            OpusFileCallbacks.validate(_cb);
        }
        return JNI.invokePPPPPP(_stream, _cb, _initial_data, _initial_bytes, _error, __functionAddress);
    }

    @NativeType(value="OggOpusFile *")
    public static long op_test_callbacks(@NativeType(value="void *") long _stream, @NativeType(value="OpusFileCallbacks const *") OpusFileCallbacks _cb, @NativeType(value="unsigned char const *") ByteBuffer _initial_data, @Nullable @NativeType(value="int *") IntBuffer _error) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)_error, 1);
        }
        return OpusFile.nop_test_callbacks(_stream, _cb.address(), MemoryUtil.memAddress(_initial_data), _initial_data.remaining(), MemoryUtil.memAddressSafe(_error));
    }

    public static int op_test_open(@NativeType(value="OggOpusFile *") long _of) {
        long __functionAddress = Functions.op_test_open;
        if (Checks.CHECKS) {
            Checks.check(_of);
        }
        return JNI.invokePI(_of, __functionAddress);
    }

    public static void op_free(@NativeType(value="OggOpusFile *") long _of) {
        long __functionAddress = Functions.op_free;
        if (Checks.CHECKS) {
            Checks.check(_of);
        }
        JNI.invokePV(_of, __functionAddress);
    }

    @NativeType(value="int")
    public static boolean op_seekable(@NativeType(value="OggOpusFile const *") long _of) {
        long __functionAddress = Functions.op_seekable;
        if (Checks.CHECKS) {
            Checks.check(_of);
        }
        return JNI.invokePI(_of, __functionAddress) != 0;
    }

    public static int op_link_count(@NativeType(value="OggOpusFile const *") long _of) {
        long __functionAddress = Functions.op_link_count;
        if (Checks.CHECKS) {
            Checks.check(_of);
        }
        return JNI.invokePI(_of, __functionAddress);
    }

    @NativeType(value="opus_uint32")
    public static int op_serialno(@NativeType(value="OggOpusFile const *") long _of, int _li) {
        long __functionAddress = Functions.op_serialno;
        if (Checks.CHECKS) {
            Checks.check(_of);
        }
        return JNI.invokePI(_of, _li, __functionAddress);
    }

    public static int op_channel_count(@NativeType(value="OggOpusFile const *") long _of, int _li) {
        long __functionAddress = Functions.op_channel_count;
        if (Checks.CHECKS) {
            Checks.check(_of);
        }
        return JNI.invokePI(_of, _li, __functionAddress);
    }

    @NativeType(value="long long")
    public static long op_raw_total(@NativeType(value="OggOpusFile const *") long _of, int _li) {
        long __functionAddress = Functions.op_raw_total;
        if (Checks.CHECKS) {
            Checks.check(_of);
        }
        return JNI.invokePJ(_of, _li, __functionAddress);
    }

    @NativeType(value="ogg_int64_t")
    public static long op_pcm_total(@NativeType(value="OggOpusFile const *") long _of, int _li) {
        long __functionAddress = Functions.op_pcm_total;
        if (Checks.CHECKS) {
            Checks.check(_of);
        }
        return JNI.invokePJ(_of, _li, __functionAddress);
    }

    public static long nop_head(long _of, int _li) {
        long __functionAddress = Functions.op_head;
        if (Checks.CHECKS) {
            Checks.check(_of);
        }
        return JNI.invokePP(_of, _li, __functionAddress);
    }

    @Nullable
    @NativeType(value="OpusHead const *")
    public static OpusHead op_head(@NativeType(value="OggOpusFile const *") long _of, int _li) {
        long __result = OpusFile.nop_head(_of, _li);
        return OpusHead.createSafe(__result);
    }

    public static long nop_tags(long _of, int _li) {
        long __functionAddress = Functions.op_tags;
        if (Checks.CHECKS) {
            Checks.check(_of);
        }
        return JNI.invokePP(_of, _li, __functionAddress);
    }

    @Nullable
    @NativeType(value="OpusTags const *")
    public static OpusTags op_tags(@NativeType(value="OggOpusFile const *") long _of, int _li) {
        long __result = OpusFile.nop_tags(_of, _li);
        return OpusTags.createSafe(__result);
    }

    public static int op_current_link(@NativeType(value="OggOpusFile const *") long _of) {
        long __functionAddress = Functions.op_current_link;
        if (Checks.CHECKS) {
            Checks.check(_of);
        }
        return JNI.invokePI(_of, __functionAddress);
    }

    @NativeType(value="opus_int32")
    public static int op_bitrate(@NativeType(value="OggOpusFile const *") long _of, int _li) {
        long __functionAddress = Functions.op_bitrate;
        if (Checks.CHECKS) {
            Checks.check(_of);
        }
        return JNI.invokePI(_of, _li, __functionAddress);
    }

    @NativeType(value="opus_int32")
    public static int op_bitrate_instant(@NativeType(value="OggOpusFile *") long _of) {
        long __functionAddress = Functions.op_bitrate_instant;
        if (Checks.CHECKS) {
            Checks.check(_of);
        }
        return JNI.invokePI(_of, __functionAddress);
    }

    @NativeType(value="long long")
    public static long op_raw_tell(@NativeType(value="OggOpusFile const *") long _of) {
        long __functionAddress = Functions.op_raw_tell;
        if (Checks.CHECKS) {
            Checks.check(_of);
        }
        return JNI.invokePJ(_of, __functionAddress);
    }

    @NativeType(value="ogg_int64_t")
    public static long op_pcm_tell(@NativeType(value="OggOpusFile const *") long _of) {
        long __functionAddress = Functions.op_pcm_tell;
        if (Checks.CHECKS) {
            Checks.check(_of);
        }
        return JNI.invokePJ(_of, __functionAddress);
    }

    public static int op_raw_seek(@NativeType(value="OggOpusFile *") long _of, @NativeType(value="long long") long _byte_offset) {
        long __functionAddress = Functions.op_raw_seek;
        if (Checks.CHECKS) {
            Checks.check(_of);
        }
        return JNI.invokePJI(_of, _byte_offset, __functionAddress);
    }

    public static int op_pcm_seek(@NativeType(value="OggOpusFile *") long _of, @NativeType(value="ogg_int64_t") long _pcm_offset) {
        long __functionAddress = Functions.op_pcm_seek;
        if (Checks.CHECKS) {
            Checks.check(_of);
        }
        return JNI.invokePJI(_of, _pcm_offset, __functionAddress);
    }

    public static void nop_set_decode_callback(long _of, long _decode_cb, long _ctx) {
        long __functionAddress = Functions.op_set_decode_callback;
        if (Checks.CHECKS) {
            Checks.check(_of);
            Checks.check(_ctx);
        }
        JNI.invokePPPV(_of, _decode_cb, _ctx, __functionAddress);
    }

    public static void op_set_decode_callback(@NativeType(value="OggOpusFile *") long _of, @NativeType(value="op_decode_cb_func") OPDecodeCBFuncI _decode_cb, @NativeType(value="void *") long _ctx) {
        OpusFile.nop_set_decode_callback(_of, _decode_cb.address(), _ctx);
    }

    public static int op_set_gain_offset(@NativeType(value="OggOpusFile *") long _of, int _gain_type, @NativeType(value="opus_int32") int _gain_offset_q8) {
        long __functionAddress = Functions.op_set_gain_offset;
        if (Checks.CHECKS) {
            Checks.check(_of);
        }
        return JNI.invokePI(_of, _gain_type, _gain_offset_q8, __functionAddress);
    }

    public static void op_set_dither_enabled(@NativeType(value="OggOpusFile *") long _of, @NativeType(value="int") boolean _enabled) {
        long __functionAddress = Functions.op_set_dither_enabled;
        if (Checks.CHECKS) {
            Checks.check(_of);
        }
        JNI.invokePV(_of, _enabled ? 1 : 0, __functionAddress);
    }

    public static int nop_read(long _of, long _pcm, int _buf_size, long _li) {
        long __functionAddress = Functions.op_read;
        if (Checks.CHECKS) {
            Checks.check(_of);
        }
        return JNI.invokePPPI(_of, _pcm, _buf_size, _li, __functionAddress);
    }

    public static int op_read(@NativeType(value="OggOpusFile *") long _of, @NativeType(value="opus_int16 *") ShortBuffer _pcm, @Nullable @NativeType(value="int *") IntBuffer _li) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)_li, 1);
        }
        return OpusFile.nop_read(_of, MemoryUtil.memAddress(_pcm), _pcm.remaining(), MemoryUtil.memAddressSafe(_li));
    }

    public static int nop_read_float(long _of, long _pcm, int _buf_size, long _li) {
        long __functionAddress = Functions.op_read_float;
        if (Checks.CHECKS) {
            Checks.check(_of);
        }
        return JNI.invokePPPI(_of, _pcm, _buf_size, _li, __functionAddress);
    }

    public static int op_read_float(@NativeType(value="OggOpusFile *") long _of, @NativeType(value="float *") FloatBuffer _pcm, @Nullable @NativeType(value="int *") IntBuffer _li) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)_li, 1);
        }
        return OpusFile.nop_read_float(_of, MemoryUtil.memAddress(_pcm), _pcm.remaining(), MemoryUtil.memAddressSafe(_li));
    }

    public static int nop_read_stereo(long _of, long _pcm, int _buf_size) {
        long __functionAddress = Functions.op_read_stereo;
        if (Checks.CHECKS) {
            Checks.check(_of);
        }
        return JNI.invokePPI(_of, _pcm, _buf_size, __functionAddress);
    }

    public static int op_read_stereo(@NativeType(value="OggOpusFile *") long _of, @NativeType(value="opus_int16 *") ShortBuffer _pcm) {
        return OpusFile.nop_read_stereo(_of, MemoryUtil.memAddress(_pcm), _pcm.remaining());
    }

    public static int nop_read_float_stereo(long _of, long _pcm, int _buf_size) {
        long __functionAddress = Functions.op_read_float_stereo;
        if (Checks.CHECKS) {
            Checks.check(_of);
        }
        return JNI.invokePPI(_of, _pcm, _buf_size, __functionAddress);
    }

    public static int op_read_float_stereo(@NativeType(value="OggOpusFile *") long _of, @NativeType(value="float *") FloatBuffer _pcm) {
        return OpusFile.nop_read_float_stereo(_of, MemoryUtil.memAddress(_pcm), _pcm.remaining());
    }

    public static final class Functions {
        public static final long head_parse = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_head_parse");
        public static final long granule_sample = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_granule_sample");
        public static final long tags_parse = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_tags_parse");
        public static final long tags_copy = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_tags_copy");
        public static final long tags_init = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_tags_init");
        public static final long tags_add = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_tags_add");
        public static final long tags_add_comment = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_tags_add_comment");
        public static final long tags_set_binary_suffix = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_tags_set_binary_suffix");
        public static final long tags_query = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_tags_query");
        public static final long tags_query_count = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_tags_query_count");
        public static final long tags_get_binary_suffix = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_tags_get_binary_suffix");
        public static final long tags_get_album_gain = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_tags_get_album_gain");
        public static final long tags_get_track_gain = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_tags_get_track_gain");
        public static final long tags_clear = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_tags_clear");
        public static final long tagcompare = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_tagcompare");
        public static final long tagncompare = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_tagncompare");
        public static final long picture_tag_parse = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_picture_tag_parse");
        public static final long picture_tag_init = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_picture_tag_init");
        public static final long picture_tag_clear = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_picture_tag_clear");
        public static final long op_fopen = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_fopen");
        public static final long op_fdopen = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_fdopen");
        public static final long op_freopen = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_freopen");
        public static final long op_mem_stream_create = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_mem_stream_create");
        public static final long op_test = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_test");
        public static final long op_open_file = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_open_file");
        public static final long op_open_memory = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_open_memory");
        public static final long op_open_callbacks = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_open_callbacks");
        public static final long op_test_file = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_test_file");
        public static final long op_test_memory = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_test_memory");
        public static final long op_test_callbacks = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_test_callbacks");
        public static final long op_test_open = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_test_open");
        public static final long op_free = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_free");
        public static final long op_seekable = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_seekable");
        public static final long op_link_count = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_link_count");
        public static final long op_serialno = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_serialno");
        public static final long op_channel_count = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_channel_count");
        public static final long op_raw_total = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_raw_total");
        public static final long op_pcm_total = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_pcm_total");
        public static final long op_head = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_head");
        public static final long op_tags = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_tags");
        public static final long op_current_link = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_current_link");
        public static final long op_bitrate = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_bitrate");
        public static final long op_bitrate_instant = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_bitrate_instant");
        public static final long op_raw_tell = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_raw_tell");
        public static final long op_pcm_tell = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_pcm_tell");
        public static final long op_raw_seek = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_raw_seek");
        public static final long op_pcm_seek = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_pcm_seek");
        public static final long op_set_decode_callback = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_set_decode_callback");
        public static final long op_set_gain_offset = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_set_gain_offset");
        public static final long op_set_dither_enabled = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_set_dither_enabled");
        public static final long op_read = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_read");
        public static final long op_read_float = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_read_float");
        public static final long op_read_stereo = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_read_stereo");
        public static final long op_read_float_stereo = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "op_read_float_stereo");

        private Functions() {
        }
    }
}

