/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.spvc.SpvcReflectedResource;

@NativeType(value="struct spvc_reflected_builtin_resource")
public class SpvcReflectedBuiltinResource
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUILTIN;
    public static final int VALUE_TYPE_ID;
    public static final int RESOURCE;

    public SpvcReflectedBuiltinResource(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SpvcReflectedBuiltinResource.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SpvBuiltIn")
    public int builtin() {
        return SpvcReflectedBuiltinResource.nbuiltin(this.address());
    }

    @NativeType(value="spvc_type_id")
    public int value_type_id() {
        return SpvcReflectedBuiltinResource.nvalue_type_id(this.address());
    }

    @NativeType(value="spvc_reflected_resource")
    public SpvcReflectedResource resource() {
        return SpvcReflectedBuiltinResource.nresource(this.address());
    }

    public SpvcReflectedBuiltinResource builtin(@NativeType(value="SpvBuiltIn") int value) {
        SpvcReflectedBuiltinResource.nbuiltin(this.address(), value);
        return this;
    }

    public SpvcReflectedBuiltinResource value_type_id(@NativeType(value="spvc_type_id") int value) {
        SpvcReflectedBuiltinResource.nvalue_type_id(this.address(), value);
        return this;
    }

    public SpvcReflectedBuiltinResource resource(@NativeType(value="spvc_reflected_resource") SpvcReflectedResource value) {
        SpvcReflectedBuiltinResource.nresource(this.address(), value);
        return this;
    }

    public SpvcReflectedBuiltinResource resource(Consumer<SpvcReflectedResource> consumer) {
        consumer.accept(this.resource());
        return this;
    }

    public SpvcReflectedBuiltinResource set(int builtin, int value_type_id, SpvcReflectedResource resource) {
        this.builtin(builtin);
        this.value_type_id(value_type_id);
        this.resource(resource);
        return this;
    }

    public SpvcReflectedBuiltinResource set(SpvcReflectedBuiltinResource src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SpvcReflectedBuiltinResource malloc() {
        return SpvcReflectedBuiltinResource.wrap(SpvcReflectedBuiltinResource.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static SpvcReflectedBuiltinResource calloc() {
        return SpvcReflectedBuiltinResource.wrap(SpvcReflectedBuiltinResource.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static SpvcReflectedBuiltinResource create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return SpvcReflectedBuiltinResource.wrap(SpvcReflectedBuiltinResource.class, MemoryUtil.memAddress(container), container);
    }

    public static SpvcReflectedBuiltinResource create(long address) {
        return SpvcReflectedBuiltinResource.wrap(SpvcReflectedBuiltinResource.class, address);
    }

    @Nullable
    public static SpvcReflectedBuiltinResource createSafe(long address) {
        return address == 0L ? null : SpvcReflectedBuiltinResource.wrap(SpvcReflectedBuiltinResource.class, address);
    }

    public static Buffer malloc(int capacity) {
        return SpvcReflectedBuiltinResource.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(SpvcReflectedBuiltinResource.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return SpvcReflectedBuiltinResource.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcReflectedBuiltinResource.__create(capacity, SIZEOF);
        return SpvcReflectedBuiltinResource.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return SpvcReflectedBuiltinResource.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : SpvcReflectedBuiltinResource.wrap(Buffer.class, address, capacity);
    }

    public static SpvcReflectedBuiltinResource malloc(MemoryStack stack) {
        return SpvcReflectedBuiltinResource.wrap(SpvcReflectedBuiltinResource.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static SpvcReflectedBuiltinResource calloc(MemoryStack stack) {
        return SpvcReflectedBuiltinResource.wrap(SpvcReflectedBuiltinResource.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return SpvcReflectedBuiltinResource.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return SpvcReflectedBuiltinResource.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nbuiltin(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUILTIN);
    }

    public static int nvalue_type_id(long struct) {
        return UNSAFE.getInt(null, struct + (long)VALUE_TYPE_ID);
    }

    public static SpvcReflectedResource nresource(long struct) {
        return SpvcReflectedResource.create(struct + (long)RESOURCE);
    }

    public static void nbuiltin(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BUILTIN, value);
    }

    public static void nvalue_type_id(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VALUE_TYPE_ID, value);
    }

    public static void nresource(long struct, SpvcReflectedResource value) {
        MemoryUtil.memCopy(value.address(), struct + (long)RESOURCE, SpvcReflectedResource.SIZEOF);
    }

    public static void validate(long struct) {
        SpvcReflectedResource.validate(struct + (long)RESOURCE);
    }

    static {
        Struct.Layout layout = SpvcReflectedBuiltinResource.__struct(SpvcReflectedBuiltinResource.__member(4), SpvcReflectedBuiltinResource.__member(4), SpvcReflectedBuiltinResource.__member(SpvcReflectedResource.SIZEOF, SpvcReflectedResource.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUILTIN = layout.offsetof(0);
        VALUE_TYPE_ID = layout.offsetof(1);
        RESOURCE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<SpvcReflectedBuiltinResource, Buffer>
    implements NativeResource {
        private static final SpvcReflectedBuiltinResource ELEMENT_FACTORY = SpvcReflectedBuiltinResource.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected SpvcReflectedBuiltinResource getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SpvBuiltIn")
        public int builtin() {
            return SpvcReflectedBuiltinResource.nbuiltin(this.address());
        }

        @NativeType(value="spvc_type_id")
        public int value_type_id() {
            return SpvcReflectedBuiltinResource.nvalue_type_id(this.address());
        }

        @NativeType(value="spvc_reflected_resource")
        public SpvcReflectedResource resource() {
            return SpvcReflectedBuiltinResource.nresource(this.address());
        }

        public Buffer builtin(@NativeType(value="SpvBuiltIn") int value) {
            SpvcReflectedBuiltinResource.nbuiltin(this.address(), value);
            return this;
        }

        public Buffer value_type_id(@NativeType(value="spvc_type_id") int value) {
            SpvcReflectedBuiltinResource.nvalue_type_id(this.address(), value);
            return this;
        }

        public Buffer resource(@NativeType(value="spvc_reflected_resource") SpvcReflectedResource value) {
            SpvcReflectedBuiltinResource.nresource(this.address(), value);
            return this;
        }

        public Buffer resource(Consumer<SpvcReflectedResource> consumer) {
            consumer.accept(this.resource());
            return this;
        }
    }
}

