/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.tinyexr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class EXRChannelInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int PIXEL_TYPE;
    public static final int X_SAMPLING;
    public static final int Y_SAMPLING;
    public static final int P_LINEAR;

    public EXRChannelInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), EXRChannelInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[256]")
    public ByteBuffer name() {
        return EXRChannelInfo.nname(this.address());
    }

    @NativeType(value="char[256]")
    public String nameString() {
        return EXRChannelInfo.nnameString(this.address());
    }

    public int pixel_type() {
        return EXRChannelInfo.npixel_type(this.address());
    }

    public int x_sampling() {
        return EXRChannelInfo.nx_sampling(this.address());
    }

    public int y_sampling() {
        return EXRChannelInfo.ny_sampling(this.address());
    }

    @NativeType(value="unsigned char")
    public byte p_linear() {
        return EXRChannelInfo.np_linear(this.address());
    }

    public EXRChannelInfo name(@NativeType(value="char[256]") ByteBuffer value) {
        EXRChannelInfo.nname(this.address(), value);
        return this;
    }

    public EXRChannelInfo pixel_type(int value) {
        EXRChannelInfo.npixel_type(this.address(), value);
        return this;
    }

    public EXRChannelInfo x_sampling(int value) {
        EXRChannelInfo.nx_sampling(this.address(), value);
        return this;
    }

    public EXRChannelInfo y_sampling(int value) {
        EXRChannelInfo.ny_sampling(this.address(), value);
        return this;
    }

    public EXRChannelInfo p_linear(@NativeType(value="unsigned char") byte value) {
        EXRChannelInfo.np_linear(this.address(), value);
        return this;
    }

    public EXRChannelInfo set(ByteBuffer name, int pixel_type, int x_sampling, int y_sampling, byte p_linear) {
        this.name(name);
        this.pixel_type(pixel_type);
        this.x_sampling(x_sampling);
        this.y_sampling(y_sampling);
        this.p_linear(p_linear);
        return this;
    }

    public EXRChannelInfo set(EXRChannelInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static EXRChannelInfo malloc() {
        return EXRChannelInfo.wrap(EXRChannelInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static EXRChannelInfo calloc() {
        return EXRChannelInfo.wrap(EXRChannelInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static EXRChannelInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return EXRChannelInfo.wrap(EXRChannelInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static EXRChannelInfo create(long address) {
        return EXRChannelInfo.wrap(EXRChannelInfo.class, address);
    }

    @Nullable
    public static EXRChannelInfo createSafe(long address) {
        return address == 0L ? null : EXRChannelInfo.wrap(EXRChannelInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return EXRChannelInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(EXRChannelInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return EXRChannelInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = EXRChannelInfo.__create(capacity, SIZEOF);
        return EXRChannelInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return EXRChannelInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : EXRChannelInfo.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static EXRChannelInfo mallocStack() {
        return EXRChannelInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static EXRChannelInfo callocStack() {
        return EXRChannelInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static EXRChannelInfo mallocStack(MemoryStack stack) {
        return EXRChannelInfo.malloc(stack);
    }

    @Deprecated
    public static EXRChannelInfo callocStack(MemoryStack stack) {
        return EXRChannelInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return EXRChannelInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return EXRChannelInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return EXRChannelInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return EXRChannelInfo.calloc(capacity, stack);
    }

    public static EXRChannelInfo malloc(MemoryStack stack) {
        return EXRChannelInfo.wrap(EXRChannelInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static EXRChannelInfo calloc(MemoryStack stack) {
        return EXRChannelInfo.wrap(EXRChannelInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return EXRChannelInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return EXRChannelInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)NAME, 256);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memASCII(struct + (long)NAME);
    }

    public static int npixel_type(long struct) {
        return UNSAFE.getInt(null, struct + (long)PIXEL_TYPE);
    }

    public static int nx_sampling(long struct) {
        return UNSAFE.getInt(null, struct + (long)X_SAMPLING);
    }

    public static int ny_sampling(long struct) {
        return UNSAFE.getInt(null, struct + (long)Y_SAMPLING);
    }

    public static byte np_linear(long struct) {
        return UNSAFE.getByte(null, struct + (long)P_LINEAR);
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
            Checks.checkGT(value, 256);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)NAME, value.remaining());
    }

    public static void npixel_type(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PIXEL_TYPE, value);
    }

    public static void nx_sampling(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)X_SAMPLING, value);
    }

    public static void ny_sampling(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)Y_SAMPLING, value);
    }

    public static void np_linear(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)P_LINEAR, value);
    }

    static {
        Struct.Layout layout = EXRChannelInfo.__struct(EXRChannelInfo.__array(1, 256), EXRChannelInfo.__member(4), EXRChannelInfo.__member(4), EXRChannelInfo.__member(4), EXRChannelInfo.__member(1), EXRChannelInfo.__padding(3, true));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        PIXEL_TYPE = layout.offsetof(1);
        X_SAMPLING = layout.offsetof(2);
        Y_SAMPLING = layout.offsetof(3);
        P_LINEAR = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<EXRChannelInfo, Buffer>
    implements NativeResource {
        private static final EXRChannelInfo ELEMENT_FACTORY = EXRChannelInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected EXRChannelInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[256]")
        public ByteBuffer name() {
            return EXRChannelInfo.nname(this.address());
        }

        @NativeType(value="char[256]")
        public String nameString() {
            return EXRChannelInfo.nnameString(this.address());
        }

        public int pixel_type() {
            return EXRChannelInfo.npixel_type(this.address());
        }

        public int x_sampling() {
            return EXRChannelInfo.nx_sampling(this.address());
        }

        public int y_sampling() {
            return EXRChannelInfo.ny_sampling(this.address());
        }

        @NativeType(value="unsigned char")
        public byte p_linear() {
            return EXRChannelInfo.np_linear(this.address());
        }

        public Buffer name(@NativeType(value="char[256]") ByteBuffer value) {
            EXRChannelInfo.nname(this.address(), value);
            return this;
        }

        public Buffer pixel_type(int value) {
            EXRChannelInfo.npixel_type(this.address(), value);
            return this;
        }

        public Buffer x_sampling(int value) {
            EXRChannelInfo.nx_sampling(this.address(), value);
            return this;
        }

        public Buffer y_sampling(int value) {
            EXRChannelInfo.ny_sampling(this.address(), value);
            return this;
        }

        public Buffer p_linear(@NativeType(value="unsigned char") byte value) {
            EXRChannelInfo.np_linear(this.address(), value);
            return this;
        }
    }
}

