/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.util.vma.LibVma;
import org.lwjgl.util.vma.VmaAllocationCreateInfo;
import org.lwjgl.util.vma.VmaAllocationInfo;
import org.lwjgl.util.vma.VmaAllocatorCreateInfo;
import org.lwjgl.util.vma.VmaAllocatorInfo;
import org.lwjgl.util.vma.VmaBudget;
import org.lwjgl.util.vma.VmaDefragmentationInfo;
import org.lwjgl.util.vma.VmaDefragmentationInfo2;
import org.lwjgl.util.vma.VmaDefragmentationPassInfo;
import org.lwjgl.util.vma.VmaDefragmentationStats;
import org.lwjgl.util.vma.VmaPoolCreateInfo;
import org.lwjgl.util.vma.VmaPoolStats;
import org.lwjgl.util.vma.VmaStatInfo;
import org.lwjgl.util.vma.VmaStats;
import org.lwjgl.util.vma.VmaVirtualAllocationCreateInfo;
import org.lwjgl.util.vma.VmaVirtualAllocationInfo;
import org.lwjgl.util.vma.VmaVirtualBlockCreateInfo;
import org.lwjgl.vulkan.VkBufferCreateInfo;
import org.lwjgl.vulkan.VkImageCreateInfo;
import org.lwjgl.vulkan.VkMemoryRequirements;

public class Vma {
    public static final int VMA_ALLOCATOR_CREATE_EXTERNALLY_SYNCHRONIZED_BIT = 1;
    public static final int VMA_ALLOCATOR_CREATE_KHR_DEDICATED_ALLOCATION_BIT = 2;
    public static final int VMA_ALLOCATOR_CREATE_KHR_BIND_MEMORY2_BIT = 4;
    public static final int VMA_ALLOCATOR_CREATE_EXT_MEMORY_BUDGET_BIT = 8;
    public static final int VMA_ALLOCATOR_CREATE_AMD_DEVICE_COHERENT_MEMORY_BIT = 16;
    public static final int VMA_ALLOCATOR_CREATE_BUFFER_DEVICE_ADDRESS_BIT = 32;
    public static final int VMA_ALLOCATOR_CREATE_EXT_MEMORY_PRIORITY_BIT = 64;
    public static final int VMA_MEMORY_USAGE_UNKNOWN = 0;
    public static final int VMA_MEMORY_USAGE_GPU_ONLY = 1;
    public static final int VMA_MEMORY_USAGE_CPU_ONLY = 2;
    public static final int VMA_MEMORY_USAGE_CPU_TO_GPU = 3;
    public static final int VMA_MEMORY_USAGE_GPU_TO_CPU = 4;
    public static final int VMA_MEMORY_USAGE_CPU_COPY = 5;
    public static final int VMA_MEMORY_USAGE_GPU_LAZILY_ALLOCATED = 6;
    public static final int VMA_MEMORY_USAGE_AUTO = 7;
    public static final int VMA_MEMORY_USAGE_AUTO_PREFER_DEVICE = 8;
    public static final int VMA_MEMORY_USAGE_AUTO_PREFER_HOST = 9;
    public static final int VMA_ALLOCATION_CREATE_DEDICATED_MEMORY_BIT = 1;
    public static final int VMA_ALLOCATION_CREATE_NEVER_ALLOCATE_BIT = 2;
    public static final int VMA_ALLOCATION_CREATE_MAPPED_BIT = 4;
    public static final int VMA_ALLOCATION_CREATE_RESERVED_1_BIT = 8;
    public static final int VMA_ALLOCATION_CREATE_RESERVED_2_BIT = 16;
    public static final int VMA_ALLOCATION_CREATE_USER_DATA_COPY_STRING_BIT = 32;
    public static final int VMA_ALLOCATION_CREATE_UPPER_ADDRESS_BIT = 64;
    public static final int VMA_ALLOCATION_CREATE_DONT_BIND_BIT = 128;
    public static final int VMA_ALLOCATION_CREATE_WITHIN_BUDGET_BIT = 256;
    public static final int VMA_ALLOCATION_CREATE_CAN_ALIAS_BIT = 512;
    public static final int VMA_ALLOCATION_CREATE_HOST_ACCESS_SEQUENTIAL_WRITE_BIT = 1024;
    public static final int VMA_ALLOCATION_CREATE_HOST_ACCESS_RANDOM_BIT = 2048;
    public static final int VMA_ALLOCATION_CREATE_HOST_ACCESS_ALLOW_TRANSFER_INSTEAD_BIT = 4096;
    public static final int VMA_ALLOCATION_CREATE_STRATEGY_MIN_MEMORY_BIT = 65536;
    public static final int VMA_ALLOCATION_CREATE_STRATEGY_MIN_TIME_BIT = 131072;
    public static final int VMA_ALLOCATION_CREATE_STRATEGY_BEST_FIT_BIT = 65536;
    public static final int VMA_VMA_ALLOCATION_CREATE_STRATEGY_FIRST_FIT_BIT = 131072;
    public static final int VMA_ALLOCATION_CREATE_STRATEGY_MASK = 196608;
    public static final int VMA_POOL_CREATE_IGNORE_BUFFER_IMAGE_GRANULARITY_BIT = 2;
    public static final int VMA_POOL_CREATE_LINEAR_ALGORITHM_BIT = 4;
    public static final int VMA_POOL_CREATE_BUDDY_ALGORITHM_BIT = 8;
    public static final int VMA_POOL_CREATE_TLSF_ALGORITHM_BIT = 16;
    public static final int VMA_POOL_CREATE_ALGORITHM_MASK = 28;
    public static final int VMA_DEFRAGMENTATION_FLAG_INCREMENTAL = 1;
    public static final int VMA_VIRTUAL_BLOCK_CREATE_LINEAR_ALGORITHM_BIT = 1;
    public static final int VMA_VIRTUAL_BLOCK_CREATE_BUDDY_ALGORITHM_BIT = 2;
    public static final int VMA_VIRTUAL_BLOCK_CREATE_TLSF_ALGORITHM_BIT = 4;
    public static final int VMA_VIRTUAL_BLOCK_CREATE_ALGORITHM_MASK = 7;
    public static final int VMA_VIRTUAL_ALLOCATION_CREATE_UPPER_ADDRESS_BIT = 64;
    public static final int VMA_VIRTUAL_ALLOCATION_CREATE_STRATEGY_MIN_MEMORY_BIT = 65536;
    public static final int VMA_VIRTUAL_ALLOCATION_CREATE_STRATEGY_MIN_TIME_BIT = 131072;
    public static final int VMA_VIRTUAL_ALLOCATION_CREATE_STRATEGY_MASK = 196608;

    protected Vma() {
        throw new UnsupportedOperationException();
    }

    public static native int nvmaCreateAllocator(long var0, long var2);

    @NativeType(value="VkResult")
    public static int vmaCreateAllocator(@NativeType(value="VmaAllocatorCreateInfo const *") VmaAllocatorCreateInfo pCreateInfo, @NativeType(value="VmaAllocator *") PointerBuffer pAllocator) {
        if (Checks.CHECKS) {
            Checks.check(pAllocator, 1);
            VmaAllocatorCreateInfo.validate(pCreateInfo.address());
        }
        return Vma.nvmaCreateAllocator(pCreateInfo.address(), MemoryUtil.memAddress(pAllocator));
    }

    public static native void nvmaDestroyAllocator(long var0);

    public static void vmaDestroyAllocator(@NativeType(value="VmaAllocator") long allocator) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
        }
        Vma.nvmaDestroyAllocator(allocator);
    }

    public static native void nvmaGetAllocatorInfo(long var0, long var2);

    public static void vmaGetAllocatorInfo(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocatorInfo *") VmaAllocatorInfo pAllocatorInfo) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
        }
        Vma.nvmaGetAllocatorInfo(allocator, pAllocatorInfo.address());
    }

    public static native void nvmaGetPhysicalDeviceProperties(long var0, long var2);

    public static void vmaGetPhysicalDeviceProperties(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkPhysicalDeviceProperties const **") PointerBuffer ppPhysicalDeviceProperties) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(ppPhysicalDeviceProperties, 1);
        }
        Vma.nvmaGetPhysicalDeviceProperties(allocator, MemoryUtil.memAddress(ppPhysicalDeviceProperties));
    }

    public static native void nvmaGetMemoryProperties(long var0, long var2);

    public static void vmaGetMemoryProperties(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkPhysicalDeviceMemoryProperties const **") PointerBuffer ppPhysicalDeviceMemoryProperties) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(ppPhysicalDeviceMemoryProperties, 1);
        }
        Vma.nvmaGetMemoryProperties(allocator, MemoryUtil.memAddress(ppPhysicalDeviceMemoryProperties));
    }

    public static native void nvmaGetMemoryTypeProperties(long var0, int var2, long var3);

    public static void vmaGetMemoryTypeProperties(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="uint32_t") int memoryTypeIndex, @NativeType(value="VkMemoryPropertyFlags *") IntBuffer pFlags) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check((Buffer)pFlags, 1);
        }
        Vma.nvmaGetMemoryTypeProperties(allocator, memoryTypeIndex, MemoryUtil.memAddress(pFlags));
    }

    public static native void nvmaSetCurrentFrameIndex(long var0, int var2);

    public static void vmaSetCurrentFrameIndex(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="uint32_t") int frameIndex) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
        }
        Vma.nvmaSetCurrentFrameIndex(allocator, frameIndex);
    }

    public static native void nvmaCalculateStats(long var0, long var2);

    public static void vmaCalculateStats(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaStats *") VmaStats pStats) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
        }
        Vma.nvmaCalculateStats(allocator, pStats.address());
    }

    public static native void nvmaGetHeapBudgets(long var0, long var2);

    public static void vmaGetHeapBudgets(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaBudget *") VmaBudget.Buffer pBudget) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
        }
        Vma.nvmaGetHeapBudgets(allocator, pBudget.address());
    }

    public static native int nvmaFindMemoryTypeIndex(long var0, int var2, long var3, long var5);

    @NativeType(value="VkResult")
    public static int vmaFindMemoryTypeIndex(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="uint32_t") int memoryTypeBits, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pAllocationCreateInfo, @NativeType(value="uint32_t *") IntBuffer pMemoryTypeIndex) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check((Buffer)pMemoryTypeIndex, 1);
        }
        return Vma.nvmaFindMemoryTypeIndex(allocator, memoryTypeBits, pAllocationCreateInfo.address(), MemoryUtil.memAddress(pMemoryTypeIndex));
    }

    public static native int nvmaFindMemoryTypeIndexForBufferInfo(long var0, long var2, long var4, long var6);

    @NativeType(value="VkResult")
    public static int vmaFindMemoryTypeIndexForBufferInfo(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkBufferCreateInfo const *") VkBufferCreateInfo pBufferCreateInfo, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pAllocationCreateInfo, @NativeType(value="uint32_t *") IntBuffer pMemoryTypeIndex) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check((Buffer)pMemoryTypeIndex, 1);
        }
        return Vma.nvmaFindMemoryTypeIndexForBufferInfo(allocator, pBufferCreateInfo.address(), pAllocationCreateInfo.address(), MemoryUtil.memAddress(pMemoryTypeIndex));
    }

    public static native int nvmaFindMemoryTypeIndexForImageInfo(long var0, long var2, long var4, long var6);

    @NativeType(value="VkResult")
    public static int vmaFindMemoryTypeIndexForImageInfo(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkImageCreateInfo const *") VkImageCreateInfo pImageCreateInfo, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pAllocationCreateInfo, @NativeType(value="uint32_t *") IntBuffer pMemoryTypeIndex) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check((Buffer)pMemoryTypeIndex, 1);
        }
        return Vma.nvmaFindMemoryTypeIndexForImageInfo(allocator, pImageCreateInfo.address(), pAllocationCreateInfo.address(), MemoryUtil.memAddress(pMemoryTypeIndex));
    }

    public static native int nvmaCreatePool(long var0, long var2, long var4);

    @NativeType(value="VkResult")
    public static int vmaCreatePool(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaPoolCreateInfo const *") VmaPoolCreateInfo pCreateInfo, @NativeType(value="VmaPool *") PointerBuffer pPool) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(pPool, 1);
        }
        return Vma.nvmaCreatePool(allocator, pCreateInfo.address(), MemoryUtil.memAddress(pPool));
    }

    public static native void nvmaDestroyPool(long var0, long var2);

    public static void vmaDestroyPool(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaPool") long pool) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(pool);
        }
        Vma.nvmaDestroyPool(allocator, pool);
    }

    public static native void nvmaGetPoolStats(long var0, long var2, long var4);

    public static void vmaGetPoolStats(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaPool") long pool, @NativeType(value="VmaPoolStats *") VmaPoolStats pPoolStats) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(pool);
        }
        Vma.nvmaGetPoolStats(allocator, pool, pPoolStats.address());
    }

    public static native int nvmaCheckPoolCorruption(long var0, long var2);

    @NativeType(value="VkResult")
    public static int vmaCheckPoolCorruption(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaPool") long pool) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(pool);
        }
        return Vma.nvmaCheckPoolCorruption(allocator, pool);
    }

    public static native void nvmaGetPoolName(long var0, long var2, long var4);

    public static void vmaGetPoolName(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaPool") long pool, @NativeType(value="char const **") PointerBuffer ppName) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(pool);
            Checks.check(ppName, 1);
        }
        Vma.nvmaGetPoolName(allocator, pool, MemoryUtil.memAddress(ppName));
    }

    public static native void nvmaSetPoolName(long var0, long var2, long var4);

    public static void vmaSetPoolName(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaPool") long pool, @Nullable @NativeType(value="char const *") ByteBuffer pName) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(pool);
            Checks.checkNT1Safe(pName);
        }
        Vma.nvmaSetPoolName(allocator, pool, MemoryUtil.memAddressSafe(pName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void vmaSetPoolName(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaPool") long pool, @Nullable @NativeType(value="char const *") CharSequence pName) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(pool);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCIISafe(pName, true);
            long pNameEncoded = pName == null ? 0L : stack.getPointerAddress();
            Vma.nvmaSetPoolName(allocator, pool, pNameEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nvmaAllocateMemory(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="VkResult")
    public static int vmaAllocateMemory(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkMemoryRequirements const *") VkMemoryRequirements pVkMemoryRequirements, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pCreateInfo, @NativeType(value="VmaAllocation *") PointerBuffer pAllocation, @Nullable @NativeType(value="VmaAllocationInfo *") VmaAllocationInfo pAllocationInfo) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(pAllocation, 1);
        }
        return Vma.nvmaAllocateMemory(allocator, pVkMemoryRequirements.address(), pCreateInfo.address(), MemoryUtil.memAddress(pAllocation), MemoryUtil.memAddressSafe(pAllocationInfo));
    }

    public static native int nvmaAllocateMemoryPages(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="VkResult")
    public static int vmaAllocateMemoryPages(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkMemoryRequirements const *") VkMemoryRequirements pVkMemoryRequirements, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pCreateInfo, @NativeType(value="VmaAllocation *") PointerBuffer pAllocations, @Nullable @NativeType(value="VmaAllocationInfo *") VmaAllocationInfo.Buffer pAllocationInfo) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.checkSafe(pAllocationInfo, pAllocations.remaining());
            Checks.check(pAllocations, 1);
        }
        return Vma.nvmaAllocateMemoryPages(allocator, pVkMemoryRequirements.address(), pCreateInfo.address(), pAllocations.remaining(), MemoryUtil.memAddress(pAllocations), MemoryUtil.memAddressSafe(pAllocationInfo));
    }

    public static native int nvmaAllocateMemoryForBuffer(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="VkResult")
    public static int vmaAllocateMemoryForBuffer(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkBuffer") long buffer, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pCreateInfo, @NativeType(value="VmaAllocation *") PointerBuffer pAllocation, @Nullable @NativeType(value="VmaAllocationInfo *") VmaAllocationInfo pAllocationInfo) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(pAllocation, 1);
        }
        return Vma.nvmaAllocateMemoryForBuffer(allocator, buffer, pCreateInfo.address(), MemoryUtil.memAddress(pAllocation), MemoryUtil.memAddressSafe(pAllocationInfo));
    }

    public static native int nvmaAllocateMemoryForImage(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="VkResult")
    public static int vmaAllocateMemoryForImage(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkImage") long image, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pCreateInfo, @NativeType(value="VmaAllocation *") PointerBuffer pAllocation, @Nullable @NativeType(value="VmaAllocationInfo *") VmaAllocationInfo pAllocationInfo) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(pAllocation, 1);
        }
        return Vma.nvmaAllocateMemoryForImage(allocator, image, pCreateInfo.address(), MemoryUtil.memAddress(pAllocation), MemoryUtil.memAddressSafe(pAllocationInfo));
    }

    public static native void nvmaFreeMemory(long var0, long var2);

    public static void vmaFreeMemory(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation const") long allocation) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
        }
        Vma.nvmaFreeMemory(allocator, allocation);
    }

    public static native void nvmaFreeMemoryPages(long var0, long var2, long var4);

    public static void vmaFreeMemoryPages(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation const *") PointerBuffer pAllocations) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
        }
        Vma.nvmaFreeMemoryPages(allocator, pAllocations.remaining(), MemoryUtil.memAddress(pAllocations));
    }

    public static native void nvmaGetAllocationInfo(long var0, long var2, long var4);

    public static void vmaGetAllocationInfo(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VmaAllocationInfo *") VmaAllocationInfo pAllocationInfo) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(allocation);
        }
        Vma.nvmaGetAllocationInfo(allocator, allocation, pAllocationInfo.address());
    }

    public static native void nvmaSetAllocationUserData(long var0, long var2, long var4);

    public static void vmaSetAllocationUserData(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="void *") long pUserData) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(allocation);
        }
        Vma.nvmaSetAllocationUserData(allocator, allocation, pUserData);
    }

    public static native void nvmaGetAllocationMemoryProperties(long var0, long var2, long var4);

    public static void vmaGetAllocationMemoryProperties(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkMemoryPropertyFlags *") IntBuffer pFlags) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(allocation);
            Checks.check((Buffer)pFlags, 1);
        }
        Vma.nvmaGetAllocationMemoryProperties(allocator, allocation, MemoryUtil.memAddress(pFlags));
    }

    public static native int nvmaMapMemory(long var0, long var2, long var4);

    @NativeType(value="VkResult")
    public static int vmaMapMemory(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="void **") PointerBuffer ppData) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(allocation);
            Checks.check(ppData, 1);
        }
        return Vma.nvmaMapMemory(allocator, allocation, MemoryUtil.memAddress(ppData));
    }

    public static native void nvmaUnmapMemory(long var0, long var2);

    public static void vmaUnmapMemory(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(allocation);
        }
        Vma.nvmaUnmapMemory(allocator, allocation);
    }

    public static native void nvmaFlushAllocation(long var0, long var2, long var4, long var6);

    public static void vmaFlushAllocation(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkDeviceSize") long offset, @NativeType(value="VkDeviceSize") long size) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(allocation);
        }
        Vma.nvmaFlushAllocation(allocator, allocation, offset, size);
    }

    public static native void nvmaInvalidateAllocation(long var0, long var2, long var4, long var6);

    public static void vmaInvalidateAllocation(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkDeviceSize") long offset, @NativeType(value="VkDeviceSize") long size) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(allocation);
        }
        Vma.nvmaInvalidateAllocation(allocator, allocation, offset, size);
    }

    public static native int nvmaFlushAllocations(long var0, int var2, long var3, long var5, long var7);

    @NativeType(value="VkResult")
    public static int vmaFlushAllocations(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation const *") PointerBuffer allocations, @Nullable @NativeType(value="VkDeviceSize const *") LongBuffer offsets, @Nullable @NativeType(value="VkDeviceSize const *") LongBuffer sizes) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.checkSafe((Buffer)offsets, allocations.remaining());
            Checks.checkSafe((Buffer)sizes, allocations.remaining());
        }
        return Vma.nvmaFlushAllocations(allocator, allocations.remaining(), MemoryUtil.memAddress(allocations), MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(sizes));
    }

    public static native int nvmaInvalidateAllocations(long var0, int var2, long var3, long var5, long var7);

    @NativeType(value="VkResult")
    public static int vmaInvalidateAllocations(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation const *") PointerBuffer allocations, @Nullable @NativeType(value="VkDeviceSize const *") LongBuffer offsets, @Nullable @NativeType(value="VkDeviceSize const *") LongBuffer sizes) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.checkSafe((Buffer)offsets, allocations.remaining());
            Checks.checkSafe((Buffer)sizes, allocations.remaining());
        }
        return Vma.nvmaInvalidateAllocations(allocator, allocations.remaining(), MemoryUtil.memAddress(allocations), MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(sizes));
    }

    public static native int nvmaCheckCorruption(long var0, int var2);

    @NativeType(value="VkResult")
    public static int vmaCheckCorruption(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="uint32_t") int memoryTypeBits) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
        }
        return Vma.nvmaCheckCorruption(allocator, memoryTypeBits);
    }

    public static native int nvmaDefragmentationBegin(long var0, long var2, long var4, long var6);

    @NativeType(value="VkResult")
    public static int vmaDefragmentationBegin(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaDefragmentationInfo2 const *") VmaDefragmentationInfo2 pInfo, @Nullable @NativeType(value="VmaDefragmentationStats *") VmaDefragmentationStats pStats, @NativeType(value="VmaDefragmentationContext *") PointerBuffer pContext) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(pContext, 1);
            VmaDefragmentationInfo2.validate(pInfo.address());
        }
        return Vma.nvmaDefragmentationBegin(allocator, pInfo.address(), MemoryUtil.memAddressSafe(pStats), MemoryUtil.memAddress(pContext));
    }

    public static native int nvmaDefragmentationEnd(long var0, long var2);

    @NativeType(value="VkResult")
    public static int vmaDefragmentationEnd(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaDefragmentationContext") long context) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
        }
        return Vma.nvmaDefragmentationEnd(allocator, context);
    }

    public static native int nvmaBeginDefragmentationPass(long var0, long var2, long var4);

    @NativeType(value="VkResult")
    public static int vmaBeginDefragmentationPass(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaDefragmentationContext") long context, @NativeType(value="VmaDefragmentationPassInfo *") VmaDefragmentationPassInfo pInfo) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
        }
        return Vma.nvmaBeginDefragmentationPass(allocator, context, pInfo.address());
    }

    public static native int nvmaEndDefragmentationPass(long var0, long var2);

    @NativeType(value="VkResult")
    public static int vmaEndDefragmentationPass(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaDefragmentationContext") long context) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
        }
        return Vma.nvmaEndDefragmentationPass(allocator, context);
    }

    public static native int nvmaDefragment(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="VkResult")
    public static int vmaDefragment(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation const *") PointerBuffer pAllocations, @Nullable @NativeType(value="VkBool32 *") IntBuffer pAllocationsChanged, @Nullable @NativeType(value="VmaDefragmentationInfo const *") VmaDefragmentationInfo pDefragmentationInfo, @Nullable @NativeType(value="VmaDefragmentationStats *") VmaDefragmentationStats pDefragmentationStats) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.checkSafe((Buffer)pAllocationsChanged, pAllocations.remaining());
        }
        return Vma.nvmaDefragment(allocator, MemoryUtil.memAddress(pAllocations), pAllocations.remaining(), MemoryUtil.memAddressSafe(pAllocationsChanged), MemoryUtil.memAddressSafe(pDefragmentationInfo), MemoryUtil.memAddressSafe(pDefragmentationStats));
    }

    public static native int nvmaBindBufferMemory(long var0, long var2, long var4);

    @NativeType(value="VkResult")
    public static int vmaBindBufferMemory(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkBuffer") long buffer) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(allocation);
        }
        return Vma.nvmaBindBufferMemory(allocator, allocation, buffer);
    }

    public static native int nvmaBindBufferMemory2(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="VkResult")
    public static int vmaBindBufferMemory2(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkDeviceSize") long allocationLocalOffset, @NativeType(value="VkBuffer") long buffer, @NativeType(value="void const *") long pNext) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(allocation);
        }
        return Vma.nvmaBindBufferMemory2(allocator, allocation, allocationLocalOffset, buffer, pNext);
    }

    public static native int nvmaBindImageMemory(long var0, long var2, long var4);

    @NativeType(value="VkResult")
    public static int vmaBindImageMemory(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkImage") long image) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(allocation);
        }
        return Vma.nvmaBindImageMemory(allocator, allocation, image);
    }

    public static native int nvmaBindImageMemory2(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="VkResult")
    public static int vmaBindImageMemory2(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkDeviceSize") long allocationLocalOffset, @NativeType(value="VkImage") long image, @NativeType(value="void const *") long pNext) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(allocation);
        }
        return Vma.nvmaBindImageMemory2(allocator, allocation, allocationLocalOffset, image, pNext);
    }

    public static native int nvmaCreateBuffer(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="VkResult")
    public static int vmaCreateBuffer(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkBufferCreateInfo const *") VkBufferCreateInfo pBufferCreateInfo, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pAllocationCreateInfo, @NativeType(value="VkBuffer *") LongBuffer pBuffer, @NativeType(value="VmaAllocation *") PointerBuffer pAllocation, @Nullable @NativeType(value="VmaAllocationInfo *") VmaAllocationInfo pAllocationInfo) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check((Buffer)pBuffer, 1);
            Checks.check(pAllocation, 1);
        }
        return Vma.nvmaCreateBuffer(allocator, pBufferCreateInfo.address(), pAllocationCreateInfo.address(), MemoryUtil.memAddress(pBuffer), MemoryUtil.memAddress(pAllocation), MemoryUtil.memAddressSafe(pAllocationInfo));
    }

    public static native int nvmaCreateBufferWithAlignment(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    @NativeType(value="VkResult")
    public static int vmaCreateBufferWithAlignment(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkBufferCreateInfo const *") VkBufferCreateInfo pBufferCreateInfo, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pAllocationCreateInfo, @NativeType(value="VkDeviceSize") long minAlignment, @NativeType(value="VkBuffer *") LongBuffer pBuffer, @NativeType(value="VmaAllocation *") PointerBuffer pAllocation, @Nullable @NativeType(value="VmaAllocationInfo *") VmaAllocationInfo pAllocationInfo) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check((Buffer)pBuffer, 1);
            Checks.check(pAllocation, 1);
        }
        return Vma.nvmaCreateBufferWithAlignment(allocator, pBufferCreateInfo.address(), pAllocationCreateInfo.address(), minAlignment, MemoryUtil.memAddress(pBuffer), MemoryUtil.memAddress(pAllocation), MemoryUtil.memAddressSafe(pAllocationInfo));
    }

    public static native void nvmaDestroyBuffer(long var0, long var2, long var4);

    public static void vmaDestroyBuffer(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkBuffer") long buffer, @NativeType(value="VmaAllocation") long allocation) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
        }
        Vma.nvmaDestroyBuffer(allocator, buffer, allocation);
    }

    public static native int nvmaCreateImage(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="VkResult")
    public static int vmaCreateImage(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkImageCreateInfo const *") VkImageCreateInfo pImageCreateInfo, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pAllocationCreateInfo, @NativeType(value="VkImage *") LongBuffer pImage, @NativeType(value="VmaAllocation *") PointerBuffer pAllocation, @Nullable @NativeType(value="VmaAllocationInfo *") VmaAllocationInfo pAllocationInfo) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check((Buffer)pImage, 1);
            Checks.check(pAllocation, 1);
        }
        return Vma.nvmaCreateImage(allocator, pImageCreateInfo.address(), pAllocationCreateInfo.address(), MemoryUtil.memAddress(pImage), MemoryUtil.memAddress(pAllocation), MemoryUtil.memAddressSafe(pAllocationInfo));
    }

    public static native void nvmaDestroyImage(long var0, long var2, long var4);

    public static void vmaDestroyImage(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkImage") long image, @NativeType(value="VmaAllocation") long allocation) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
        }
        Vma.nvmaDestroyImage(allocator, image, allocation);
    }

    public static native int nvmaCreateVirtualBlock(long var0, long var2);

    @NativeType(value="VkResult")
    public static int vmaCreateVirtualBlock(@NativeType(value="VmaVirtualBlockCreateInfo const *") VmaVirtualBlockCreateInfo pCreateInfo, @NativeType(value="VmaVirtualBlock *") PointerBuffer pVirtualBlock) {
        if (Checks.CHECKS) {
            Checks.check(pVirtualBlock, 1);
        }
        return Vma.nvmaCreateVirtualBlock(pCreateInfo.address(), MemoryUtil.memAddress(pVirtualBlock));
    }

    public static native void nvmaDestroyVirtualBlock(long var0);

    public static void vmaDestroyVirtualBlock(@NativeType(value="VmaVirtualBlock") long virtualBlock) {
        if (Checks.CHECKS) {
            Checks.check(virtualBlock);
        }
        Vma.nvmaDestroyVirtualBlock(virtualBlock);
    }

    public static native int nvmaIsVirtualBlockEmpty(long var0);

    @NativeType(value="VkBool32")
    public static boolean vmaIsVirtualBlockEmpty(@NativeType(value="VmaVirtualBlock") long virtualBlock) {
        if (Checks.CHECKS) {
            Checks.check(virtualBlock);
        }
        return Vma.nvmaIsVirtualBlockEmpty(virtualBlock) != 0;
    }

    public static native void nvmaGetVirtualAllocationInfo(long var0, long var2, long var4);

    public static void vmaGetVirtualAllocationInfo(@NativeType(value="VmaVirtualBlock") long virtualBlock, @NativeType(value="VmaVirtualAllocation") long allocation, @NativeType(value="VmaVirtualAllocationInfo *") VmaVirtualAllocationInfo pVirtualAllocInfo) {
        if (Checks.CHECKS) {
            Checks.check(virtualBlock);
            Checks.check(allocation);
        }
        Vma.nvmaGetVirtualAllocationInfo(virtualBlock, allocation, pVirtualAllocInfo.address());
    }

    public static native int nvmaVirtualAllocate(long var0, long var2, long var4, long var6);

    @NativeType(value="VkResult")
    public static int vmaVirtualAllocate(@NativeType(value="VmaVirtualBlock") long virtualBlock, @NativeType(value="VmaVirtualAllocationCreateInfo const *") VmaVirtualAllocationCreateInfo pCreateInfo, @NativeType(value="VmaVirtualAllocation *") PointerBuffer pAllocation, @Nullable @NativeType(value="VkDeviceSize *") LongBuffer pOffset) {
        if (Checks.CHECKS) {
            Checks.check(virtualBlock);
            Checks.check(pAllocation, 1);
            Checks.checkSafe((Buffer)pOffset, 1);
        }
        return Vma.nvmaVirtualAllocate(virtualBlock, pCreateInfo.address(), MemoryUtil.memAddress(pAllocation), MemoryUtil.memAddressSafe(pOffset));
    }

    public static native void nvmaVirtualFree(long var0, long var2);

    public static void vmaVirtualFree(@NativeType(value="VmaVirtualBlock") long virtualBlock, @NativeType(value="VmaVirtualAllocation") long allocation) {
        if (Checks.CHECKS) {
            Checks.check(virtualBlock);
        }
        Vma.nvmaVirtualFree(virtualBlock, allocation);
    }

    public static native void nvmaClearVirtualBlock(long var0);

    public static void vmaClearVirtualBlock(@NativeType(value="VmaVirtualBlock") long virtualBlock) {
        if (Checks.CHECKS) {
            Checks.check(virtualBlock);
        }
        Vma.nvmaClearVirtualBlock(virtualBlock);
    }

    public static native void nvmaSetVirtualAllocationUserData(long var0, long var2, long var4);

    public static void vmaSetVirtualAllocationUserData(@NativeType(value="VmaVirtualBlock") long virtualBlock, @NativeType(value="VmaVirtualAllocation") long allocation, @NativeType(value="void *") long pUserData) {
        if (Checks.CHECKS) {
            Checks.check(virtualBlock);
            Checks.check(allocation);
            Checks.check(pUserData);
        }
        Vma.nvmaSetVirtualAllocationUserData(virtualBlock, allocation, pUserData);
    }

    public static native void nvmaCalculateVirtualBlockStats(long var0, long var2);

    public static void vmaCalculateVirtualBlockStats(@NativeType(value="VmaVirtualBlock") long virtualBlock, @NativeType(value="VmaStatInfo *") VmaStatInfo pStatInfo) {
        if (Checks.CHECKS) {
            Checks.check(virtualBlock);
        }
        Vma.nvmaCalculateVirtualBlockStats(virtualBlock, pStatInfo.address());
    }

    public static native void nvmaBuildVirtualBlockStatsString(long var0, long var2, int var4);

    public static void vmaBuildVirtualBlockStatsString(@NativeType(value="VmaVirtualBlock") long virtualBlock, @NativeType(value="char **") PointerBuffer ppStatsString, @NativeType(value="VkBool32") boolean detailedMap) {
        if (Checks.CHECKS) {
            Checks.check(virtualBlock);
            Checks.check(ppStatsString, 1);
        }
        Vma.nvmaBuildVirtualBlockStatsString(virtualBlock, MemoryUtil.memAddress(ppStatsString), detailedMap ? 1 : 0);
    }

    public static native void nvmaFreeVirtualBlockStatsString(long var0, long var2);

    public static void vmaFreeVirtualBlockStatsString(@NativeType(value="VmaVirtualBlock") long virtualBlock, @NativeType(value="char *") ByteBuffer pStatsString) {
        if (Checks.CHECKS) {
            Checks.check(virtualBlock);
        }
        Vma.nvmaFreeVirtualBlockStatsString(virtualBlock, MemoryUtil.memAddress(pStatsString));
    }

    public static native void nvmaBuildStatsString(long var0, long var2, int var4);

    public static void vmaBuildStatsString(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="char **") PointerBuffer ppStatsString, @NativeType(value="VkBool32") boolean detailedMap) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
            Checks.check(ppStatsString, 1);
        }
        Vma.nvmaBuildStatsString(allocator, MemoryUtil.memAddress(ppStatsString), detailedMap ? 1 : 0);
    }

    public static native void nvmaFreeStatsString(long var0, long var2);

    public static void vmaFreeStatsString(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="char *") ByteBuffer pStatsString) {
        if (Checks.CHECKS) {
            Checks.check(allocator);
        }
        Vma.nvmaFreeStatsString(allocator, MemoryUtil.memAddress(pStatsString));
    }

    static {
        LibVma.initialize();
    }
}

