/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.vma.VmaDefragmentationPassMoveInfo;

public class VmaDefragmentationPassInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MOVECOUNT;
    public static final int PMOVES;

    public VmaDefragmentationPassInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VmaDefragmentationPassInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int moveCount() {
        return VmaDefragmentationPassInfo.nmoveCount(this.address());
    }

    @NativeType(value="VmaDefragmentationPassMoveInfo *")
    public VmaDefragmentationPassMoveInfo.Buffer pMoves() {
        return VmaDefragmentationPassInfo.npMoves(this.address());
    }

    public static VmaDefragmentationPassInfo malloc() {
        return VmaDefragmentationPassInfo.wrap(VmaDefragmentationPassInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VmaDefragmentationPassInfo calloc() {
        return VmaDefragmentationPassInfo.wrap(VmaDefragmentationPassInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VmaDefragmentationPassInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VmaDefragmentationPassInfo.wrap(VmaDefragmentationPassInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VmaDefragmentationPassInfo create(long address) {
        return VmaDefragmentationPassInfo.wrap(VmaDefragmentationPassInfo.class, address);
    }

    @Nullable
    public static VmaDefragmentationPassInfo createSafe(long address) {
        return address == 0L ? null : VmaDefragmentationPassInfo.wrap(VmaDefragmentationPassInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VmaDefragmentationPassInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VmaDefragmentationPassInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VmaDefragmentationPassInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaDefragmentationPassInfo.__create(capacity, SIZEOF);
        return VmaDefragmentationPassInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VmaDefragmentationPassInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VmaDefragmentationPassInfo.wrap(Buffer.class, address, capacity);
    }

    public static VmaDefragmentationPassInfo malloc(MemoryStack stack) {
        return VmaDefragmentationPassInfo.wrap(VmaDefragmentationPassInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaDefragmentationPassInfo calloc(MemoryStack stack) {
        return VmaDefragmentationPassInfo.wrap(VmaDefragmentationPassInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VmaDefragmentationPassInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VmaDefragmentationPassInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmoveCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)MOVECOUNT);
    }

    public static VmaDefragmentationPassMoveInfo.Buffer npMoves(long struct) {
        return VmaDefragmentationPassMoveInfo.create(MemoryUtil.memGetAddress(struct + (long)PMOVES), VmaDefragmentationPassInfo.nmoveCount(struct));
    }

    static {
        Struct.Layout layout = VmaDefragmentationPassInfo.__struct(VmaDefragmentationPassInfo.__member(4), VmaDefragmentationPassInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MOVECOUNT = layout.offsetof(0);
        PMOVES = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VmaDefragmentationPassInfo, Buffer>
    implements NativeResource {
        private static final VmaDefragmentationPassInfo ELEMENT_FACTORY = VmaDefragmentationPassInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VmaDefragmentationPassInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int moveCount() {
            return VmaDefragmentationPassInfo.nmoveCount(this.address());
        }

        @NativeType(value="VmaDefragmentationPassMoveInfo *")
        public VmaDefragmentationPassMoveInfo.Buffer pMoves() {
            return VmaDefragmentationPassInfo.npMoves(this.address());
        }
    }
}

