/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaDefragmentationPassMoveInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ALLOCATION;
    public static final int MEMORY;
    public static final int OFFSET;

    public VmaDefragmentationPassMoveInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VmaDefragmentationPassMoveInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VmaAllocation")
    public long allocation() {
        return VmaDefragmentationPassMoveInfo.nallocation(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long memory() {
        return VmaDefragmentationPassMoveInfo.nmemory(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VmaDefragmentationPassMoveInfo.noffset(this.address());
    }

    public static VmaDefragmentationPassMoveInfo create(long address) {
        return VmaDefragmentationPassMoveInfo.wrap(VmaDefragmentationPassMoveInfo.class, address);
    }

    @Nullable
    public static VmaDefragmentationPassMoveInfo createSafe(long address) {
        return address == 0L ? null : VmaDefragmentationPassMoveInfo.wrap(VmaDefragmentationPassMoveInfo.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return VmaDefragmentationPassMoveInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VmaDefragmentationPassMoveInfo.wrap(Buffer.class, address, capacity);
    }

    public static long nallocation(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)ALLOCATION);
    }

    public static long nmemory(long struct) {
        return UNSAFE.getLong(null, struct + (long)MEMORY);
    }

    public static long noffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)OFFSET);
    }

    static {
        Struct.Layout layout = VmaDefragmentationPassMoveInfo.__struct(VmaDefragmentationPassMoveInfo.__member(POINTER_SIZE), VmaDefragmentationPassMoveInfo.__member(8), VmaDefragmentationPassMoveInfo.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ALLOCATION = layout.offsetof(0);
        MEMORY = layout.offsetof(1);
        OFFSET = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VmaDefragmentationPassMoveInfo, Buffer> {
        private static final VmaDefragmentationPassMoveInfo ELEMENT_FACTORY = VmaDefragmentationPassMoveInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VmaDefragmentationPassMoveInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VmaAllocation")
        public long allocation() {
            return VmaDefragmentationPassMoveInfo.nallocation(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long memory() {
            return VmaDefragmentationPassMoveInfo.nmemory(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VmaDefragmentationPassMoveInfo.noffset(this.address());
        }
    }
}

