/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.vma.VmaAllocateDeviceMemoryFunction;
import org.lwjgl.util.vma.VmaAllocateDeviceMemoryFunctionI;
import org.lwjgl.util.vma.VmaFreeDeviceMemoryFunction;
import org.lwjgl.util.vma.VmaFreeDeviceMemoryFunctionI;

public class VmaDeviceMemoryCallbacks
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PFNALLOCATE;
    public static final int PFNFREE;
    public static final int PUSERDATA;

    public VmaDeviceMemoryCallbacks(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VmaDeviceMemoryCallbacks.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @Nullable
    @NativeType(value="PFN_vmaAllocateDeviceMemoryFunction")
    public VmaAllocateDeviceMemoryFunction pfnAllocate() {
        return VmaDeviceMemoryCallbacks.npfnAllocate(this.address());
    }

    @Nullable
    @NativeType(value="PFN_vmaFreeDeviceMemoryFunction")
    public VmaFreeDeviceMemoryFunction pfnFree() {
        return VmaDeviceMemoryCallbacks.npfnFree(this.address());
    }

    @NativeType(value="void *")
    public long pUserData() {
        return VmaDeviceMemoryCallbacks.npUserData(this.address());
    }

    public VmaDeviceMemoryCallbacks pfnAllocate(@Nullable @NativeType(value="PFN_vmaAllocateDeviceMemoryFunction") VmaAllocateDeviceMemoryFunctionI value) {
        VmaDeviceMemoryCallbacks.npfnAllocate(this.address(), value);
        return this;
    }

    public VmaDeviceMemoryCallbacks pfnFree(@Nullable @NativeType(value="PFN_vmaFreeDeviceMemoryFunction") VmaFreeDeviceMemoryFunctionI value) {
        VmaDeviceMemoryCallbacks.npfnFree(this.address(), value);
        return this;
    }

    public VmaDeviceMemoryCallbacks pUserData(@NativeType(value="void *") long value) {
        VmaDeviceMemoryCallbacks.npUserData(this.address(), value);
        return this;
    }

    public VmaDeviceMemoryCallbacks set(VmaAllocateDeviceMemoryFunctionI pfnAllocate, VmaFreeDeviceMemoryFunctionI pfnFree, long pUserData) {
        this.pfnAllocate(pfnAllocate);
        this.pfnFree(pfnFree);
        this.pUserData(pUserData);
        return this;
    }

    public VmaDeviceMemoryCallbacks set(VmaDeviceMemoryCallbacks src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VmaDeviceMemoryCallbacks malloc() {
        return VmaDeviceMemoryCallbacks.wrap(VmaDeviceMemoryCallbacks.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VmaDeviceMemoryCallbacks calloc() {
        return VmaDeviceMemoryCallbacks.wrap(VmaDeviceMemoryCallbacks.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VmaDeviceMemoryCallbacks create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VmaDeviceMemoryCallbacks.wrap(VmaDeviceMemoryCallbacks.class, MemoryUtil.memAddress(container), container);
    }

    public static VmaDeviceMemoryCallbacks create(long address) {
        return VmaDeviceMemoryCallbacks.wrap(VmaDeviceMemoryCallbacks.class, address);
    }

    @Nullable
    public static VmaDeviceMemoryCallbacks createSafe(long address) {
        return address == 0L ? null : VmaDeviceMemoryCallbacks.wrap(VmaDeviceMemoryCallbacks.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VmaDeviceMemoryCallbacks.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VmaDeviceMemoryCallbacks.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VmaDeviceMemoryCallbacks.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaDeviceMemoryCallbacks.__create(capacity, SIZEOF);
        return VmaDeviceMemoryCallbacks.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VmaDeviceMemoryCallbacks.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VmaDeviceMemoryCallbacks.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VmaDeviceMemoryCallbacks mallocStack() {
        return VmaDeviceMemoryCallbacks.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaDeviceMemoryCallbacks callocStack() {
        return VmaDeviceMemoryCallbacks.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaDeviceMemoryCallbacks mallocStack(MemoryStack stack) {
        return VmaDeviceMemoryCallbacks.malloc(stack);
    }

    @Deprecated
    public static VmaDeviceMemoryCallbacks callocStack(MemoryStack stack) {
        return VmaDeviceMemoryCallbacks.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VmaDeviceMemoryCallbacks.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VmaDeviceMemoryCallbacks.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaDeviceMemoryCallbacks.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaDeviceMemoryCallbacks.calloc(capacity, stack);
    }

    public static VmaDeviceMemoryCallbacks malloc(MemoryStack stack) {
        return VmaDeviceMemoryCallbacks.wrap(VmaDeviceMemoryCallbacks.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaDeviceMemoryCallbacks calloc(MemoryStack stack) {
        return VmaDeviceMemoryCallbacks.wrap(VmaDeviceMemoryCallbacks.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VmaDeviceMemoryCallbacks.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VmaDeviceMemoryCallbacks.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    @Nullable
    public static VmaAllocateDeviceMemoryFunction npfnAllocate(long struct) {
        return VmaAllocateDeviceMemoryFunction.createSafe(MemoryUtil.memGetAddress(struct + (long)PFNALLOCATE));
    }

    @Nullable
    public static VmaFreeDeviceMemoryFunction npfnFree(long struct) {
        return VmaFreeDeviceMemoryFunction.createSafe(MemoryUtil.memGetAddress(struct + (long)PFNFREE));
    }

    public static long npUserData(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PUSERDATA);
    }

    public static void npfnAllocate(long struct, @Nullable VmaAllocateDeviceMemoryFunctionI value) {
        MemoryUtil.memPutAddress(struct + (long)PFNALLOCATE, MemoryUtil.memAddressSafe(value));
    }

    public static void npfnFree(long struct, @Nullable VmaFreeDeviceMemoryFunctionI value) {
        MemoryUtil.memPutAddress(struct + (long)PFNFREE, MemoryUtil.memAddressSafe(value));
    }

    public static void npUserData(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PUSERDATA, value);
    }

    static {
        Struct.Layout layout = VmaDeviceMemoryCallbacks.__struct(VmaDeviceMemoryCallbacks.__member(POINTER_SIZE), VmaDeviceMemoryCallbacks.__member(POINTER_SIZE), VmaDeviceMemoryCallbacks.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PFNALLOCATE = layout.offsetof(0);
        PFNFREE = layout.offsetof(1);
        PUSERDATA = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VmaDeviceMemoryCallbacks, Buffer>
    implements NativeResource {
        private static final VmaDeviceMemoryCallbacks ELEMENT_FACTORY = VmaDeviceMemoryCallbacks.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VmaDeviceMemoryCallbacks getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Nullable
        @NativeType(value="PFN_vmaAllocateDeviceMemoryFunction")
        public VmaAllocateDeviceMemoryFunction pfnAllocate() {
            return VmaDeviceMemoryCallbacks.npfnAllocate(this.address());
        }

        @Nullable
        @NativeType(value="PFN_vmaFreeDeviceMemoryFunction")
        public VmaFreeDeviceMemoryFunction pfnFree() {
            return VmaDeviceMemoryCallbacks.npfnFree(this.address());
        }

        @NativeType(value="void *")
        public long pUserData() {
            return VmaDeviceMemoryCallbacks.npUserData(this.address());
        }

        public Buffer pfnAllocate(@Nullable @NativeType(value="PFN_vmaAllocateDeviceMemoryFunction") VmaAllocateDeviceMemoryFunctionI value) {
            VmaDeviceMemoryCallbacks.npfnAllocate(this.address(), value);
            return this;
        }

        public Buffer pfnFree(@Nullable @NativeType(value="PFN_vmaFreeDeviceMemoryFunction") VmaFreeDeviceMemoryFunctionI value) {
            VmaDeviceMemoryCallbacks.npfnFree(this.address(), value);
            return this;
        }

        public Buffer pUserData(@NativeType(value="void *") long value) {
            VmaDeviceMemoryCallbacks.npUserData(this.address(), value);
            return this;
        }
    }
}

