/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.vma.VmaStatInfo;

public class VmaStats
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MEMORYTYPE;
    public static final int MEMORYHEAP;
    public static final int TOTAL;

    public VmaStats(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VmaStats.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VmaStatInfo[32]")
    public VmaStatInfo.Buffer memoryType() {
        return VmaStats.nmemoryType(this.address());
    }

    public VmaStatInfo memoryType(int index) {
        return VmaStats.nmemoryType(this.address(), index);
    }

    @NativeType(value="VmaStatInfo[16]")
    public VmaStatInfo.Buffer memoryHeap() {
        return VmaStats.nmemoryHeap(this.address());
    }

    public VmaStatInfo memoryHeap(int index) {
        return VmaStats.nmemoryHeap(this.address(), index);
    }

    public VmaStatInfo total() {
        return VmaStats.ntotal(this.address());
    }

    public static VmaStats malloc() {
        return VmaStats.wrap(VmaStats.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VmaStats calloc() {
        return VmaStats.wrap(VmaStats.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VmaStats create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VmaStats.wrap(VmaStats.class, MemoryUtil.memAddress(container), container);
    }

    public static VmaStats create(long address) {
        return VmaStats.wrap(VmaStats.class, address);
    }

    @Nullable
    public static VmaStats createSafe(long address) {
        return address == 0L ? null : VmaStats.wrap(VmaStats.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VmaStats.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VmaStats.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VmaStats.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaStats.__create(capacity, SIZEOF);
        return VmaStats.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VmaStats.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VmaStats.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VmaStats mallocStack() {
        return VmaStats.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaStats callocStack() {
        return VmaStats.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaStats mallocStack(MemoryStack stack) {
        return VmaStats.malloc(stack);
    }

    @Deprecated
    public static VmaStats callocStack(MemoryStack stack) {
        return VmaStats.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VmaStats.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VmaStats.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaStats.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaStats.calloc(capacity, stack);
    }

    public static VmaStats malloc(MemoryStack stack) {
        return VmaStats.wrap(VmaStats.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaStats calloc(MemoryStack stack) {
        return VmaStats.wrap(VmaStats.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VmaStats.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VmaStats.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VmaStatInfo.Buffer nmemoryType(long struct) {
        return VmaStatInfo.create(struct + (long)MEMORYTYPE, 32);
    }

    public static VmaStatInfo nmemoryType(long struct, int index) {
        return VmaStatInfo.create(struct + (long)MEMORYTYPE + Checks.check(index, 32) * (long)VmaStatInfo.SIZEOF);
    }

    public static VmaStatInfo.Buffer nmemoryHeap(long struct) {
        return VmaStatInfo.create(struct + (long)MEMORYHEAP, 16);
    }

    public static VmaStatInfo nmemoryHeap(long struct, int index) {
        return VmaStatInfo.create(struct + (long)MEMORYHEAP + Checks.check(index, 16) * (long)VmaStatInfo.SIZEOF);
    }

    public static VmaStatInfo ntotal(long struct) {
        return VmaStatInfo.create(struct + (long)TOTAL);
    }

    static {
        Struct.Layout layout = VmaStats.__struct(VmaStats.__array(VmaStatInfo.SIZEOF, VmaStatInfo.ALIGNOF, 32), VmaStats.__array(VmaStatInfo.SIZEOF, VmaStatInfo.ALIGNOF, 16), VmaStats.__member(VmaStatInfo.SIZEOF, VmaStatInfo.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MEMORYTYPE = layout.offsetof(0);
        MEMORYHEAP = layout.offsetof(1);
        TOTAL = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VmaStats, Buffer>
    implements NativeResource {
        private static final VmaStats ELEMENT_FACTORY = VmaStats.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VmaStats getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VmaStatInfo[32]")
        public VmaStatInfo.Buffer memoryType() {
            return VmaStats.nmemoryType(this.address());
        }

        public VmaStatInfo memoryType(int index) {
            return VmaStats.nmemoryType(this.address(), index);
        }

        @NativeType(value="VmaStatInfo[16]")
        public VmaStatInfo.Buffer memoryHeap() {
            return VmaStats.nmemoryHeap(this.address());
        }

        public VmaStatInfo memoryHeap(int index) {
            return VmaStats.nmemoryHeap(this.address(), index);
        }

        public VmaStatInfo total() {
            return VmaStats.ntotal(this.address());
        }
    }
}

