/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAllocationCallbacks;

public class VmaVirtualBlockCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int FLAGS;
    public static final int PALLOCATIONCALLBACKS;

    public VmaVirtualBlockCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VmaVirtualBlockCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VmaVirtualBlockCreateInfo.nsize(this.address());
    }

    @NativeType(value="VmaVirtualBlockCreateFlagBits")
    public int flags() {
        return VmaVirtualBlockCreateInfo.nflags(this.address());
    }

    @Nullable
    @NativeType(value="VkAllocationCallbacks const *")
    public VkAllocationCallbacks pAllocationCallbacks() {
        return VmaVirtualBlockCreateInfo.npAllocationCallbacks(this.address());
    }

    public VmaVirtualBlockCreateInfo size(@NativeType(value="VkDeviceSize") long value) {
        VmaVirtualBlockCreateInfo.nsize(this.address(), value);
        return this;
    }

    public VmaVirtualBlockCreateInfo flags(@NativeType(value="VmaVirtualBlockCreateFlagBits") int value) {
        VmaVirtualBlockCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VmaVirtualBlockCreateInfo pAllocationCallbacks(@Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks value) {
        VmaVirtualBlockCreateInfo.npAllocationCallbacks(this.address(), value);
        return this;
    }

    public VmaVirtualBlockCreateInfo set(long size, int flags, @Nullable VkAllocationCallbacks pAllocationCallbacks) {
        this.size(size);
        this.flags(flags);
        this.pAllocationCallbacks(pAllocationCallbacks);
        return this;
    }

    public VmaVirtualBlockCreateInfo set(VmaVirtualBlockCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VmaVirtualBlockCreateInfo malloc() {
        return VmaVirtualBlockCreateInfo.wrap(VmaVirtualBlockCreateInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VmaVirtualBlockCreateInfo calloc() {
        return VmaVirtualBlockCreateInfo.wrap(VmaVirtualBlockCreateInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VmaVirtualBlockCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VmaVirtualBlockCreateInfo.wrap(VmaVirtualBlockCreateInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VmaVirtualBlockCreateInfo create(long address) {
        return VmaVirtualBlockCreateInfo.wrap(VmaVirtualBlockCreateInfo.class, address);
    }

    @Nullable
    public static VmaVirtualBlockCreateInfo createSafe(long address) {
        return address == 0L ? null : VmaVirtualBlockCreateInfo.wrap(VmaVirtualBlockCreateInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VmaVirtualBlockCreateInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VmaVirtualBlockCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VmaVirtualBlockCreateInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaVirtualBlockCreateInfo.__create(capacity, SIZEOF);
        return VmaVirtualBlockCreateInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VmaVirtualBlockCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VmaVirtualBlockCreateInfo.wrap(Buffer.class, address, capacity);
    }

    public static VmaVirtualBlockCreateInfo malloc(MemoryStack stack) {
        return VmaVirtualBlockCreateInfo.wrap(VmaVirtualBlockCreateInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaVirtualBlockCreateInfo calloc(MemoryStack stack) {
        return VmaVirtualBlockCreateInfo.wrap(VmaVirtualBlockCreateInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VmaVirtualBlockCreateInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VmaVirtualBlockCreateInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    @Nullable
    public static VkAllocationCallbacks npAllocationCallbacks(long struct) {
        return VkAllocationCallbacks.createSafe(MemoryUtil.memGetAddress(struct + (long)PALLOCATIONCALLBACKS));
    }

    public static void nsize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SIZE, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void npAllocationCallbacks(long struct, @Nullable VkAllocationCallbacks value) {
        MemoryUtil.memPutAddress(struct + (long)PALLOCATIONCALLBACKS, MemoryUtil.memAddressSafe(value));
    }

    static {
        Struct.Layout layout = VmaVirtualBlockCreateInfo.__struct(VmaVirtualBlockCreateInfo.__member(8), VmaVirtualBlockCreateInfo.__member(4), VmaVirtualBlockCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZE = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
        PALLOCATIONCALLBACKS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VmaVirtualBlockCreateInfo, Buffer>
    implements NativeResource {
        private static final VmaVirtualBlockCreateInfo ELEMENT_FACTORY = VmaVirtualBlockCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VmaVirtualBlockCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VmaVirtualBlockCreateInfo.nsize(this.address());
        }

        @NativeType(value="VmaVirtualBlockCreateFlagBits")
        public int flags() {
            return VmaVirtualBlockCreateInfo.nflags(this.address());
        }

        @Nullable
        @NativeType(value="VkAllocationCallbacks const *")
        public VkAllocationCallbacks pAllocationCallbacks() {
            return VmaVirtualBlockCreateInfo.npAllocationCallbacks(this.address());
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VmaVirtualBlockCreateInfo.nsize(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VmaVirtualBlockCreateFlagBits") int value) {
            VmaVirtualBlockCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pAllocationCallbacks(@Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks value) {
            VmaVirtualBlockCreateInfo.npAllocationCallbacks(this.address(), value);
            return this;
        }
    }
}

