/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.zstd.ZSTDAllocFunction;
import org.lwjgl.util.zstd.ZSTDAllocFunctionI;
import org.lwjgl.util.zstd.ZSTDFreeFunction;
import org.lwjgl.util.zstd.ZSTDFreeFunctionI;

@NativeType(value="struct ZSTD_customMem")
public class ZSTDCustomMem
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CUSTOMALLOC;
    public static final int CUSTOMFREE;
    public static final int OPAQUE;

    public ZSTDCustomMem(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), ZSTDCustomMem.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ZSTD_allocFunction")
    public ZSTDAllocFunction customAlloc() {
        return ZSTDCustomMem.ncustomAlloc(this.address());
    }

    @NativeType(value="ZSTD_freeFunction")
    public ZSTDFreeFunction customFree() {
        return ZSTDCustomMem.ncustomFree(this.address());
    }

    @NativeType(value="void *")
    public long opaque() {
        return ZSTDCustomMem.nopaque(this.address());
    }

    public ZSTDCustomMem customAlloc(@NativeType(value="ZSTD_allocFunction") ZSTDAllocFunctionI value) {
        ZSTDCustomMem.ncustomAlloc(this.address(), value);
        return this;
    }

    public ZSTDCustomMem customFree(@NativeType(value="ZSTD_freeFunction") ZSTDFreeFunctionI value) {
        ZSTDCustomMem.ncustomFree(this.address(), value);
        return this;
    }

    public ZSTDCustomMem opaque(@NativeType(value="void *") long value) {
        ZSTDCustomMem.nopaque(this.address(), value);
        return this;
    }

    public ZSTDCustomMem set(ZSTDAllocFunctionI customAlloc, ZSTDFreeFunctionI customFree, long opaque) {
        this.customAlloc(customAlloc);
        this.customFree(customFree);
        this.opaque(opaque);
        return this;
    }

    public ZSTDCustomMem set(ZSTDCustomMem src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static ZSTDCustomMem malloc() {
        return ZSTDCustomMem.wrap(ZSTDCustomMem.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static ZSTDCustomMem calloc() {
        return ZSTDCustomMem.wrap(ZSTDCustomMem.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static ZSTDCustomMem create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return ZSTDCustomMem.wrap(ZSTDCustomMem.class, MemoryUtil.memAddress(container), container);
    }

    public static ZSTDCustomMem create(long address) {
        return ZSTDCustomMem.wrap(ZSTDCustomMem.class, address);
    }

    @Nullable
    public static ZSTDCustomMem createSafe(long address) {
        return address == 0L ? null : ZSTDCustomMem.wrap(ZSTDCustomMem.class, address);
    }

    public static Buffer malloc(int capacity) {
        return ZSTDCustomMem.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(ZSTDCustomMem.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return ZSTDCustomMem.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZSTDCustomMem.__create(capacity, SIZEOF);
        return ZSTDCustomMem.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return ZSTDCustomMem.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : ZSTDCustomMem.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static ZSTDCustomMem mallocStack() {
        return ZSTDCustomMem.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDCustomMem callocStack() {
        return ZSTDCustomMem.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDCustomMem mallocStack(MemoryStack stack) {
        return ZSTDCustomMem.malloc(stack);
    }

    @Deprecated
    public static ZSTDCustomMem callocStack(MemoryStack stack) {
        return ZSTDCustomMem.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ZSTDCustomMem.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ZSTDCustomMem.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZSTDCustomMem.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZSTDCustomMem.calloc(capacity, stack);
    }

    public static ZSTDCustomMem malloc(MemoryStack stack) {
        return ZSTDCustomMem.wrap(ZSTDCustomMem.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ZSTDCustomMem calloc(MemoryStack stack) {
        return ZSTDCustomMem.wrap(ZSTDCustomMem.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return ZSTDCustomMem.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return ZSTDCustomMem.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ZSTDAllocFunction ncustomAlloc(long struct) {
        return ZSTDAllocFunction.create(MemoryUtil.memGetAddress(struct + (long)CUSTOMALLOC));
    }

    public static ZSTDFreeFunction ncustomFree(long struct) {
        return ZSTDFreeFunction.create(MemoryUtil.memGetAddress(struct + (long)CUSTOMFREE));
    }

    public static long nopaque(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)OPAQUE);
    }

    public static void ncustomAlloc(long struct, ZSTDAllocFunctionI value) {
        MemoryUtil.memPutAddress(struct + (long)CUSTOMALLOC, value.address());
    }

    public static void ncustomFree(long struct, ZSTDFreeFunctionI value) {
        MemoryUtil.memPutAddress(struct + (long)CUSTOMFREE, value.address());
    }

    public static void nopaque(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)OPAQUE, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CUSTOMALLOC));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CUSTOMFREE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)OPAQUE));
    }

    static {
        Struct.Layout layout = ZSTDCustomMem.__struct(ZSTDCustomMem.__member(POINTER_SIZE), ZSTDCustomMem.__member(POINTER_SIZE), ZSTDCustomMem.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CUSTOMALLOC = layout.offsetof(0);
        CUSTOMFREE = layout.offsetof(1);
        OPAQUE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<ZSTDCustomMem, Buffer>
    implements NativeResource {
        private static final ZSTDCustomMem ELEMENT_FACTORY = ZSTDCustomMem.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected ZSTDCustomMem getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ZSTD_allocFunction")
        public ZSTDAllocFunction customAlloc() {
            return ZSTDCustomMem.ncustomAlloc(this.address());
        }

        @NativeType(value="ZSTD_freeFunction")
        public ZSTDFreeFunction customFree() {
            return ZSTDCustomMem.ncustomFree(this.address());
        }

        @NativeType(value="void *")
        public long opaque() {
            return ZSTDCustomMem.nopaque(this.address());
        }

        public Buffer customAlloc(@NativeType(value="ZSTD_allocFunction") ZSTDAllocFunctionI value) {
            ZSTDCustomMem.ncustomAlloc(this.address(), value);
            return this;
        }

        public Buffer customFree(@NativeType(value="ZSTD_freeFunction") ZSTDFreeFunctionI value) {
            ZSTDCustomMem.ncustomFree(this.address(), value);
            return this;
        }

        public Buffer opaque(@NativeType(value="void *") long value) {
            ZSTDCustomMem.nopaque(this.address(), value);
            return this;
        }
    }
}

