/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ZSTD_frameParameters")
public class ZSTDFrameParameters
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CONTENTSIZEFLAG;
    public static final int CHECKSUMFLAG;
    public static final int NODICTIDFLAG;

    public ZSTDFrameParameters(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), ZSTDFrameParameters.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int contentSizeFlag() {
        return ZSTDFrameParameters.ncontentSizeFlag(this.address());
    }

    public int checksumFlag() {
        return ZSTDFrameParameters.nchecksumFlag(this.address());
    }

    public int noDictIDFlag() {
        return ZSTDFrameParameters.nnoDictIDFlag(this.address());
    }

    public ZSTDFrameParameters contentSizeFlag(int value) {
        ZSTDFrameParameters.ncontentSizeFlag(this.address(), value);
        return this;
    }

    public ZSTDFrameParameters checksumFlag(int value) {
        ZSTDFrameParameters.nchecksumFlag(this.address(), value);
        return this;
    }

    public ZSTDFrameParameters noDictIDFlag(int value) {
        ZSTDFrameParameters.nnoDictIDFlag(this.address(), value);
        return this;
    }

    public ZSTDFrameParameters set(int contentSizeFlag, int checksumFlag, int noDictIDFlag) {
        this.contentSizeFlag(contentSizeFlag);
        this.checksumFlag(checksumFlag);
        this.noDictIDFlag(noDictIDFlag);
        return this;
    }

    public ZSTDFrameParameters set(ZSTDFrameParameters src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static ZSTDFrameParameters malloc() {
        return ZSTDFrameParameters.wrap(ZSTDFrameParameters.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static ZSTDFrameParameters calloc() {
        return ZSTDFrameParameters.wrap(ZSTDFrameParameters.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static ZSTDFrameParameters create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return ZSTDFrameParameters.wrap(ZSTDFrameParameters.class, MemoryUtil.memAddress(container), container);
    }

    public static ZSTDFrameParameters create(long address) {
        return ZSTDFrameParameters.wrap(ZSTDFrameParameters.class, address);
    }

    @Nullable
    public static ZSTDFrameParameters createSafe(long address) {
        return address == 0L ? null : ZSTDFrameParameters.wrap(ZSTDFrameParameters.class, address);
    }

    public static Buffer malloc(int capacity) {
        return ZSTDFrameParameters.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(ZSTDFrameParameters.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return ZSTDFrameParameters.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZSTDFrameParameters.__create(capacity, SIZEOF);
        return ZSTDFrameParameters.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return ZSTDFrameParameters.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : ZSTDFrameParameters.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static ZSTDFrameParameters mallocStack() {
        return ZSTDFrameParameters.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDFrameParameters callocStack() {
        return ZSTDFrameParameters.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDFrameParameters mallocStack(MemoryStack stack) {
        return ZSTDFrameParameters.malloc(stack);
    }

    @Deprecated
    public static ZSTDFrameParameters callocStack(MemoryStack stack) {
        return ZSTDFrameParameters.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ZSTDFrameParameters.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ZSTDFrameParameters.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZSTDFrameParameters.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZSTDFrameParameters.calloc(capacity, stack);
    }

    public static ZSTDFrameParameters malloc(MemoryStack stack) {
        return ZSTDFrameParameters.wrap(ZSTDFrameParameters.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ZSTDFrameParameters calloc(MemoryStack stack) {
        return ZSTDFrameParameters.wrap(ZSTDFrameParameters.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return ZSTDFrameParameters.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return ZSTDFrameParameters.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ncontentSizeFlag(long struct) {
        return UNSAFE.getInt(null, struct + (long)CONTENTSIZEFLAG);
    }

    public static int nchecksumFlag(long struct) {
        return UNSAFE.getInt(null, struct + (long)CHECKSUMFLAG);
    }

    public static int nnoDictIDFlag(long struct) {
        return UNSAFE.getInt(null, struct + (long)NODICTIDFLAG);
    }

    public static void ncontentSizeFlag(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CONTENTSIZEFLAG, value);
    }

    public static void nchecksumFlag(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CHECKSUMFLAG, value);
    }

    public static void nnoDictIDFlag(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NODICTIDFLAG, value);
    }

    static {
        Struct.Layout layout = ZSTDFrameParameters.__struct(ZSTDFrameParameters.__member(4), ZSTDFrameParameters.__member(4), ZSTDFrameParameters.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CONTENTSIZEFLAG = layout.offsetof(0);
        CHECKSUMFLAG = layout.offsetof(1);
        NODICTIDFLAG = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<ZSTDFrameParameters, Buffer>
    implements NativeResource {
        private static final ZSTDFrameParameters ELEMENT_FACTORY = ZSTDFrameParameters.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected ZSTDFrameParameters getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int contentSizeFlag() {
            return ZSTDFrameParameters.ncontentSizeFlag(this.address());
        }

        public int checksumFlag() {
            return ZSTDFrameParameters.nchecksumFlag(this.address());
        }

        public int noDictIDFlag() {
            return ZSTDFrameParameters.nnoDictIDFlag(this.address());
        }

        public Buffer contentSizeFlag(int value) {
            ZSTDFrameParameters.ncontentSizeFlag(this.address(), value);
            return this;
        }

        public Buffer checksumFlag(int value) {
            ZSTDFrameParameters.nchecksumFlag(this.address(), value);
            return this;
        }

        public Buffer noDictIDFlag(int value) {
            ZSTDFrameParameters.nnoDictIDFlag(this.address(), value);
            return this;
        }
    }
}

