/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ZSTD_inBuffer")
public class ZSTDInBuffer
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SRC;
    public static final int SIZE;
    public static final int POS;

    public ZSTDInBuffer(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), ZSTDInBuffer.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void const *")
    public ByteBuffer src() {
        return ZSTDInBuffer.nsrc(this.address());
    }

    @NativeType(value="size_t")
    public long size() {
        return ZSTDInBuffer.nsize(this.address());
    }

    @NativeType(value="size_t")
    public long pos() {
        return ZSTDInBuffer.npos(this.address());
    }

    public ZSTDInBuffer src(@NativeType(value="void const *") ByteBuffer value) {
        ZSTDInBuffer.nsrc(this.address(), value);
        return this;
    }

    public ZSTDInBuffer pos(@NativeType(value="size_t") long value) {
        ZSTDInBuffer.npos(this.address(), value);
        return this;
    }

    public ZSTDInBuffer set(ByteBuffer src, long pos) {
        this.src(src);
        this.pos(pos);
        return this;
    }

    public ZSTDInBuffer set(ZSTDInBuffer src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static ZSTDInBuffer malloc() {
        return ZSTDInBuffer.wrap(ZSTDInBuffer.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static ZSTDInBuffer calloc() {
        return ZSTDInBuffer.wrap(ZSTDInBuffer.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static ZSTDInBuffer create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return ZSTDInBuffer.wrap(ZSTDInBuffer.class, MemoryUtil.memAddress(container), container);
    }

    public static ZSTDInBuffer create(long address) {
        return ZSTDInBuffer.wrap(ZSTDInBuffer.class, address);
    }

    @Nullable
    public static ZSTDInBuffer createSafe(long address) {
        return address == 0L ? null : ZSTDInBuffer.wrap(ZSTDInBuffer.class, address);
    }

    public static Buffer malloc(int capacity) {
        return ZSTDInBuffer.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(ZSTDInBuffer.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return ZSTDInBuffer.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZSTDInBuffer.__create(capacity, SIZEOF);
        return ZSTDInBuffer.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return ZSTDInBuffer.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : ZSTDInBuffer.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static ZSTDInBuffer mallocStack() {
        return ZSTDInBuffer.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDInBuffer callocStack() {
        return ZSTDInBuffer.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDInBuffer mallocStack(MemoryStack stack) {
        return ZSTDInBuffer.malloc(stack);
    }

    @Deprecated
    public static ZSTDInBuffer callocStack(MemoryStack stack) {
        return ZSTDInBuffer.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ZSTDInBuffer.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ZSTDInBuffer.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZSTDInBuffer.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZSTDInBuffer.calloc(capacity, stack);
    }

    public static ZSTDInBuffer malloc(MemoryStack stack) {
        return ZSTDInBuffer.wrap(ZSTDInBuffer.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ZSTDInBuffer calloc(MemoryStack stack) {
        return ZSTDInBuffer.wrap(ZSTDInBuffer.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return ZSTDInBuffer.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return ZSTDInBuffer.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nsrc(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)SRC), (int)ZSTDInBuffer.nsize(struct));
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SIZE);
    }

    public static long npos(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)POS);
    }

    public static void nsrc(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)SRC, MemoryUtil.memAddress(value));
        ZSTDInBuffer.nsize(struct, value.remaining());
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SIZE, value);
    }

    public static void npos(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)POS, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SRC));
    }

    static {
        Struct.Layout layout = ZSTDInBuffer.__struct(ZSTDInBuffer.__member(POINTER_SIZE), ZSTDInBuffer.__member(POINTER_SIZE), ZSTDInBuffer.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SRC = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        POS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<ZSTDInBuffer, Buffer>
    implements NativeResource {
        private static final ZSTDInBuffer ELEMENT_FACTORY = ZSTDInBuffer.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected ZSTDInBuffer getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void const *")
        public ByteBuffer src() {
            return ZSTDInBuffer.nsrc(this.address());
        }

        @NativeType(value="size_t")
        public long size() {
            return ZSTDInBuffer.nsize(this.address());
        }

        @NativeType(value="size_t")
        public long pos() {
            return ZSTDInBuffer.npos(this.address());
        }

        public Buffer src(@NativeType(value="void const *") ByteBuffer value) {
            ZSTDInBuffer.nsrc(this.address(), value);
            return this;
        }

        public Buffer pos(@NativeType(value="size_t") long value) {
            ZSTDInBuffer.npos(this.address(), value);
            return this;
        }
    }
}

