/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ZSTD_outBuffer")
public class ZSTDOutBuffer
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DST;
    public static final int SIZE;
    public static final int POS;

    public ZSTDOutBuffer(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), ZSTDOutBuffer.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public ByteBuffer dst() {
        return ZSTDOutBuffer.ndst(this.address());
    }

    @NativeType(value="size_t")
    public long size() {
        return ZSTDOutBuffer.nsize(this.address());
    }

    @NativeType(value="size_t")
    public long pos() {
        return ZSTDOutBuffer.npos(this.address());
    }

    public ZSTDOutBuffer dst(@NativeType(value="void *") ByteBuffer value) {
        ZSTDOutBuffer.ndst(this.address(), value);
        return this;
    }

    public ZSTDOutBuffer pos(@NativeType(value="size_t") long value) {
        ZSTDOutBuffer.npos(this.address(), value);
        return this;
    }

    public ZSTDOutBuffer set(ByteBuffer dst, long pos) {
        this.dst(dst);
        this.pos(pos);
        return this;
    }

    public ZSTDOutBuffer set(ZSTDOutBuffer src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static ZSTDOutBuffer malloc() {
        return ZSTDOutBuffer.wrap(ZSTDOutBuffer.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static ZSTDOutBuffer calloc() {
        return ZSTDOutBuffer.wrap(ZSTDOutBuffer.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static ZSTDOutBuffer create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return ZSTDOutBuffer.wrap(ZSTDOutBuffer.class, MemoryUtil.memAddress(container), container);
    }

    public static ZSTDOutBuffer create(long address) {
        return ZSTDOutBuffer.wrap(ZSTDOutBuffer.class, address);
    }

    @Nullable
    public static ZSTDOutBuffer createSafe(long address) {
        return address == 0L ? null : ZSTDOutBuffer.wrap(ZSTDOutBuffer.class, address);
    }

    public static Buffer malloc(int capacity) {
        return ZSTDOutBuffer.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(ZSTDOutBuffer.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return ZSTDOutBuffer.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZSTDOutBuffer.__create(capacity, SIZEOF);
        return ZSTDOutBuffer.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return ZSTDOutBuffer.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : ZSTDOutBuffer.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static ZSTDOutBuffer mallocStack() {
        return ZSTDOutBuffer.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDOutBuffer callocStack() {
        return ZSTDOutBuffer.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDOutBuffer mallocStack(MemoryStack stack) {
        return ZSTDOutBuffer.malloc(stack);
    }

    @Deprecated
    public static ZSTDOutBuffer callocStack(MemoryStack stack) {
        return ZSTDOutBuffer.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ZSTDOutBuffer.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ZSTDOutBuffer.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZSTDOutBuffer.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZSTDOutBuffer.calloc(capacity, stack);
    }

    public static ZSTDOutBuffer malloc(MemoryStack stack) {
        return ZSTDOutBuffer.wrap(ZSTDOutBuffer.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ZSTDOutBuffer calloc(MemoryStack stack) {
        return ZSTDOutBuffer.wrap(ZSTDOutBuffer.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return ZSTDOutBuffer.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return ZSTDOutBuffer.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndst(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)DST), (int)ZSTDOutBuffer.nsize(struct));
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SIZE);
    }

    public static long npos(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)POS);
    }

    public static void ndst(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)DST, MemoryUtil.memAddress(value));
        ZSTDOutBuffer.nsize(struct, value.remaining());
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SIZE, value);
    }

    public static void npos(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)POS, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)DST));
    }

    static {
        Struct.Layout layout = ZSTDOutBuffer.__struct(ZSTDOutBuffer.__member(POINTER_SIZE), ZSTDOutBuffer.__member(POINTER_SIZE), ZSTDOutBuffer.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DST = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        POS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<ZSTDOutBuffer, Buffer>
    implements NativeResource {
        private static final ZSTDOutBuffer ELEMENT_FACTORY = ZSTDOutBuffer.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected ZSTDOutBuffer getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public ByteBuffer dst() {
            return ZSTDOutBuffer.ndst(this.address());
        }

        @NativeType(value="size_t")
        public long size() {
            return ZSTDOutBuffer.nsize(this.address());
        }

        @NativeType(value="size_t")
        public long pos() {
            return ZSTDOutBuffer.npos(this.address());
        }

        public Buffer dst(@NativeType(value="void *") ByteBuffer value) {
            ZSTDOutBuffer.ndst(this.address(), value);
            return this;
        }

        public Buffer pos(@NativeType(value="size_t") long value) {
            ZSTDOutBuffer.npos(this.address(), value);
            return this;
        }
    }
}

