/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ZSTD_Sequence")
public class ZSTDSequence
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OFFSET;
    public static final int LITLENGTH;
    public static final int MATCHLENGTH;
    public static final int REP;

    public ZSTDSequence(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), ZSTDSequence.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int offset() {
        return ZSTDSequence.noffset(this.address());
    }

    @NativeType(value="unsigned int")
    public int litLength() {
        return ZSTDSequence.nlitLength(this.address());
    }

    @NativeType(value="unsigned int")
    public int matchLength() {
        return ZSTDSequence.nmatchLength(this.address());
    }

    @NativeType(value="unsigned int")
    public int rep() {
        return ZSTDSequence.nrep(this.address());
    }

    public static ZSTDSequence malloc() {
        return ZSTDSequence.wrap(ZSTDSequence.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static ZSTDSequence calloc() {
        return ZSTDSequence.wrap(ZSTDSequence.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static ZSTDSequence create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return ZSTDSequence.wrap(ZSTDSequence.class, MemoryUtil.memAddress(container), container);
    }

    public static ZSTDSequence create(long address) {
        return ZSTDSequence.wrap(ZSTDSequence.class, address);
    }

    @Nullable
    public static ZSTDSequence createSafe(long address) {
        return address == 0L ? null : ZSTDSequence.wrap(ZSTDSequence.class, address);
    }

    public static Buffer malloc(int capacity) {
        return ZSTDSequence.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(ZSTDSequence.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return ZSTDSequence.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZSTDSequence.__create(capacity, SIZEOF);
        return ZSTDSequence.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return ZSTDSequence.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : ZSTDSequence.wrap(Buffer.class, address, capacity);
    }

    public static ZSTDSequence malloc(MemoryStack stack) {
        return ZSTDSequence.wrap(ZSTDSequence.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ZSTDSequence calloc(MemoryStack stack) {
        return ZSTDSequence.wrap(ZSTDSequence.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return ZSTDSequence.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return ZSTDSequence.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int noffset(long struct) {
        return UNSAFE.getInt(null, struct + (long)OFFSET);
    }

    public static int nlitLength(long struct) {
        return UNSAFE.getInt(null, struct + (long)LITLENGTH);
    }

    public static int nmatchLength(long struct) {
        return UNSAFE.getInt(null, struct + (long)MATCHLENGTH);
    }

    public static int nrep(long struct) {
        return UNSAFE.getInt(null, struct + (long)REP);
    }

    static {
        Struct.Layout layout = ZSTDSequence.__struct(ZSTDSequence.__member(4), ZSTDSequence.__member(4), ZSTDSequence.__member(4), ZSTDSequence.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OFFSET = layout.offsetof(0);
        LITLENGTH = layout.offsetof(1);
        MATCHLENGTH = layout.offsetof(2);
        REP = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<ZSTDSequence, Buffer>
    implements NativeResource {
        private static final ZSTDSequence ELEMENT_FACTORY = ZSTDSequence.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected ZSTDSequence getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int offset() {
            return ZSTDSequence.noffset(this.address());
        }

        @NativeType(value="unsigned int")
        public int litLength() {
            return ZSTDSequence.nlitLength(this.address());
        }

        @NativeType(value="unsigned int")
        public int matchLength() {
            return ZSTDSequence.nmatchLength(this.address());
        }

        @NativeType(value="unsigned int")
        public int rep() {
            return ZSTDSequence.nrep(this.address());
        }
    }
}

