/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.vulkan.VK11;

public final class VK {
    @Nullable
    private static FunctionProvider functionProvider;
    @Nullable
    private static GlobalCommands globalCommands;

    private VK() {
    }

    public static void create() {
        SharedLibrary VK2;
        switch (Platform.get()) {
            case LINUX: {
                VK2 = Library.loadNative(VK.class, "org.lwjgl.vulkan", Configuration.VULKAN_LIBRARY_NAME, "libvulkan.so.1");
                break;
            }
            case WINDOWS: {
                VK2 = Library.loadNative(VK.class, "org.lwjgl.vulkan", Configuration.VULKAN_LIBRARY_NAME, "vulkan-1");
                break;
            }
            case MACOSX: {
                String override = Configuration.VULKAN_LIBRARY_NAME.get();
                if (override != null) {
                    VK2 = Library.loadNative(VK.class, "org.lwjgl.vulkan", override);
                    break;
                }
                try {
                    VK2 = Library.loadNative(VK.class, "org.lwjgl.vulkan", "MoltenVK", true);
                }
                catch (Throwable ignored) {
                    VK2 = Library.loadNative(VK.class, "org.lwjgl.vulkan", "libvulkan.1.dylib");
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        VK.create(VK2);
    }

    public static void create(String libName) {
        VK.create(Library.loadNative(VK.class, "org.lwjgl.vulkan", libName));
    }

    public static void create(FunctionProvider functionProvider) {
        if (VK.functionProvider != null) {
            throw new IllegalStateException("Vulkan has already been created.");
        }
        VK.functionProvider = functionProvider;
        globalCommands = new GlobalCommands(functionProvider);
    }

    public static void destroy() {
        if (functionProvider == null) {
            return;
        }
        if (functionProvider instanceof NativeResource) {
            ((NativeResource)((Object)functionProvider)).free();
        }
        functionProvider = null;
        globalCommands = null;
    }

    private static <T> T check(@Nullable T t) {
        if (t == null) {
            throw new IllegalStateException("Vulkan library has not been loaded.");
        }
        return t;
    }

    public static FunctionProvider getFunctionProvider() {
        return VK.check(functionProvider);
    }

    public static int getInstanceVersionSupported() {
        long EnumerateInstanceVersion = VK.getGlobalCommands().vkEnumerateInstanceVersion;
        if (EnumerateInstanceVersion != 0L) {
            try (MemoryStack stack = MemoryStack.stackPush();){
                IntBuffer pi = stack.callocInt(1);
                if (VK11.vkEnumerateInstanceVersion(pi) == 0) {
                    int n = pi.get(0);
                    return n;
                }
            }
        }
        return VK11.VK_API_VERSION_1_0;
    }

    static GlobalCommands getGlobalCommands() {
        return VK.check(globalCommands);
    }

    static Set<String> getEnabledExtensionSet(int apiVersion, @Nullable PointerBuffer extensionNames) {
        HashSet<String> enabledExtensions = new HashSet<String>(16);
        int majorVersion = VK11.VK_VERSION_MAJOR(apiVersion);
        int minorVersion = VK11.VK_VERSION_MINOR(apiVersion);
        int[] VK_VERSIONS = new int[]{3};
        int maxMajor = Math.min(majorVersion, VK_VERSIONS.length);
        for (int M = 1; M <= maxMajor; ++M) {
            int maxMinor = VK_VERSIONS[M - 1];
            if (M == majorVersion) {
                maxMinor = Math.min(minorVersion, maxMinor);
            }
            for (int m = 0; m <= maxMinor; ++m) {
                enabledExtensions.add(String.format("Vulkan%d%d", M, m));
            }
        }
        if (extensionNames != null) {
            for (int i = extensionNames.position(); i < extensionNames.limit(); ++i) {
                enabledExtensions.add(extensionNames.getStringUTF8(i));
            }
        }
        return enabledExtensions;
    }

    static {
        if (!Configuration.VULKAN_EXPLICIT_INIT.get(false).booleanValue()) {
            VK.create();
        }
    }

    static class GlobalCommands {
        final long vkGetInstanceProcAddr;
        final long vkCreateInstance;
        final long vkEnumerateInstanceExtensionProperties;
        final long vkEnumerateInstanceLayerProperties;
        final long vkEnumerateInstanceVersion;

        GlobalCommands(FunctionProvider library) {
            this.vkGetInstanceProcAddr = library.getFunctionAddress("vkGetInstanceProcAddr");
            if (this.vkGetInstanceProcAddr == 0L) {
                throw new IllegalArgumentException("A critical function is missing. Make sure that Vulkan is available.");
            }
            this.vkCreateInstance = this.getFunctionAddress("vkCreateInstance");
            this.vkEnumerateInstanceExtensionProperties = this.getFunctionAddress("vkEnumerateInstanceExtensionProperties");
            this.vkEnumerateInstanceLayerProperties = this.getFunctionAddress("vkEnumerateInstanceLayerProperties");
            this.vkEnumerateInstanceVersion = this.getFunctionAddress("vkEnumerateInstanceVersion", false);
        }

        private long getFunctionAddress(String name) {
            return this.getFunctionAddress(name, true);
        }

        private long getFunctionAddress(String name, boolean required) {
            try (MemoryStack stack = MemoryStack.stackPush();){
                long address = JNI.callPPP(0L, MemoryUtil.memAddress(stack.ASCII(name)), this.vkGetInstanceProcAddr);
                if (address == 0L && required) {
                    throw new IllegalArgumentException("A critical function is missing. Make sure that Vulkan is available.");
                }
                long l = address;
                return l;
            }
        }
    }
}

